% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsworks_operations.R
\name{opsworks_clone_stack}
\alias{opsworks_clone_stack}
\title{Creates a clone of a specified stack}
\usage{
opsworks_clone_stack(
  SourceStackId,
  Name = NULL,
  Region = NULL,
  VpcId = NULL,
  Attributes = NULL,
  ServiceRoleArn,
  DefaultInstanceProfileArn = NULL,
  DefaultOs = NULL,
  HostnameTheme = NULL,
  DefaultAvailabilityZone = NULL,
  DefaultSubnetId = NULL,
  CustomJson = NULL,
  ConfigurationManager = NULL,
  ChefConfiguration = NULL,
  UseCustomCookbooks = NULL,
  UseOpsworksSecurityGroups = NULL,
  CustomCookbooksSource = NULL,
  DefaultSshKeyName = NULL,
  ClonePermissions = NULL,
  CloneAppIds = NULL,
  DefaultRootDeviceType = NULL,
  AgentVersion = NULL
)
}
\arguments{
\item{SourceStackId}{[required] The source stack ID.}

\item{Name}{The cloned stack name. Stack names can be a maximum of 64 characters.}

\item{Region}{The cloned stack Amazon Web Services Region, such as \code{ap-northeast-2}.
For more information about Amazon Web Services Regions, see \href{https://docs.aws.amazon.com/general/latest/gr/rande.html}{Regions and Endpoints}.}

\item{VpcId}{The ID of the VPC that the cloned stack is to be launched into. It must
be in the specified region. All instances are launched into this VPC,
and you cannot change the ID later.
\itemize{
\item If your account supports EC2 Classic, the default value is no VPC.
\item If your account does not support EC2 Classic, the default value is
the default VPC for the specified region.
}

If the VPC ID corresponds to a default VPC and you have specified either
the \code{DefaultAvailabilityZone} or the \code{DefaultSubnetId} parameter only,
OpsWorks Stacks infers the value of the other parameter. If you specify
neither parameter, OpsWorks Stacks sets these parameters to the first
valid Availability Zone for the specified region and the corresponding
default VPC subnet ID, respectively.

If you specify a nondefault VPC ID, note the following:
\itemize{
\item It must belong to a VPC in your account that is in the specified
region.
\item You must specify a value for \code{DefaultSubnetId}.
}

For more information about how to use OpsWorks Stacks with a VPC, see
\href{https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-vpc.html}{Running a Stack in a VPC}.
For more information about default VPC and EC2 Classic, see \href{https://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/}{Supported Platforms}.}

\item{Attributes}{A list of stack attributes and values as key/value pairs to be added to
the cloned stack.}

\item{ServiceRoleArn}{[required] The stack Identity and Access Management (IAM) role, which allows
OpsWorks Stacks to work with Amazon Web Services resources on your
behalf. You must set this parameter to the Amazon Resource Name (ARN)
for an existing IAM role. If you create a stack by using the OpsWorkss
Stacks console, it creates the role for you. You can obtain an existing
stack's IAM ARN programmatically by calling
\code{\link[=opsworks_describe_permissions]{describe_permissions}}. For more
information about IAM ARNs, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html}{Using Identifiers}.

You must set this parameter to a valid service role ARN or the action
will fail; there is no default value. You can specify the source stack's
service role ARN, if you prefer, but you must do so explicitly.}

\item{DefaultInstanceProfileArn}{The Amazon Resource Name (ARN) of an IAM profile that is the default
profile for all of the stack's EC2 instances. For more information about
IAM ARNs, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html}{Using Identifiers}.}

\item{DefaultOs}{The stack's operating system, which must be set to one of the following.
\itemize{
\item A supported Linux operating system: An Amazon Linux version, such as
\verb{Amazon Linux 2}, \verb{Amazon Linux 2018.03}, \verb{Amazon Linux 2017.09},
\verb{Amazon Linux 2017.03}, \verb{Amazon Linux 2016.09},
\verb{Amazon Linux 2016.03}, \verb{Amazon Linux 2015.09}, or
\verb{Amazon Linux 2015.03}.
\item A supported Ubuntu operating system, such as \verb{Ubuntu 18.04 LTS},
\verb{Ubuntu 16.04 LTS}, \verb{Ubuntu 14.04 LTS}, or \verb{Ubuntu 12.04 LTS}.
\item \verb{CentOS Linux 7}
\item \verb{Red Hat Enterprise Linux 7}
\item \verb{Microsoft Windows Server 2012 R2 Base},
\verb{Microsoft Windows Server 2012 R2 with SQL Server Express},
\verb{Microsoft Windows Server 2012 R2 with SQL Server Standard}, or
\verb{Microsoft Windows Server 2012 R2 with SQL Server Web}.
\item A custom AMI: \code{Custom}. You specify the custom AMI you want to use
when you create instances. For more information about how to use
custom AMIs with OpsWorks, see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html}{Using Custom AMIs}.
}

The default option is the parent stack's operating system. Not all
operating systems are supported with all versions of Chef. For more
information about supported operating systems, see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html}{OpsWorks Stacks Operating Systems}.

You can specify a different Linux operating system for the cloned stack,
but you cannot change from Linux to Windows or Windows to Linux.}

\item{HostnameTheme}{The stack's host name theme, with spaces are replaced by underscores.
The theme is used to generate host names for the stack's instances. By
default, \code{HostnameTheme} is set to \code{Layer_Dependent}, which creates host
names by appending integers to the layer's short name. The other themes
are:
\itemize{
\item \code{Baked_Goods}
\item \code{Clouds}
\item \code{Europe_Cities}
\item \code{Fruits}
\item \code{Greek_Deities_and_Titans}
\item \code{Legendary_creatures_from_Japan}
\item \code{Planets_and_Moons}
\item \code{Roman_Deities}
\item \code{Scottish_Islands}
\item \code{US_Cities}
\item \code{Wild_Cats}
}

To obtain a generated host name, call \code{GetHostNameSuggestion}, which
returns a host name based on the current theme.}

\item{DefaultAvailabilityZone}{The cloned stack's default Availability Zone, which must be in the
specified region. For more information, see \href{https://docs.aws.amazon.com/general/latest/gr/rande.html}{Regions and Endpoints}. If
you also specify a value for \code{DefaultSubnetId}, the subnet must be in
the same zone. For more information, see the \code{VpcId} parameter
description.}

\item{DefaultSubnetId}{The stack's default VPC subnet ID. This parameter is required if you
specify a value for the \code{VpcId} parameter. All instances are launched
into this subnet unless you specify otherwise when you create the
instance. If you also specify a value for \code{DefaultAvailabilityZone}, the
subnet must be in that zone. For information on default values and when
this parameter is required, see the \code{VpcId} parameter description.}

\item{CustomJson}{A string that contains user-defined, custom JSON. It is used to override
the corresponding default stack configuration JSON values. The string
should be in the following format:

\verb{"\{\\"key1\\": \\"value1\\", \\"key2\\": \\"value2\\",...\}"}

For more information about custom JSON, see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html}{Use Custom JSON to Modify the Stack Configuration Attributes}}

\item{ConfigurationManager}{The configuration manager. When you clone a stack we recommend that you
use the configuration manager to specify the Chef version: 12, 11.10, or
11.4 for Linux stacks, or 12.2 for Windows stacks. The default value for
Linux stacks is currently 12.}

\item{ChefConfiguration}{A \code{ChefConfiguration} object that specifies whether to enable Berkshelf
and the Berkshelf version on Chef 11.10 stacks. For more information,
see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html}{Create a New Stack}.}

\item{UseCustomCookbooks}{Whether to use custom cookbooks.}

\item{UseOpsworksSecurityGroups}{Whether to associate the OpsWorks Stacks built-in security groups with
the stack's layers.

OpsWorks Stacks provides a standard set of security groups, one for each
layer, which are associated with layers by default. With
\code{UseOpsworksSecurityGroups} you can instead provide your own custom
security groups. \code{UseOpsworksSecurityGroups} has the following settings:
\itemize{
\item True - OpsWorks Stacks automatically associates the appropriate
built-in security group with each layer (default setting). You can
associate additional security groups with a layer after you create
it but you cannot delete the built-in security group.
\item False - OpsWorks Stacks does not associate built-in security groups
with layers. You must create appropriate Amazon EC2 security groups
and associate a security group with each layer that you create.
However, you can still manually associate a built-in security group
with a layer on creation; custom security groups are required only
for those layers that need custom settings.
}

For more information, see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html}{Create a New Stack}.}

\item{CustomCookbooksSource}{Contains the information required to retrieve an app or cookbook from a
repository. For more information, see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html}{Adding Apps}
or \href{https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html}{Cookbooks and Recipes}.}

\item{DefaultSshKeyName}{A default Amazon EC2 key pair name. The default value is none. If you
specify a key pair name, OpsWorks installs the public key on the
instance and you can use the private key with an SSH client to log in to
the instance. For more information, see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-ssh.html}{Using SSH to Communicate with an Instance}
and \href{https://docs.aws.amazon.com/opsworks/latest/userguide/security-ssh-access.html}{Managing SSH Access}.
You can override this setting by specifying a different key pair, or no
key pair, when you \href{https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-add.html}{create an instance}.}

\item{ClonePermissions}{Whether to clone the source stack's permissions.}

\item{CloneAppIds}{A list of source stack app IDs to be included in the cloned stack.}

\item{DefaultRootDeviceType}{The default root device type. This value is used by default for all
instances in the cloned stack, but you can override it when you create
an instance. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device}{Storage for the Root Device}.}

\item{AgentVersion}{The default OpsWorks Stacks agent version. You have the following
options:
\itemize{
\item Auto-update - Set this parameter to \code{LATEST}. OpsWorks Stacks
automatically installs new agent versions on the stack's instances
as soon as they are available.
\item Fixed version - Set this parameter to your preferred agent version.
To update the agent version, you must edit the stack configuration
and specify a new version. OpsWorks Stacks automatically installs
that version on the stack's instances.
}

The default setting is \code{LATEST}. To specify an agent version, you must
use the complete version number, not the abbreviated number shown on the
console. For a list of available agent version numbers, call
\code{\link[=opsworks_describe_agent_versions]{describe_agent_versions}}.
AgentVersion cannot be set to Chef 12.2.

You can also specify an agent version when you create or update an
instance, which overrides the stack's default setting.}
}
\description{
Creates a clone of a specified stack. For more information, see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-cloning.html}{Clone a Stack}. By default, all parameters are set to the values used by the parent stack.

See \url{https://www.paws-r-sdk.com/docs/opsworks_clone_stack/} for full documentation.
}
\keyword{internal}
