# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_operation new_request send_request
#' @include route53resolver_service.R
NULL

#' Adds IP addresses to an inbound or an outbound resolver endpoint
#'
#' Adds IP addresses to an inbound or an outbound resolver endpoint. If you
#' want to adding more than one IP address, submit one
#' `AssociateResolverEndpointIpAddress` request for each IP address.
#' 
#' To remove an IP address from an endpoint, see
#' DisassociateResolverEndpointIpAddress.
#'
#' @usage
#' route53resolver_associate_resolver_endpoint_ip_address(
#'   ResolverEndpointId, IpAddress)
#'
#' @param ResolverEndpointId &#91;required&#93; The ID of the resolver endpoint that you want to associate IP addresses
#' with.
#' @param IpAddress &#91;required&#93; Either the IPv4 address that you want to add to a resolver endpoint or a
#' subnet ID. If you specify a subnet ID, Resolver chooses an IP address
#' for you from the available IPs in the specified subnet.
#'
#' @section Request syntax:
#' ```
#' svc$associate_resolver_endpoint_ip_address(
#'   ResolverEndpointId = "string",
#'   IpAddress = list(
#'     IpId = "string",
#'     SubnetId = "string",
#'     Ip = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53resolver_associate_resolver_endpoint_ip_address
route53resolver_associate_resolver_endpoint_ip_address <- function(ResolverEndpointId, IpAddress) {
  op <- new_operation(
    name = "AssociateResolverEndpointIpAddress",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .route53resolver$associate_resolver_endpoint_ip_address_input(ResolverEndpointId = ResolverEndpointId, IpAddress = IpAddress)
  output <- .route53resolver$associate_resolver_endpoint_ip_address_output()
  svc <- .route53resolver$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$associate_resolver_endpoint_ip_address <- route53resolver_associate_resolver_endpoint_ip_address

#' Associates a resolver rule with a VPC
#'
#' Associates a resolver rule with a VPC. When you associate a rule with a
#' VPC, Resolver forwards all DNS queries for the domain name that is
#' specified in the rule and that originate in the VPC. The queries are
#' forwarded to the IP addresses for the DNS resolvers that are specified
#' in the rule. For more information about rules, see CreateResolverRule.
#'
#' @usage
#' route53resolver_associate_resolver_rule(ResolverRuleId, Name, VPCId)
#'
#' @param ResolverRuleId &#91;required&#93; The ID of the resolver rule that you want to associate with the VPC. To
#' list the existing resolver rules, use ListResolverRules.
#' @param Name A name for the association that you\'re creating between a resolver rule
#' and a VPC.
#' @param VPCId &#91;required&#93; The ID of the VPC that you want to associate the resolver rule with.
#'
#' @section Request syntax:
#' ```
#' svc$associate_resolver_rule(
#'   ResolverRuleId = "string",
#'   Name = "string",
#'   VPCId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53resolver_associate_resolver_rule
route53resolver_associate_resolver_rule <- function(ResolverRuleId, Name = NULL, VPCId) {
  op <- new_operation(
    name = "AssociateResolverRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .route53resolver$associate_resolver_rule_input(ResolverRuleId = ResolverRuleId, Name = Name, VPCId = VPCId)
  output <- .route53resolver$associate_resolver_rule_output()
  svc <- .route53resolver$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$associate_resolver_rule <- route53resolver_associate_resolver_rule

#' Creates a resolver endpoint
#'
#' Creates a resolver endpoint. There are two types of resolver endpoints,
#' inbound and outbound:
#' 
#' -   An *inbound resolver endpoint* forwards DNS queries to the DNS
#'     service for a VPC from your network or another VPC.
#' 
#' -   An *outbound resolver endpoint* forwards DNS queries from the DNS
#'     service for a VPC to your network or another VPC.
#'
#' @usage
#' route53resolver_create_resolver_endpoint(CreatorRequestId, Name,
#'   SecurityGroupIds, Direction, IpAddresses, Tags)
#'
#' @param CreatorRequestId &#91;required&#93; A unique string that identifies the request and that allows failed
#' requests to be retried without the risk of executing the operation
#' twice. `CreatorRequestId` can be any unique string, for example, a
#' date/time stamp.
#' @param Name A friendly name that lets you easily find a configuration in the
#' Resolver dashboard in the Route 53 console.
#' @param SecurityGroupIds &#91;required&#93; The ID of one or more security groups that you want to use to control
#' access to this VPC. The security group that you specify must include one
#' or more inbound rules (for inbound resolver endpoints) or outbound rules
#' (for outbound resolver endpoints).
#' @param Direction &#91;required&#93; Specify the applicable value:
#' 
#' -   `INBOUND`: Resolver forwards DNS queries to the DNS service for a
#'     VPC from your network or another VPC
#' 
#' -   `OUTBOUND`: Resolver forwards DNS queries from the DNS service for a
#'     VPC to your network or another VPC
#' @param IpAddresses &#91;required&#93; The subnets and IP addresses in your VPC that you want DNS queries to
#' pass through on the way from your VPCs to your network (for outbound
#' endpoints) or on the way from your network to your VPCs (for inbound
#' resolver endpoints).
#' @param Tags A list of the tag keys and values that you want to associate with the
#' endpoint.
#'
#' @section Request syntax:
#' ```
#' svc$create_resolver_endpoint(
#'   CreatorRequestId = "string",
#'   Name = "string",
#'   SecurityGroupIds = list(
#'     "string"
#'   ),
#'   Direction = "INBOUND"|"OUTBOUND",
#'   IpAddresses = list(
#'     list(
#'       SubnetId = "string",
#'       Ip = "string"
#'     )
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53resolver_create_resolver_endpoint
route53resolver_create_resolver_endpoint <- function(CreatorRequestId, Name = NULL, SecurityGroupIds, Direction, IpAddresses, Tags = NULL) {
  op <- new_operation(
    name = "CreateResolverEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .route53resolver$create_resolver_endpoint_input(CreatorRequestId = CreatorRequestId, Name = Name, SecurityGroupIds = SecurityGroupIds, Direction = Direction, IpAddresses = IpAddresses, Tags = Tags)
  output <- .route53resolver$create_resolver_endpoint_output()
  svc <- .route53resolver$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$create_resolver_endpoint <- route53resolver_create_resolver_endpoint

#' For DNS queries that originate in your VPCs, specifies which resolver
#' endpoint the queries pass through, one domain name that you want to
#' forward to your network, and the IP addresses of the DNS resolvers in
#' your network
#'
#' For DNS queries that originate in your VPCs, specifies which resolver
#' endpoint the queries pass through, one domain name that you want to
#' forward to your network, and the IP addresses of the DNS resolvers in
#' your network.
#'
#' @usage
#' route53resolver_create_resolver_rule(CreatorRequestId, Name, RuleType,
#'   DomainName, TargetIps, ResolverEndpointId, Tags)
#'
#' @param CreatorRequestId &#91;required&#93; A unique string that identifies the request and that allows failed
#' requests to be retried without the risk of executing the operation
#' twice. `CreatorRequestId` can be any unique string, for example, a
#' date/time stamp.
#' @param Name A friendly name that lets you easily find a rule in the Resolver
#' dashboard in the Route 53 console.
#' @param RuleType &#91;required&#93; Specify `FORWARD`. Other resolver rule types aren\'t supported.
#' @param DomainName &#91;required&#93; DNS queries for this domain name are forwarded to the IP addresses that
#' you specify in `TargetIps`. If a query matches multiple resolver rules
#' (example.com and www.example.com), outbound DNS queries are routed using
#' the resolver rule that contains the most specific domain name
#' (www.example.com).
#' @param TargetIps The IPs that you want Resolver to forward DNS queries to. You can
#' specify only IPv4 addresses. Separate IP addresses with a comma.
#' @param ResolverEndpointId The ID of the outbound resolver endpoint that you want to use to route
#' DNS queries to the IP addresses that you specify in `TargetIps`.
#' @param Tags A list of the tag keys and values that you want to associate with the
#' endpoint.
#'
#' @section Request syntax:
#' ```
#' svc$create_resolver_rule(
#'   CreatorRequestId = "string",
#'   Name = "string",
#'   RuleType = "FORWARD"|"SYSTEM"|"RECURSIVE",
#'   DomainName = "string",
#'   TargetIps = list(
#'     list(
#'       Ip = "string",
#'       Port = 123
#'     )
#'   ),
#'   ResolverEndpointId = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53resolver_create_resolver_rule
route53resolver_create_resolver_rule <- function(CreatorRequestId, Name = NULL, RuleType, DomainName, TargetIps = NULL, ResolverEndpointId = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateResolverRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .route53resolver$create_resolver_rule_input(CreatorRequestId = CreatorRequestId, Name = Name, RuleType = RuleType, DomainName = DomainName, TargetIps = TargetIps, ResolverEndpointId = ResolverEndpointId, Tags = Tags)
  output <- .route53resolver$create_resolver_rule_output()
  svc <- .route53resolver$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$create_resolver_rule <- route53resolver_create_resolver_rule

#' Deletes a resolver endpoint
#'
#' Deletes a resolver endpoint. The effect of deleting a resolver endpoint
#' depends on whether it\'s an inbound or an outbound resolver endpoint:
#' 
#' -   **Inbound**: DNS queries from your network or another VPC are no
#'     longer routed to the DNS service for the specified VPC.
#' 
#' -   **Outbound**: DNS queries from a VPC are no longer routed to your
#'     network or to another VPC.
#'
#' @usage
#' route53resolver_delete_resolver_endpoint(ResolverEndpointId)
#'
#' @param ResolverEndpointId &#91;required&#93; The ID of the resolver endpoint that you want to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_resolver_endpoint(
#'   ResolverEndpointId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53resolver_delete_resolver_endpoint
route53resolver_delete_resolver_endpoint <- function(ResolverEndpointId) {
  op <- new_operation(
    name = "DeleteResolverEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .route53resolver$delete_resolver_endpoint_input(ResolverEndpointId = ResolverEndpointId)
  output <- .route53resolver$delete_resolver_endpoint_output()
  svc <- .route53resolver$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$delete_resolver_endpoint <- route53resolver_delete_resolver_endpoint

#' Deletes a resolver rule
#'
#' Deletes a resolver rule. Before you can delete a resolver rule, you must
#' disassociate it from all the VPCs that you associated the resolver rule
#' with. For more infomation, see DisassociateResolverRule.
#'
#' @usage
#' route53resolver_delete_resolver_rule(ResolverRuleId)
#'
#' @param ResolverRuleId &#91;required&#93; The ID of the resolver rule that you want to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_resolver_rule(
#'   ResolverRuleId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53resolver_delete_resolver_rule
route53resolver_delete_resolver_rule <- function(ResolverRuleId) {
  op <- new_operation(
    name = "DeleteResolverRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .route53resolver$delete_resolver_rule_input(ResolverRuleId = ResolverRuleId)
  output <- .route53resolver$delete_resolver_rule_output()
  svc <- .route53resolver$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$delete_resolver_rule <- route53resolver_delete_resolver_rule

#' Removes IP addresses from an inbound or an outbound resolver endpoint
#'
#' Removes IP addresses from an inbound or an outbound resolver endpoint.
#' If you want to remove more than one IP address, submit one
#' `DisassociateResolverEndpointIpAddress` request for each IP address.
#' 
#' To add an IP address to an endpoint, see
#' AssociateResolverEndpointIpAddress.
#'
#' @usage
#' route53resolver_disassociate_resolver_endpoint_ip_address(
#'   ResolverEndpointId, IpAddress)
#'
#' @param ResolverEndpointId &#91;required&#93; The ID of the resolver endpoint that you want to disassociate an IP
#' address from.
#' @param IpAddress &#91;required&#93; The IPv4 address that you want to remove from a resolver endpoint.
#'
#' @section Request syntax:
#' ```
#' svc$disassociate_resolver_endpoint_ip_address(
#'   ResolverEndpointId = "string",
#'   IpAddress = list(
#'     IpId = "string",
#'     SubnetId = "string",
#'     Ip = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53resolver_disassociate_resolver_endpoint_ip_address
route53resolver_disassociate_resolver_endpoint_ip_address <- function(ResolverEndpointId, IpAddress) {
  op <- new_operation(
    name = "DisassociateResolverEndpointIpAddress",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .route53resolver$disassociate_resolver_endpoint_ip_address_input(ResolverEndpointId = ResolverEndpointId, IpAddress = IpAddress)
  output <- .route53resolver$disassociate_resolver_endpoint_ip_address_output()
  svc <- .route53resolver$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$disassociate_resolver_endpoint_ip_address <- route53resolver_disassociate_resolver_endpoint_ip_address

#' Removes the association between a specified resolver rule and a
#' specified VPC
#'
#' Removes the association between a specified resolver rule and a
#' specified VPC.
#' 
#' If you disassociate a resolver rule from a VPC, Resolver stops
#' forwarding DNS queries for the domain name that you specified in the
#' resolver rule.
#'
#' @usage
#' route53resolver_disassociate_resolver_rule(VPCId, ResolverRuleId)
#'
#' @param VPCId &#91;required&#93; The ID of the VPC that you want to disassociate the resolver rule from.
#' @param ResolverRuleId &#91;required&#93; The ID of the resolver rule that you want to disassociate from the
#' specified VPC.
#'
#' @section Request syntax:
#' ```
#' svc$disassociate_resolver_rule(
#'   VPCId = "string",
#'   ResolverRuleId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53resolver_disassociate_resolver_rule
route53resolver_disassociate_resolver_rule <- function(VPCId, ResolverRuleId) {
  op <- new_operation(
    name = "DisassociateResolverRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .route53resolver$disassociate_resolver_rule_input(VPCId = VPCId, ResolverRuleId = ResolverRuleId)
  output <- .route53resolver$disassociate_resolver_rule_output()
  svc <- .route53resolver$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$disassociate_resolver_rule <- route53resolver_disassociate_resolver_rule

#' Gets information about a specified resolver endpoint, such as whether
#' it's an inbound or an outbound resolver endpoint, and the current status
#' of the endpoint
#'
#' Gets information about a specified resolver endpoint, such as whether
#' it\'s an inbound or an outbound resolver endpoint, and the current
#' status of the endpoint.
#'
#' @usage
#' route53resolver_get_resolver_endpoint(ResolverEndpointId)
#'
#' @param ResolverEndpointId &#91;required&#93; The ID of the resolver endpoint that you want to get information about.
#'
#' @section Request syntax:
#' ```
#' svc$get_resolver_endpoint(
#'   ResolverEndpointId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53resolver_get_resolver_endpoint
route53resolver_get_resolver_endpoint <- function(ResolverEndpointId) {
  op <- new_operation(
    name = "GetResolverEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .route53resolver$get_resolver_endpoint_input(ResolverEndpointId = ResolverEndpointId)
  output <- .route53resolver$get_resolver_endpoint_output()
  svc <- .route53resolver$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$get_resolver_endpoint <- route53resolver_get_resolver_endpoint

#' Gets information about a specified resolver rule, such as the domain
#' name that the rule forwards DNS queries for and the ID of the outbound
#' resolver endpoint that the rule is associated with
#'
#' Gets information about a specified resolver rule, such as the domain
#' name that the rule forwards DNS queries for and the ID of the outbound
#' resolver endpoint that the rule is associated with.
#'
#' @usage
#' route53resolver_get_resolver_rule(ResolverRuleId)
#'
#' @param ResolverRuleId &#91;required&#93; The ID of the resolver rule that you want to get information about.
#'
#' @section Request syntax:
#' ```
#' svc$get_resolver_rule(
#'   ResolverRuleId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53resolver_get_resolver_rule
route53resolver_get_resolver_rule <- function(ResolverRuleId) {
  op <- new_operation(
    name = "GetResolverRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .route53resolver$get_resolver_rule_input(ResolverRuleId = ResolverRuleId)
  output <- .route53resolver$get_resolver_rule_output()
  svc <- .route53resolver$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$get_resolver_rule <- route53resolver_get_resolver_rule

#' Gets information about an association between a specified resolver rule
#' and a VPC
#'
#' Gets information about an association between a specified resolver rule
#' and a VPC. You associate a resolver rule and a VPC using
#' AssociateResolverRule.
#'
#' @usage
#' route53resolver_get_resolver_rule_association(ResolverRuleAssociationId)
#'
#' @param ResolverRuleAssociationId &#91;required&#93; The ID of the resolver rule association that you want to get information
#' about.
#'
#' @section Request syntax:
#' ```
#' svc$get_resolver_rule_association(
#'   ResolverRuleAssociationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53resolver_get_resolver_rule_association
route53resolver_get_resolver_rule_association <- function(ResolverRuleAssociationId) {
  op <- new_operation(
    name = "GetResolverRuleAssociation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .route53resolver$get_resolver_rule_association_input(ResolverRuleAssociationId = ResolverRuleAssociationId)
  output <- .route53resolver$get_resolver_rule_association_output()
  svc <- .route53resolver$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$get_resolver_rule_association <- route53resolver_get_resolver_rule_association

#' Gets information about a resolver rule policy
#'
#' Gets information about a resolver rule policy. A resolver rule policy
#' specifies the Resolver operations and resources that you want to allow
#' another AWS account to be able to use.
#'
#' @usage
#' route53resolver_get_resolver_rule_policy(Arn)
#'
#' @param Arn &#91;required&#93; The ID of the resolver rule policy that you want to get information
#' about.
#'
#' @section Request syntax:
#' ```
#' svc$get_resolver_rule_policy(
#'   Arn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53resolver_get_resolver_rule_policy
route53resolver_get_resolver_rule_policy <- function(Arn) {
  op <- new_operation(
    name = "GetResolverRulePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .route53resolver$get_resolver_rule_policy_input(Arn = Arn)
  output <- .route53resolver$get_resolver_rule_policy_output()
  svc <- .route53resolver$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$get_resolver_rule_policy <- route53resolver_get_resolver_rule_policy

#' Gets the IP addresses for a specified resolver endpoint
#'
#' Gets the IP addresses for a specified resolver endpoint.
#'
#' @usage
#' route53resolver_list_resolver_endpoint_ip_addresses(ResolverEndpointId,
#'   MaxResults, NextToken)
#'
#' @param ResolverEndpointId &#91;required&#93; The ID of the resolver endpoint that you want to get IP addresses for.
#' @param MaxResults The maximum number of IP addresses that you want to return in the
#' response to a `ListResolverEndpointIpAddresses` request. If you don\'t
#' specify a value for `MaxResults`, Resolver returns up to 100 IP
#' addresses.
#' @param NextToken For the first `ListResolverEndpointIpAddresses` request, omit this
#' value.
#' 
#' If the specified resolver endpoint has more than `MaxResults` IP
#' addresses, you can submit another `ListResolverEndpointIpAddresses`
#' request to get the next group of IP addresses. In the next request,
#' specify the value of `NextToken` from the previous response.
#'
#' @section Request syntax:
#' ```
#' svc$list_resolver_endpoint_ip_addresses(
#'   ResolverEndpointId = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53resolver_list_resolver_endpoint_ip_addresses
route53resolver_list_resolver_endpoint_ip_addresses <- function(ResolverEndpointId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListResolverEndpointIpAddresses",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .route53resolver$list_resolver_endpoint_ip_addresses_input(ResolverEndpointId = ResolverEndpointId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .route53resolver$list_resolver_endpoint_ip_addresses_output()
  svc <- .route53resolver$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$list_resolver_endpoint_ip_addresses <- route53resolver_list_resolver_endpoint_ip_addresses

#' Lists all the resolver endpoints that were created using the current AWS
#' account
#'
#' Lists all the resolver endpoints that were created using the current AWS
#' account.
#'
#' @usage
#' route53resolver_list_resolver_endpoints(MaxResults, NextToken, Filters)
#'
#' @param MaxResults The maximum number of resolver endpoints that you want to return in the
#' response to a `ListResolverEndpoints` request. If you don\'t specify a
#' value for `MaxResults`, Resolver returns up to 100 resolver endpoints.
#' @param NextToken For the first `ListResolverEndpoints` request, omit this value.
#' 
#' If you have more than `MaxResults` resolver endpoints, you can submit
#' another `ListResolverEndpoints` request to get the next group of
#' resolver endpoints. In the next request, specify the value of
#' `NextToken` from the previous response.
#' @param Filters An optional specification to return a subset of resolver endpoints, such
#' as all inbound resolver endpoints.
#' 
#' If you submit a second or subsequent `ListResolverEndpoints` request and
#' specify the `NextToken` parameter, you must use the same values for
#' `Filters`, if any, as in the previous request.
#'
#' @section Request syntax:
#' ```
#' svc$list_resolver_endpoints(
#'   MaxResults = 123,
#'   NextToken = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53resolver_list_resolver_endpoints
route53resolver_list_resolver_endpoints <- function(MaxResults = NULL, NextToken = NULL, Filters = NULL) {
  op <- new_operation(
    name = "ListResolverEndpoints",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .route53resolver$list_resolver_endpoints_input(MaxResults = MaxResults, NextToken = NextToken, Filters = Filters)
  output <- .route53resolver$list_resolver_endpoints_output()
  svc <- .route53resolver$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$list_resolver_endpoints <- route53resolver_list_resolver_endpoints

#' Lists the associations that were created between resolver rules and VPCs
#' using the current AWS account
#'
#' Lists the associations that were created between resolver rules and VPCs
#' using the current AWS account.
#'
#' @usage
#' route53resolver_list_resolver_rule_associations(MaxResults, NextToken,
#'   Filters)
#'
#' @param MaxResults The maximum number of rule associations that you want to return in the
#' response to a `ListResolverRuleAssociations` request. If you don\'t
#' specify a value for `MaxResults`, Resolver returns up to 100 rule
#' associations.
#' @param NextToken For the first `ListResolverRuleAssociation` request, omit this value.
#' 
#' If you have more than `MaxResults` rule associations, you can submit
#' another `ListResolverRuleAssociation` request to get the next group of
#' rule associations. In the next request, specify the value of `NextToken`
#' from the previous response.
#' @param Filters An optional specification to return a subset of resolver rules, such as
#' resolver rules that are associated with the same VPC ID.
#' 
#' If you submit a second or subsequent `ListResolverRuleAssociations`
#' request and specify the `NextToken` parameter, you must use the same
#' values for `Filters`, if any, as in the previous request.
#'
#' @section Request syntax:
#' ```
#' svc$list_resolver_rule_associations(
#'   MaxResults = 123,
#'   NextToken = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53resolver_list_resolver_rule_associations
route53resolver_list_resolver_rule_associations <- function(MaxResults = NULL, NextToken = NULL, Filters = NULL) {
  op <- new_operation(
    name = "ListResolverRuleAssociations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .route53resolver$list_resolver_rule_associations_input(MaxResults = MaxResults, NextToken = NextToken, Filters = Filters)
  output <- .route53resolver$list_resolver_rule_associations_output()
  svc <- .route53resolver$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$list_resolver_rule_associations <- route53resolver_list_resolver_rule_associations

#' Lists the resolver rules that were created using the current AWS account
#'
#' Lists the resolver rules that were created using the current AWS
#' account.
#'
#' @usage
#' route53resolver_list_resolver_rules(MaxResults, NextToken, Filters)
#'
#' @param MaxResults The maximum number of resolver rules that you want to return in the
#' response to a `ListResolverRules` request. If you don\'t specify a value
#' for `MaxResults`, Resolver returns up to 100 resolver rules.
#' @param NextToken For the first `ListResolverRules` request, omit this value.
#' 
#' If you have more than `MaxResults` resolver rules, you can submit
#' another `ListResolverRules` request to get the next group of resolver
#' rules. In the next request, specify the value of `NextToken` from the
#' previous response.
#' @param Filters An optional specification to return a subset of resolver rules, such as
#' all resolver rules that are associated with the same resolver endpoint.
#' 
#' If you submit a second or subsequent `ListResolverRules` request and
#' specify the `NextToken` parameter, you must use the same values for
#' `Filters`, if any, as in the previous request.
#'
#' @section Request syntax:
#' ```
#' svc$list_resolver_rules(
#'   MaxResults = 123,
#'   NextToken = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53resolver_list_resolver_rules
route53resolver_list_resolver_rules <- function(MaxResults = NULL, NextToken = NULL, Filters = NULL) {
  op <- new_operation(
    name = "ListResolverRules",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .route53resolver$list_resolver_rules_input(MaxResults = MaxResults, NextToken = NextToken, Filters = Filters)
  output <- .route53resolver$list_resolver_rules_output()
  svc <- .route53resolver$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$list_resolver_rules <- route53resolver_list_resolver_rules

#' Lists the tags that you associated with the specified resource
#'
#' Lists the tags that you associated with the specified resource.
#'
#' @usage
#' route53resolver_list_tags_for_resource(ResourceArn, MaxResults,
#'   NextToken)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) for the resource that you want to list
#' tags for.
#' @param MaxResults The maximum number of tags that you want to return in the response to a
#' `ListTagsForResource` request. If you don\'t specify a value for
#' `MaxResults`, Resolver returns up to 100 tags.
#' @param NextToken For the first `ListTagsForResource` request, omit this value.
#' 
#' If you have more than `MaxResults` tags, you can submit another
#' `ListTagsForResource` request to get the next group of tags for the
#' resource. In the next request, specify the value of `NextToken` from the
#' previous response.
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   ResourceArn = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53resolver_list_tags_for_resource
route53resolver_list_tags_for_resource <- function(ResourceArn, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .route53resolver$list_tags_for_resource_input(ResourceArn = ResourceArn, MaxResults = MaxResults, NextToken = NextToken)
  output <- .route53resolver$list_tags_for_resource_output()
  svc <- .route53resolver$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$list_tags_for_resource <- route53resolver_list_tags_for_resource

#' Specifies the Resolver operations and resources that you want to allow
#' another AWS account to be able to use
#'
#' Specifies the Resolver operations and resources that you want to allow
#' another AWS account to be able to use.
#'
#' @usage
#' route53resolver_put_resolver_rule_policy(Arn, ResolverRulePolicy)
#'
#' @param Arn &#91;required&#93; The Amazon Resource Name (ARN) of the account that you want to grant
#' permissions to.
#' @param ResolverRulePolicy &#91;required&#93; An AWS Identity and Access Management policy statement that lists the
#' permissions that you want to grant to another AWS account.
#'
#' @section Request syntax:
#' ```
#' svc$put_resolver_rule_policy(
#'   Arn = "string",
#'   ResolverRulePolicy = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53resolver_put_resolver_rule_policy
route53resolver_put_resolver_rule_policy <- function(Arn, ResolverRulePolicy) {
  op <- new_operation(
    name = "PutResolverRulePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .route53resolver$put_resolver_rule_policy_input(Arn = Arn, ResolverRulePolicy = ResolverRulePolicy)
  output <- .route53resolver$put_resolver_rule_policy_output()
  svc <- .route53resolver$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$put_resolver_rule_policy <- route53resolver_put_resolver_rule_policy

#' Adds one or more tags to a specified resource
#'
#' Adds one or more tags to a specified resource.
#'
#' @usage
#' route53resolver_tag_resource(ResourceArn, Tags)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) for the resource that you want to add
#' tags to. To get the ARN for a resource, use the applicable `Get` or
#' `List` command:
#' 
#' -   GetResolverEndpoint
#' 
#' -   GetResolverRule
#' 
#' -   GetResolverRuleAssociation
#' 
#' -   ListResolverEndpoints
#' 
#' -   ListResolverRuleAssociations
#' 
#' -   ListResolverRules
#' @param Tags &#91;required&#93; The tags that you want to add to the specified resource.
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   ResourceArn = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53resolver_tag_resource
route53resolver_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .route53resolver$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .route53resolver$tag_resource_output()
  svc <- .route53resolver$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$tag_resource <- route53resolver_tag_resource

#' Removes one or more tags from a specified resource
#'
#' Removes one or more tags from a specified resource.
#'
#' @usage
#' route53resolver_untag_resource(ResourceArn, TagKeys)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) for the resource that you want to remove
#' tags from. To get the ARN for a resource, use the applicable `Get` or
#' `List` command:
#' 
#' -   GetResolverEndpoint
#' 
#' -   GetResolverRule
#' 
#' -   GetResolverRuleAssociation
#' 
#' -   ListResolverEndpoints
#' 
#' -   ListResolverRuleAssociations
#' 
#' -   ListResolverRules
#' @param TagKeys &#91;required&#93; The tags that you want to remove to the specified resource.
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   ResourceArn = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53resolver_untag_resource
route53resolver_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .route53resolver$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .route53resolver$untag_resource_output()
  svc <- .route53resolver$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$untag_resource <- route53resolver_untag_resource

#' Updates the name of an inbound or an outbound resolver endpoint
#'
#' Updates the name of an inbound or an outbound resolver endpoint.
#'
#' @usage
#' route53resolver_update_resolver_endpoint(ResolverEndpointId, Name)
#'
#' @param ResolverEndpointId &#91;required&#93; The ID of the resolver endpoint that you want to update.
#' @param Name The name of the resolver endpoint that you want to update.
#'
#' @section Request syntax:
#' ```
#' svc$update_resolver_endpoint(
#'   ResolverEndpointId = "string",
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53resolver_update_resolver_endpoint
route53resolver_update_resolver_endpoint <- function(ResolverEndpointId, Name = NULL) {
  op <- new_operation(
    name = "UpdateResolverEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .route53resolver$update_resolver_endpoint_input(ResolverEndpointId = ResolverEndpointId, Name = Name)
  output <- .route53resolver$update_resolver_endpoint_output()
  svc <- .route53resolver$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$update_resolver_endpoint <- route53resolver_update_resolver_endpoint

#' Updates settings for a specified resolver rule
#'
#' Updates settings for a specified resolver rule. `ResolverRuleId` is
#' required, and all other parameters are optional. If you don\'t specify a
#' parameter, it retains its current value.
#'
#' @usage
#' route53resolver_update_resolver_rule(ResolverRuleId, Config)
#'
#' @param ResolverRuleId &#91;required&#93; The ID of the resolver rule that you want to update.
#' @param Config &#91;required&#93; The new settings for the resolver rule.
#'
#' @section Request syntax:
#' ```
#' svc$update_resolver_rule(
#'   ResolverRuleId = "string",
#'   Config = list(
#'     Name = "string",
#'     TargetIps = list(
#'       list(
#'         Ip = "string",
#'         Port = 123
#'       )
#'     ),
#'     ResolverEndpointId = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53resolver_update_resolver_rule
route53resolver_update_resolver_rule <- function(ResolverRuleId, Config) {
  op <- new_operation(
    name = "UpdateResolverRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .route53resolver$update_resolver_rule_input(ResolverRuleId = ResolverRuleId, Config = Config)
  output <- .route53resolver$update_resolver_rule_output()
  svc <- .route53resolver$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53resolver$operations$update_resolver_rule <- route53resolver_update_resolver_rule
