% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apigateway_operations.R
\name{apigateway_create_usage_plan}
\alias{apigateway_create_usage_plan}
\title{Creates a usage plan with the throttle and quota limits, as well as the
associated API stages, specified in the payload}
\usage{
apigateway_create_usage_plan(name, description, apiStages, throttle,
  quota)
}
\arguments{
\item{name}{[required] [Required] The name of the usage plan.}

\item{description}{The description of the usage plan.}

\item{apiStages}{The associated API stages of the usage plan.}

\item{throttle}{The throttling limits of the usage plan.}

\item{quota}{The quota of the usage plan.}
}
\description{
Creates a usage plan with the throttle and quota limits, as well as the
associated API stages, specified in the payload.
}
\section{Request syntax}{
\preformatted{svc$create_usage_plan(
  name = "string",
  description = "string",
  apiStages = list(
    list(
      apiId = "string",
      stage = "string",
      throttle = list(
        list(
          burstLimit = 123,
          rateLimit = 123.0
        )
      )
    )
  ),
  throttle = list(
    burstLimit = 123,
    rateLimit = 123.0
  ),
  quota = list(
    limit = 123,
    offset = 123,
    period = "DAY"|"WEEK"|"MONTH"
  )
)
}
}

\keyword{internal}
