% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudfront_operations.R
\name{cloudfront_list_distributions_by_web_acl_id}
\alias{cloudfront_list_distributions_by_web_acl_id}
\title{List the distributions that are associated with a specified AWS WAF web
ACL}
\usage{
cloudfront_list_distributions_by_web_acl_id(Marker, MaxItems, WebACLId)
}
\arguments{
\item{Marker}{Use \code{Marker} and \code{MaxItems} to control pagination of results. If you
have more than \code{MaxItems} distributions that satisfy the request, the
response includes a \code{NextMarker} element. To get the next page of
results, submit another request. For the value of \code{Marker}, specify the
value of \code{NextMarker} from the last response. (For the first request,
omit \code{Marker}.)}

\item{MaxItems}{The maximum number of distributions that you want CloudFront to return
in the response body. The maximum and default values are both 100.}

\item{WebACLId}{[required] The ID of the AWS WAF web ACL that you want to list the associated
distributions. If you specify "null" for the ID, the request returns a
list of the distributions that aren't associated with a web ACL.}
}
\description{
List the distributions that are associated with a specified AWS WAF web
ACL.
}
\section{Request syntax}{
\preformatted{svc$list_distributions_by_web_acl_id(
  Marker = "string",
  MaxItems = "string",
  WebACLId = "string"
)
}
}

\keyword{internal}
