# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' Amazon CloudFront
#'
#' @description
#' This is the *Amazon CloudFront API Reference*. This guide is for
#' developers who need detailed information about CloudFront API actions,
#' data types, and errors. For detailed information about CloudFront
#' features, see the *Amazon CloudFront Developer Guide*.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#'
#' @section Service syntax:
#' ```
#' svc <- cloudfront(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string"
#'     ),
#'     endpoint = "string",
#'     region = "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- cloudfront()
#' svc$create_cache_policy(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=cloudfront_create_cache_policy]{create_cache_policy} \tab Creates a cache policy\cr
#'  \link[=cloudfront_create_cloud_front_origin_access_identity]{create_cloud_front_origin_access_identity} \tab Creates a new origin access identity\cr
#'  \link[=cloudfront_create_distribution]{create_distribution} \tab Creates a new web distribution\cr
#'  \link[=cloudfront_create_distribution_with_tags]{create_distribution_with_tags} \tab Create a new distribution with tags\cr
#'  \link[=cloudfront_create_field_level_encryption_config]{create_field_level_encryption_config} \tab Create a new field-level encryption configuration\cr
#'  \link[=cloudfront_create_field_level_encryption_profile]{create_field_level_encryption_profile} \tab Create a field-level encryption profile\cr
#'  \link[=cloudfront_create_invalidation]{create_invalidation} \tab Create a new invalidation\cr
#'  \link[=cloudfront_create_key_group]{create_key_group} \tab Creates a key group that you can use with CloudFront signed URLs and signed cookies\cr
#'  \link[=cloudfront_create_monitoring_subscription]{create_monitoring_subscription} \tab Enables additional CloudWatch metrics for the specified CloudFront distribution\cr
#'  \link[=cloudfront_create_origin_request_policy]{create_origin_request_policy} \tab Creates an origin request policy\cr
#'  \link[=cloudfront_create_public_key]{create_public_key} \tab Uploads a public key to CloudFront that you can use with signed URLs and signed cookies, or with field-level encryption\cr
#'  \link[=cloudfront_create_realtime_log_config]{create_realtime_log_config} \tab Creates a real-time log configuration\cr
#'  \link[=cloudfront_create_streaming_distribution]{create_streaming_distribution} \tab This API is deprecated\cr
#'  \link[=cloudfront_create_streaming_distribution_with_tags]{create_streaming_distribution_with_tags} \tab This API is deprecated\cr
#'  \link[=cloudfront_delete_cache_policy]{delete_cache_policy} \tab Deletes a cache policy\cr
#'  \link[=cloudfront_delete_cloud_front_origin_access_identity]{delete_cloud_front_origin_access_identity} \tab Delete an origin access identity\cr
#'  \link[=cloudfront_delete_distribution]{delete_distribution} \tab Delete a distribution\cr
#'  \link[=cloudfront_delete_field_level_encryption_config]{delete_field_level_encryption_config} \tab Remove a field-level encryption configuration\cr
#'  \link[=cloudfront_delete_field_level_encryption_profile]{delete_field_level_encryption_profile} \tab Remove a field-level encryption profile\cr
#'  \link[=cloudfront_delete_key_group]{delete_key_group} \tab Deletes a key group\cr
#'  \link[=cloudfront_delete_monitoring_subscription]{delete_monitoring_subscription} \tab Disables additional CloudWatch metrics for the specified CloudFront distribution\cr
#'  \link[=cloudfront_delete_origin_request_policy]{delete_origin_request_policy} \tab Deletes an origin request policy\cr
#'  \link[=cloudfront_delete_public_key]{delete_public_key} \tab Remove a public key you previously added to CloudFront\cr
#'  \link[=cloudfront_delete_realtime_log_config]{delete_realtime_log_config} \tab Deletes a real-time log configuration\cr
#'  \link[=cloudfront_delete_streaming_distribution]{delete_streaming_distribution} \tab Delete a streaming distribution\cr
#'  \link[=cloudfront_get_cache_policy]{get_cache_policy} \tab Gets a cache policy, including the following metadata: - The policy’s identifier\cr
#'  \link[=cloudfront_get_cache_policy_config]{get_cache_policy_config} \tab Gets a cache policy configuration\cr
#'  \link[=cloudfront_get_cloud_front_origin_access_identity]{get_cloud_front_origin_access_identity} \tab Get the information about an origin access identity\cr
#'  \link[=cloudfront_get_cloud_front_origin_access_identity_config]{get_cloud_front_origin_access_identity_config} \tab Get the configuration information about an origin access identity\cr
#'  \link[=cloudfront_get_distribution]{get_distribution} \tab Get the information about a distribution\cr
#'  \link[=cloudfront_get_distribution_config]{get_distribution_config} \tab Get the configuration information about a distribution\cr
#'  \link[=cloudfront_get_field_level_encryption]{get_field_level_encryption} \tab Get the field-level encryption configuration information\cr
#'  \link[=cloudfront_get_field_level_encryption_config]{get_field_level_encryption_config} \tab Get the field-level encryption configuration information\cr
#'  \link[=cloudfront_get_field_level_encryption_profile]{get_field_level_encryption_profile} \tab Get the field-level encryption profile information\cr
#'  \link[=cloudfront_get_field_level_encryption_profile_config]{get_field_level_encryption_profile_config} \tab Get the field-level encryption profile configuration information\cr
#'  \link[=cloudfront_get_invalidation]{get_invalidation} \tab Get the information about an invalidation\cr
#'  \link[=cloudfront_get_key_group]{get_key_group} \tab Gets a key group, including the date and time when the key group was last modified\cr
#'  \link[=cloudfront_get_key_group_config]{get_key_group_config} \tab Gets a key group configuration\cr
#'  \link[=cloudfront_get_monitoring_subscription]{get_monitoring_subscription} \tab Gets information about whether additional CloudWatch metrics are enabled for the specified CloudFront distribution\cr
#'  \link[=cloudfront_get_origin_request_policy]{get_origin_request_policy} \tab Gets an origin request policy, including the following metadata: - The policy’s identifier\cr
#'  \link[=cloudfront_get_origin_request_policy_config]{get_origin_request_policy_config} \tab Gets an origin request policy configuration\cr
#'  \link[=cloudfront_get_public_key]{get_public_key} \tab Gets a public key\cr
#'  \link[=cloudfront_get_public_key_config]{get_public_key_config} \tab Gets a public key configuration\cr
#'  \link[=cloudfront_get_realtime_log_config]{get_realtime_log_config} \tab Gets a real-time log configuration\cr
#'  \link[=cloudfront_get_streaming_distribution]{get_streaming_distribution} \tab Gets information about a specified RTMP distribution, including the distribution configuration\cr
#'  \link[=cloudfront_get_streaming_distribution_config]{get_streaming_distribution_config} \tab Get the configuration information about a streaming distribution\cr
#'  \link[=cloudfront_list_cache_policies]{list_cache_policies} \tab Gets a list of cache policies\cr
#'  \link[=cloudfront_list_cloud_front_origin_access_identities]{list_cloud_front_origin_access_identities} \tab Lists origin access identities\cr
#'  \link[=cloudfront_list_distributions]{list_distributions} \tab List CloudFront distributions\cr
#'  \link[=cloudfront_list_distributions_by_cache_policy_id]{list_distributions_by_cache_policy_id} \tab Gets a list of distribution IDs for distributions that have a cache behavior that’s associated with the specified cache policy\cr
#'  \link[=cloudfront_list_distributions_by_key_group]{list_distributions_by_key_group} \tab Gets a list of distribution IDs for distributions that have a cache behavior that references the specified key group\cr
#'  \link[=cloudfront_list_distributions_by_origin_request_policy_id]{list_distributions_by_origin_request_policy_id} \tab Gets a list of distribution IDs for distributions that have a cache behavior that’s associated with the specified origin request policy\cr
#'  \link[=cloudfront_list_distributions_by_realtime_log_config]{list_distributions_by_realtime_log_config} \tab Gets a list of distributions that have a cache behavior that’s associated with the specified real-time log configuration\cr
#'  \link[=cloudfront_list_distributions_by_web_acl_id]{list_distributions_by_web_acl_id} \tab List the distributions that are associated with a specified AWS WAF web ACL\cr
#'  \link[=cloudfront_list_field_level_encryption_configs]{list_field_level_encryption_configs} \tab List all field-level encryption configurations that have been created in CloudFront for this account\cr
#'  \link[=cloudfront_list_field_level_encryption_profiles]{list_field_level_encryption_profiles} \tab Request a list of field-level encryption profiles that have been created in CloudFront for this account\cr
#'  \link[=cloudfront_list_invalidations]{list_invalidations} \tab Lists invalidation batches\cr
#'  \link[=cloudfront_list_key_groups]{list_key_groups} \tab Gets a list of key groups\cr
#'  \link[=cloudfront_list_origin_request_policies]{list_origin_request_policies} \tab Gets a list of origin request policies\cr
#'  \link[=cloudfront_list_public_keys]{list_public_keys} \tab List all public keys that have been added to CloudFront for this account\cr
#'  \link[=cloudfront_list_realtime_log_configs]{list_realtime_log_configs} \tab Gets a list of real-time log configurations\cr
#'  \link[=cloudfront_list_streaming_distributions]{list_streaming_distributions} \tab List streaming distributions\cr
#'  \link[=cloudfront_list_tags_for_resource]{list_tags_for_resource} \tab List tags for a CloudFront resource\cr
#'  \link[=cloudfront_tag_resource]{tag_resource} \tab Add tags to a CloudFront resource\cr
#'  \link[=cloudfront_untag_resource]{untag_resource} \tab Remove tags from a CloudFront resource\cr
#'  \link[=cloudfront_update_cache_policy]{update_cache_policy} \tab Updates a cache policy configuration\cr
#'  \link[=cloudfront_update_cloud_front_origin_access_identity]{update_cloud_front_origin_access_identity} \tab Update an origin access identity\cr
#'  \link[=cloudfront_update_distribution]{update_distribution} \tab Updates the configuration for a web distribution\cr
#'  \link[=cloudfront_update_field_level_encryption_config]{update_field_level_encryption_config} \tab Update a field-level encryption configuration\cr
#'  \link[=cloudfront_update_field_level_encryption_profile]{update_field_level_encryption_profile} \tab Update a field-level encryption profile\cr
#'  \link[=cloudfront_update_key_group]{update_key_group} \tab Updates a key group\cr
#'  \link[=cloudfront_update_origin_request_policy]{update_origin_request_policy} \tab Updates an origin request policy configuration\cr
#'  \link[=cloudfront_update_public_key]{update_public_key} \tab Update public key information\cr
#'  \link[=cloudfront_update_realtime_log_config]{update_realtime_log_config} \tab Updates a real-time log configuration\cr
#'  \link[=cloudfront_update_streaming_distribution]{update_streaming_distribution} \tab Update a streaming distribution
#' }
#'
#' @rdname cloudfront
#' @export
cloudfront <- function(config = list()) {
  svc <- .cloudfront$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.cloudfront <- list()

.cloudfront$operations <- list()

.cloudfront$metadata <- list(
  service_name = "cloudfront",
  endpoints = list("*" = list(endpoint = "https://cloudfront.amazonaws.com", global = TRUE), "cn-*" = list(endpoint = "cloudfront.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "cloudfront.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "cloudfront.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "CloudFront",
  api_version = "2020-05-31",
  signing_name = NULL,
  json_version = "",
  target_prefix = ""
)

.cloudfront$service <- function(config = list()) {
  handlers <- new_handlers("restxml", "v4")
  new_service(.cloudfront$metadata, handlers, config)
}
