# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include servicediscovery_service.R
NULL

#' Creates an HTTP namespace
#'
#' @description
#' Creates an HTTP namespace. Service instances that you register using an
#' HTTP namespace can be discovered using a `DiscoverInstances` request but
#' can't be discovered using DNS.
#' 
#' For the current quota on the number of namespaces that you can create
#' using the same AWS account, see [AWS Cloud Map
#' quotas](https://docs.aws.amazon.com/cloud-map/latest/dg/cloud-map-limits.html)
#' in the *AWS Cloud Map Developer Guide*.
#'
#' @usage
#' servicediscovery_create_http_namespace(Name, CreatorRequestId,
#'   Description, Tags)
#'
#' @param Name &#91;required&#93; The name that you want to assign to this namespace.
#' @param CreatorRequestId A unique string that identifies the request and that allows failed
#' `CreateHttpNamespace` requests to be retried without the risk of
#' executing the operation twice. `CreatorRequestId` can be any unique
#' string, for example, a date/time stamp.
#' @param Description A description for the namespace.
#' @param Tags The tags to add to the namespace. Each tag consists of a key and an
#' optional value, both of which you define. Tag keys can have a maximum
#' character length of 128 characters, and tag values can have a maximum
#' length of 256 characters.
#'
#' @section Request syntax:
#' ```
#' svc$create_http_namespace(
#'   Name = "string",
#'   CreatorRequestId = "string",
#'   Description = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example creates an HTTP namespace.
#' svc$create_http_namespace(
#'   CreatorRequestId = "example-creator-request-id-0001",
#'   Description = "Example.com AWS Cloud Map HTTP Namespace",
#'   Name = "example-http.com"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname servicediscovery_create_http_namespace
servicediscovery_create_http_namespace <- function(Name, CreatorRequestId = NULL, Description = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateHttpNamespace",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicediscovery$create_http_namespace_input(Name = Name, CreatorRequestId = CreatorRequestId, Description = Description, Tags = Tags)
  output <- .servicediscovery$create_http_namespace_output()
  config <- get_config()
  svc <- .servicediscovery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicediscovery$operations$create_http_namespace <- servicediscovery_create_http_namespace

#' Creates a private namespace based on DNS, which will be visible only
#' inside a specified Amazon VPC
#'
#' @description
#' Creates a private namespace based on DNS, which will be visible only
#' inside a specified Amazon VPC. The namespace defines your service naming
#' scheme. For example, if you name your namespace `example.com` and name
#' your service `backend`, the resulting DNS name for the service will be
#' `backend.example.com`. For the current quota on the number of namespaces
#' that you can create using the same AWS account, see [AWS Cloud Map
#' Limits](https://docs.aws.amazon.com/cloud-map/latest/dg/cloud-map-limits.html)
#' in the *AWS Cloud Map Developer Guide*.
#'
#' @usage
#' servicediscovery_create_private_dns_namespace(Name, CreatorRequestId,
#'   Description, Vpc, Tags)
#'
#' @param Name &#91;required&#93; The name that you want to assign to this namespace. When you create a
#' private DNS namespace, AWS Cloud Map automatically creates an Amazon
#' Route 53 private hosted zone that has the same name as the namespace.
#' @param CreatorRequestId A unique string that identifies the request and that allows failed
#' `CreatePrivateDnsNamespace` requests to be retried without the risk of
#' executing the operation twice. `CreatorRequestId` can be any unique
#' string, for example, a date/time stamp.
#' @param Description A description for the namespace.
#' @param Vpc &#91;required&#93; The ID of the Amazon VPC that you want to associate the namespace with.
#' @param Tags The tags to add to the namespace. Each tag consists of a key and an
#' optional value, both of which you define. Tag keys can have a maximum
#' character length of 128 characters, and tag values can have a maximum
#' length of 256 characters.
#'
#' @section Request syntax:
#' ```
#' svc$create_private_dns_namespace(
#'   Name = "string",
#'   CreatorRequestId = "string",
#'   Description = "string",
#'   Vpc = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Example: Create private DNS namespace
#' svc$create_private_dns_namespace(
#'   CreatorRequestId = "eedd6892-50f3-41b2-8af9-611d6e1d1a8c",
#'   Name = "example.com",
#'   Vpc = "vpc-1c56417b"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname servicediscovery_create_private_dns_namespace
servicediscovery_create_private_dns_namespace <- function(Name, CreatorRequestId = NULL, Description = NULL, Vpc, Tags = NULL) {
  op <- new_operation(
    name = "CreatePrivateDnsNamespace",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicediscovery$create_private_dns_namespace_input(Name = Name, CreatorRequestId = CreatorRequestId, Description = Description, Vpc = Vpc, Tags = Tags)
  output <- .servicediscovery$create_private_dns_namespace_output()
  config <- get_config()
  svc <- .servicediscovery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicediscovery$operations$create_private_dns_namespace <- servicediscovery_create_private_dns_namespace

#' Creates a public namespace based on DNS, which will be visible on the
#' internet
#'
#' @description
#' Creates a public namespace based on DNS, which will be visible on the
#' internet. The namespace defines your service naming scheme. For example,
#' if you name your namespace `example.com` and name your service
#' `backend`, the resulting DNS name for the service will be
#' `backend.example.com`. For the current quota on the number of namespaces
#' that you can create using the same AWS account, see [AWS Cloud Map
#' Limits](https://docs.aws.amazon.com/cloud-map/latest/dg/cloud-map-limits.html)
#' in the *AWS Cloud Map Developer Guide*.
#'
#' @usage
#' servicediscovery_create_public_dns_namespace(Name, CreatorRequestId,
#'   Description, Tags)
#'
#' @param Name &#91;required&#93; The name that you want to assign to this namespace.
#' @param CreatorRequestId A unique string that identifies the request and that allows failed
#' `CreatePublicDnsNamespace` requests to be retried without the risk of
#' executing the operation twice. `CreatorRequestId` can be any unique
#' string, for example, a date/time stamp.
#' @param Description A description for the namespace.
#' @param Tags The tags to add to the namespace. Each tag consists of a key and an
#' optional value, both of which you define. Tag keys can have a maximum
#' character length of 128 characters, and tag values can have a maximum
#' length of 256 characters.
#'
#' @section Request syntax:
#' ```
#' svc$create_public_dns_namespace(
#'   Name = "string",
#'   CreatorRequestId = "string",
#'   Description = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example creates a public namespace based on DNS.
#' svc$create_public_dns_namespace(
#'   CreatorRequestId = "example-creator-request-id-0003",
#'   Description = "Example.com AWS Cloud Map Public DNS Namespace",
#'   Name = "example-public-dns.com"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname servicediscovery_create_public_dns_namespace
servicediscovery_create_public_dns_namespace <- function(Name, CreatorRequestId = NULL, Description = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreatePublicDnsNamespace",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicediscovery$create_public_dns_namespace_input(Name = Name, CreatorRequestId = CreatorRequestId, Description = Description, Tags = Tags)
  output <- .servicediscovery$create_public_dns_namespace_output()
  config <- get_config()
  svc <- .servicediscovery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicediscovery$operations$create_public_dns_namespace <- servicediscovery_create_public_dns_namespace

#' Creates a service, which defines the configuration for the following
#' entities: - For public and private DNS namespaces, one of the following
#' combinations of DNS records in Amazon Route 53: - A - AAAA - A and AAAA
#' - SRV - CNAME - Optionally, a health check After you create the service,
#' you can submit a RegisterInstance request, and AWS Cloud Map uses the
#' values in the configuration to create the specified entities
#'
#' @description
#' Creates a service, which defines the configuration for the following
#' entities:
#' 
#' -   For public and private DNS namespaces, one of the following
#'     combinations of DNS records in Amazon Route 53:
#' 
#'     -   `A`
#' 
#'     -   `AAAA`
#' 
#'     -   `A` and `AAAA`
#' 
#'     -   `SRV`
#' 
#'     -   `CNAME`
#' 
#' -   Optionally, a health check
#' 
#' After you create the service, you can submit a
#' [RegisterInstance](https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html)
#' request, and AWS Cloud Map uses the values in the configuration to
#' create the specified entities.
#' 
#' For the current quota on the number of instances that you can register
#' using the same namespace and using the same service, see [AWS Cloud Map
#' Limits](https://docs.aws.amazon.com/cloud-map/latest/dg/cloud-map-limits.html)
#' in the *AWS Cloud Map Developer Guide*.
#'
#' @usage
#' servicediscovery_create_service(Name, NamespaceId, CreatorRequestId,
#'   Description, DnsConfig, HealthCheckConfig, HealthCheckCustomConfig,
#'   Tags)
#'
#' @param Name &#91;required&#93; The name that you want to assign to the service.
#' 
#' If you want AWS Cloud Map to create an `SRV` record when you register an
#' instance, and if you're using a system that requires a specific `SRV`
#' format, such as [HAProxy](http://www.haproxy.org/), specify the
#' following for `Name`:
#' 
#' -   Start the name with an underscore (\\_), such as `_exampleservice`
#' 
#' -   End the name with *.\\_protocol*, such as `._tcp`
#' 
#' When you register an instance, AWS Cloud Map creates an `SRV` record and
#' assigns a name to the record by concatenating the service name and the
#' namespace name, for example:
#' 
#' `_exampleservice._tcp.example.com`
#' @param NamespaceId The ID of the namespace that you want to use to create the service.
#' @param CreatorRequestId A unique string that identifies the request and that allows failed
#' `CreateService` requests to be retried without the risk of executing the
#' operation twice. `CreatorRequestId` can be any unique string, for
#' example, a date/time stamp.
#' @param Description A description for the service.
#' @param DnsConfig A complex type that contains information about the Amazon Route 53
#' records that you want AWS Cloud Map to create when you register an
#' instance.
#' @param HealthCheckConfig *Public DNS and HTTP namespaces only.* A complex type that contains
#' settings for an optional Route 53 health check. If you specify settings
#' for a health check, AWS Cloud Map associates the health check with all
#' the Route 53 DNS records that you specify in `DnsConfig`.
#' 
#' If you specify a health check configuration, you can specify either
#' `HealthCheckCustomConfig` or `HealthCheckConfig` but not both.
#' 
#' For information about the charges for health checks, see [AWS Cloud Map
#' Pricing](https://aws.amazon.com/cloud-map/pricing/).
#' @param HealthCheckCustomConfig A complex type that contains information about an optional custom health
#' check.
#' 
#' If you specify a health check configuration, you can specify either
#' `HealthCheckCustomConfig` or `HealthCheckConfig` but not both.
#' 
#' You can't add, update, or delete a `HealthCheckCustomConfig`
#' configuration from an existing service.
#' @param Tags The tags to add to the service. Each tag consists of a key and an
#' optional value, both of which you define. Tag keys can have a maximum
#' character length of 128 characters, and tag values can have a maximum
#' length of 256 characters.
#'
#' @section Request syntax:
#' ```
#' svc$create_service(
#'   Name = "string",
#'   NamespaceId = "string",
#'   CreatorRequestId = "string",
#'   Description = "string",
#'   DnsConfig = list(
#'     NamespaceId = "string",
#'     RoutingPolicy = "MULTIVALUE"|"WEIGHTED",
#'     DnsRecords = list(
#'       list(
#'         Type = "SRV"|"A"|"AAAA"|"CNAME",
#'         TTL = 123
#'       )
#'     )
#'   ),
#'   HealthCheckConfig = list(
#'     Type = "HTTP"|"HTTPS"|"TCP",
#'     ResourcePath = "string",
#'     FailureThreshold = 123
#'   ),
#'   HealthCheckCustomConfig = list(
#'     FailureThreshold = 123
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Example: Create service
#' svc$create_service(
#'   CreatorRequestId = "567c1193-6b00-4308-bd57-ad38a8822d25",
#'   DnsConfig = list(
#'     DnsRecords = list(
#'       list(
#'         TTL = 60L,
#'         Type = "A"
#'       )
#'     ),
#'     NamespaceId = "ns-ylexjili4cdxy3xm",
#'     RoutingPolicy = "MULTIVALUE"
#'   ),
#'   Name = "myservice",
#'   NamespaceId = "ns-ylexjili4cdxy3xm"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname servicediscovery_create_service
servicediscovery_create_service <- function(Name, NamespaceId = NULL, CreatorRequestId = NULL, Description = NULL, DnsConfig = NULL, HealthCheckConfig = NULL, HealthCheckCustomConfig = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateService",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicediscovery$create_service_input(Name = Name, NamespaceId = NamespaceId, CreatorRequestId = CreatorRequestId, Description = Description, DnsConfig = DnsConfig, HealthCheckConfig = HealthCheckConfig, HealthCheckCustomConfig = HealthCheckCustomConfig, Tags = Tags)
  output <- .servicediscovery$create_service_output()
  config <- get_config()
  svc <- .servicediscovery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicediscovery$operations$create_service <- servicediscovery_create_service

#' Deletes a namespace from the current account
#'
#' @description
#' Deletes a namespace from the current account. If the namespace still
#' contains one or more services, the request fails.
#'
#' @usage
#' servicediscovery_delete_namespace(Id)
#'
#' @param Id &#91;required&#93; The ID of the namespace that you want to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_namespace(
#'   Id = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Example: Delete namespace
#' svc$delete_namespace(
#'   Id = "ns-ylexjili4cdxy3xm"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname servicediscovery_delete_namespace
servicediscovery_delete_namespace <- function(Id) {
  op <- new_operation(
    name = "DeleteNamespace",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicediscovery$delete_namespace_input(Id = Id)
  output <- .servicediscovery$delete_namespace_output()
  config <- get_config()
  svc <- .servicediscovery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicediscovery$operations$delete_namespace <- servicediscovery_delete_namespace

#' Deletes a specified service
#'
#' @description
#' Deletes a specified service. If the service still contains one or more
#' registered instances, the request fails.
#'
#' @usage
#' servicediscovery_delete_service(Id)
#'
#' @param Id &#91;required&#93; The ID of the service that you want to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_service(
#'   Id = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Example: Delete service
#' svc$delete_service(
#'   Id = "srv-p5zdwlg5uvvzjita"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname servicediscovery_delete_service
servicediscovery_delete_service <- function(Id) {
  op <- new_operation(
    name = "DeleteService",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicediscovery$delete_service_input(Id = Id)
  output <- .servicediscovery$delete_service_output()
  config <- get_config()
  svc <- .servicediscovery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicediscovery$operations$delete_service <- servicediscovery_delete_service

#' Deletes the Amazon Route 53 DNS records and health check, if any, that
#' AWS Cloud Map created for the specified instance
#'
#' @description
#' Deletes the Amazon Route 53 DNS records and health check, if any, that
#' AWS Cloud Map created for the specified instance.
#'
#' @usage
#' servicediscovery_deregister_instance(ServiceId, InstanceId)
#'
#' @param ServiceId &#91;required&#93; The ID of the service that the instance is associated with.
#' @param InstanceId &#91;required&#93; The value that you specified for `Id` in the
#' [RegisterInstance](https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html)
#' request.
#'
#' @section Request syntax:
#' ```
#' svc$deregister_instance(
#'   ServiceId = "string",
#'   InstanceId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Example: Deregister a service instance
#' svc$deregister_instance(
#'   InstanceId = "myservice-53",
#'   ServiceId = "srv-p5zdwlg5uvvzjita"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname servicediscovery_deregister_instance
servicediscovery_deregister_instance <- function(ServiceId, InstanceId) {
  op <- new_operation(
    name = "DeregisterInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicediscovery$deregister_instance_input(ServiceId = ServiceId, InstanceId = InstanceId)
  output <- .servicediscovery$deregister_instance_output()
  config <- get_config()
  svc <- .servicediscovery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicediscovery$operations$deregister_instance <- servicediscovery_deregister_instance

#' Discovers registered instances for a specified namespace and service
#'
#' @description
#' Discovers registered instances for a specified namespace and service.
#' You can use `DiscoverInstances` to discover instances for any type of
#' namespace. For public and private DNS namespaces, you can also use DNS
#' queries to discover instances.
#'
#' @usage
#' servicediscovery_discover_instances(NamespaceName, ServiceName,
#'   MaxResults, QueryParameters, OptionalParameters, HealthStatus)
#'
#' @param NamespaceName &#91;required&#93; The name of the namespace that you specified when you registered the
#' instance.
#' @param ServiceName &#91;required&#93; The name of the service that you specified when you registered the
#' instance.
#' @param MaxResults The maximum number of instances that you want AWS Cloud Map to return in
#' the response to a `DiscoverInstances` request. If you don't specify a
#' value for `MaxResults`, AWS Cloud Map returns up to 100 instances.
#' @param QueryParameters Filters to scope the results based on custom attributes for the
#' instance. For example, `\{version=v1, az=1a\}`. Only instances that match
#' all the specified key-value pairs will be returned.
#' @param OptionalParameters Opportunistic filters to scope the results based on custom attributes.
#' If there are instances that match both the filters specified in both the
#' `QueryParameters` parameter and this parameter, they are returned.
#' Otherwise, these filters are ignored and only instances that match the
#' filters specified in the `QueryParameters` parameter are returned.
#' @param HealthStatus The health status of the instances that you want to discover.
#'
#' @section Request syntax:
#' ```
#' svc$discover_instances(
#'   NamespaceName = "string",
#'   ServiceName = "string",
#'   MaxResults = 123,
#'   QueryParameters = list(
#'     "string"
#'   ),
#'   OptionalParameters = list(
#'     "string"
#'   ),
#'   HealthStatus = "HEALTHY"|"UNHEALTHY"|"ALL"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Example: Discover registered instances
#' svc$discover_instances(
#'   HealthStatus = "ALL",
#'   MaxResults = 10L,
#'   NamespaceName = "example.com",
#'   ServiceName = "myservice"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname servicediscovery_discover_instances
servicediscovery_discover_instances <- function(NamespaceName, ServiceName, MaxResults = NULL, QueryParameters = NULL, OptionalParameters = NULL, HealthStatus = NULL) {
  op <- new_operation(
    name = "DiscoverInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicediscovery$discover_instances_input(NamespaceName = NamespaceName, ServiceName = ServiceName, MaxResults = MaxResults, QueryParameters = QueryParameters, OptionalParameters = OptionalParameters, HealthStatus = HealthStatus)
  output <- .servicediscovery$discover_instances_output()
  config <- get_config()
  svc <- .servicediscovery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicediscovery$operations$discover_instances <- servicediscovery_discover_instances

#' Gets information about a specified instance
#'
#' @description
#' Gets information about a specified instance.
#'
#' @usage
#' servicediscovery_get_instance(ServiceId, InstanceId)
#'
#' @param ServiceId &#91;required&#93; The ID of the service that the instance is associated with.
#' @param InstanceId &#91;required&#93; The ID of the instance that you want to get information about.
#'
#' @section Request syntax:
#' ```
#' svc$get_instance(
#'   ServiceId = "string",
#'   InstanceId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example gets information about a specified instance.
#' svc$get_instance(
#'   InstanceId = "i-abcd1234",
#'   ServiceId = "srv-e4anhexample0004"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname servicediscovery_get_instance
servicediscovery_get_instance <- function(ServiceId, InstanceId) {
  op <- new_operation(
    name = "GetInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicediscovery$get_instance_input(ServiceId = ServiceId, InstanceId = InstanceId)
  output <- .servicediscovery$get_instance_output()
  config <- get_config()
  svc <- .servicediscovery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicediscovery$operations$get_instance <- servicediscovery_get_instance

#' Gets the current health status (Healthy, Unhealthy, or Unknown) of one
#' or more instances that are associated with a specified service
#'
#' @description
#' Gets the current health status (`Healthy`, `Unhealthy`, or `Unknown`) of
#' one or more instances that are associated with a specified service.
#' 
#' There is a brief delay between when you register an instance and when
#' the health status for the instance is available.
#'
#' @usage
#' servicediscovery_get_instances_health_status(ServiceId, Instances,
#'   MaxResults, NextToken)
#'
#' @param ServiceId &#91;required&#93; The ID of the service that the instance is associated with.
#' @param Instances An array that contains the IDs of all the instances that you want to get
#' the health status for.
#' 
#' If you omit `Instances`, AWS Cloud Map returns the health status for all
#' the instances that are associated with the specified service.
#' 
#' To get the IDs for the instances that you've registered by using a
#' specified service, submit a
#' [ListInstances](https://docs.aws.amazon.com/cloud-map/latest/api/API_ListInstances.html)
#' request.
#' @param MaxResults The maximum number of instances that you want AWS Cloud Map to return in
#' the response to a `GetInstancesHealthStatus` request. If you don't
#' specify a value for `MaxResults`, AWS Cloud Map returns up to 100
#' instances.
#' @param NextToken For the first `GetInstancesHealthStatus` request, omit this value.
#' 
#' If more than `MaxResults` instances match the specified criteria, you
#' can submit another `GetInstancesHealthStatus` request to get the next
#' group of results. Specify the value of `NextToken` from the previous
#' response in the next request.
#'
#' @section Request syntax:
#' ```
#' svc$get_instances_health_status(
#'   ServiceId = "string",
#'   Instances = list(
#'     "string"
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example gets the current health status of one or more instances
#' # that are associate with a specified service.
#' svc$get_instances_health_status(
#'   ServiceId = "srv-e4anhexample0004"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname servicediscovery_get_instances_health_status
servicediscovery_get_instances_health_status <- function(ServiceId, Instances = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetInstancesHealthStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicediscovery$get_instances_health_status_input(ServiceId = ServiceId, Instances = Instances, MaxResults = MaxResults, NextToken = NextToken)
  output <- .servicediscovery$get_instances_health_status_output()
  config <- get_config()
  svc <- .servicediscovery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicediscovery$operations$get_instances_health_status <- servicediscovery_get_instances_health_status

#' Gets information about a namespace
#'
#' @description
#' Gets information about a namespace.
#'
#' @usage
#' servicediscovery_get_namespace(Id)
#'
#' @param Id &#91;required&#93; The ID of the namespace that you want to get information about.
#'
#' @section Request syntax:
#' ```
#' svc$get_namespace(
#'   Id = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example gets information about a specified namespace.
#' svc$get_namespace(
#'   Id = "ns-e4anhexample0004"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname servicediscovery_get_namespace
servicediscovery_get_namespace <- function(Id) {
  op <- new_operation(
    name = "GetNamespace",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicediscovery$get_namespace_input(Id = Id)
  output <- .servicediscovery$get_namespace_output()
  config <- get_config()
  svc <- .servicediscovery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicediscovery$operations$get_namespace <- servicediscovery_get_namespace

#' Gets information about any operation that returns an operation ID in the
#' response, such as a CreateService request
#'
#' @description
#' Gets information about any operation that returns an operation ID in the
#' response, such as a `CreateService` request.
#' 
#' To get a list of operations that match specified criteria, see
#' [ListOperations](https://docs.aws.amazon.com/cloud-map/latest/api/API_ListOperations.html).
#'
#' @usage
#' servicediscovery_get_operation(OperationId)
#'
#' @param OperationId &#91;required&#93; The ID of the operation that you want to get more information about.
#'
#' @section Request syntax:
#' ```
#' svc$get_operation(
#'   OperationId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Example: Get operation result
#' svc$get_operation(
#'   OperationId = "gv4g5meo7ndmeh4fqskygvk23d2fijwa-k9302yzd"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname servicediscovery_get_operation
servicediscovery_get_operation <- function(OperationId) {
  op <- new_operation(
    name = "GetOperation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicediscovery$get_operation_input(OperationId = OperationId)
  output <- .servicediscovery$get_operation_output()
  config <- get_config()
  svc <- .servicediscovery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicediscovery$operations$get_operation <- servicediscovery_get_operation

#' Gets the settings for a specified service
#'
#' @description
#' Gets the settings for a specified service.
#'
#' @usage
#' servicediscovery_get_service(Id)
#'
#' @param Id &#91;required&#93; The ID of the service that you want to get settings for.
#'
#' @section Request syntax:
#' ```
#' svc$get_service(
#'   Id = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example gets the settings for a specified service.
#' svc$get_service(
#'   Id = "srv-e4anhexample0004"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname servicediscovery_get_service
servicediscovery_get_service <- function(Id) {
  op <- new_operation(
    name = "GetService",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicediscovery$get_service_input(Id = Id)
  output <- .servicediscovery$get_service_output()
  config <- get_config()
  svc <- .servicediscovery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicediscovery$operations$get_service <- servicediscovery_get_service

#' Lists summary information about the instances that you registered by
#' using a specified service
#'
#' @description
#' Lists summary information about the instances that you registered by
#' using a specified service.
#'
#' @usage
#' servicediscovery_list_instances(ServiceId, NextToken, MaxResults)
#'
#' @param ServiceId &#91;required&#93; The ID of the service that you want to list instances for.
#' @param NextToken For the first `ListInstances` request, omit this value.
#' 
#' If more than `MaxResults` instances match the specified criteria, you
#' can submit another `ListInstances` request to get the next group of
#' results. Specify the value of `NextToken` from the previous response in
#' the next request.
#' @param MaxResults The maximum number of instances that you want AWS Cloud Map to return in
#' the response to a `ListInstances` request. If you don't specify a value
#' for `MaxResults`, AWS Cloud Map returns up to 100 instances.
#'
#' @section Request syntax:
#' ```
#' svc$list_instances(
#'   ServiceId = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Example: List service instances
#' svc$list_instances(
#'   ServiceId = "srv-qzpwvt2tfqcegapy"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname servicediscovery_list_instances
servicediscovery_list_instances <- function(ServiceId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicediscovery$list_instances_input(ServiceId = ServiceId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .servicediscovery$list_instances_output()
  config <- get_config()
  svc <- .servicediscovery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicediscovery$operations$list_instances <- servicediscovery_list_instances

#' Lists summary information about the namespaces that were created by the
#' current AWS account
#'
#' @description
#' Lists summary information about the namespaces that were created by the
#' current AWS account.
#'
#' @usage
#' servicediscovery_list_namespaces(NextToken, MaxResults, Filters)
#'
#' @param NextToken For the first `ListNamespaces` request, omit this value.
#' 
#' If the response contains `NextToken`, submit another `ListNamespaces`
#' request to get the next group of results. Specify the value of
#' `NextToken` from the previous response in the next request.
#' 
#' AWS Cloud Map gets `MaxResults` namespaces and then filters them based
#' on the specified criteria. It's possible that no namespaces in the first
#' `MaxResults` namespaces matched the specified criteria but that
#' subsequent groups of `MaxResults` namespaces do contain namespaces that
#' match the criteria.
#' @param MaxResults The maximum number of namespaces that you want AWS Cloud Map to return
#' in the response to a `ListNamespaces` request. If you don't specify a
#' value for `MaxResults`, AWS Cloud Map returns up to 100 namespaces.
#' @param Filters A complex type that contains specifications for the namespaces that you
#' want to list.
#' 
#' If you specify more than one filter, a namespace must match all filters
#' to be returned by `ListNamespaces`.
#'
#' @section Request syntax:
#' ```
#' svc$list_namespaces(
#'   NextToken = "string",
#'   MaxResults = 123,
#'   Filters = list(
#'     list(
#'       Name = "TYPE",
#'       Values = list(
#'         "string"
#'       ),
#'       Condition = "EQ"|"IN"|"BETWEEN"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Example: List namespaces
#' svc$list_namespaces()
#' }
#'
#' @keywords internal
#'
#' @rdname servicediscovery_list_namespaces
servicediscovery_list_namespaces <- function(NextToken = NULL, MaxResults = NULL, Filters = NULL) {
  op <- new_operation(
    name = "ListNamespaces",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicediscovery$list_namespaces_input(NextToken = NextToken, MaxResults = MaxResults, Filters = Filters)
  output <- .servicediscovery$list_namespaces_output()
  config <- get_config()
  svc <- .servicediscovery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicediscovery$operations$list_namespaces <- servicediscovery_list_namespaces

#' Lists operations that match the criteria that you specify
#'
#' @description
#' Lists operations that match the criteria that you specify.
#'
#' @usage
#' servicediscovery_list_operations(NextToken, MaxResults, Filters)
#'
#' @param NextToken For the first `ListOperations` request, omit this value.
#' 
#' If the response contains `NextToken`, submit another `ListOperations`
#' request to get the next group of results. Specify the value of
#' `NextToken` from the previous response in the next request.
#' 
#' AWS Cloud Map gets `MaxResults` operations and then filters them based
#' on the specified criteria. It's possible that no operations in the first
#' `MaxResults` operations matched the specified criteria but that
#' subsequent groups of `MaxResults` operations do contain operations that
#' match the criteria.
#' @param MaxResults The maximum number of items that you want AWS Cloud Map to return in the
#' response to a `ListOperations` request. If you don't specify a value for
#' `MaxResults`, AWS Cloud Map returns up to 100 operations.
#' @param Filters A complex type that contains specifications for the operations that you
#' want to list, for example, operations that you started between a
#' specified start date and end date.
#' 
#' If you specify more than one filter, an operation must match all filters
#' to be returned by `ListOperations`.
#'
#' @section Request syntax:
#' ```
#' svc$list_operations(
#'   NextToken = "string",
#'   MaxResults = 123,
#'   Filters = list(
#'     list(
#'       Name = "NAMESPACE_ID"|"SERVICE_ID"|"STATUS"|"TYPE"|"UPDATE_DATE",
#'       Values = list(
#'         "string"
#'       ),
#'       Condition = "EQ"|"IN"|"BETWEEN"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example gets the operations that have a STATUS of either PENDING or
#' # SUCCESS.
#' svc$list_operations(
#'   Filters = list(
#'     list(
#'       Condition = "IN",
#'       Name = "STATUS",
#'       Values = list(
#'         "PENDING",
#'         "SUCCESS"
#'       )
#'     )
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname servicediscovery_list_operations
servicediscovery_list_operations <- function(NextToken = NULL, MaxResults = NULL, Filters = NULL) {
  op <- new_operation(
    name = "ListOperations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicediscovery$list_operations_input(NextToken = NextToken, MaxResults = MaxResults, Filters = Filters)
  output <- .servicediscovery$list_operations_output()
  config <- get_config()
  svc <- .servicediscovery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicediscovery$operations$list_operations <- servicediscovery_list_operations

#' Lists summary information for all the services that are associated with
#' one or more specified namespaces
#'
#' @description
#' Lists summary information for all the services that are associated with
#' one or more specified namespaces.
#'
#' @usage
#' servicediscovery_list_services(NextToken, MaxResults, Filters)
#'
#' @param NextToken For the first `ListServices` request, omit this value.
#' 
#' If the response contains `NextToken`, submit another `ListServices`
#' request to get the next group of results. Specify the value of
#' `NextToken` from the previous response in the next request.
#' 
#' AWS Cloud Map gets `MaxResults` services and then filters them based on
#' the specified criteria. It's possible that no services in the first
#' `MaxResults` services matched the specified criteria but that subsequent
#' groups of `MaxResults` services do contain services that match the
#' criteria.
#' @param MaxResults The maximum number of services that you want AWS Cloud Map to return in
#' the response to a `ListServices` request. If you don't specify a value
#' for `MaxResults`, AWS Cloud Map returns up to 100 services.
#' @param Filters A complex type that contains specifications for the namespaces that you
#' want to list services for.
#' 
#' If you specify more than one filter, an operation must match all filters
#' to be returned by `ListServices`.
#'
#' @section Request syntax:
#' ```
#' svc$list_services(
#'   NextToken = "string",
#'   MaxResults = 123,
#'   Filters = list(
#'     list(
#'       Name = "NAMESPACE_ID",
#'       Values = list(
#'         "string"
#'       ),
#'       Condition = "EQ"|"IN"|"BETWEEN"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Example: List services
#' svc$list_services()
#' }
#'
#' @keywords internal
#'
#' @rdname servicediscovery_list_services
servicediscovery_list_services <- function(NextToken = NULL, MaxResults = NULL, Filters = NULL) {
  op <- new_operation(
    name = "ListServices",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicediscovery$list_services_input(NextToken = NextToken, MaxResults = MaxResults, Filters = Filters)
  output <- .servicediscovery$list_services_output()
  config <- get_config()
  svc <- .servicediscovery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicediscovery$operations$list_services <- servicediscovery_list_services

#' Lists tags for the specified resource
#'
#' @description
#' Lists tags for the specified resource.
#'
#' @usage
#' servicediscovery_list_tags_for_resource(ResourceARN)
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name (ARN) of the resource that you want to retrieve
#' tags for.
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   ResourceARN = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example lists the tags of a resource.
#' svc$list_tags_for_resource(
#'   ResourceARN = "arn:aws:servicediscovery:us-east-1:123456789012:namespace/ns-ylexjili4cdxy3..."
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname servicediscovery_list_tags_for_resource
servicediscovery_list_tags_for_resource <- function(ResourceARN) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicediscovery$list_tags_for_resource_input(ResourceARN = ResourceARN)
  output <- .servicediscovery$list_tags_for_resource_output()
  config <- get_config()
  svc <- .servicediscovery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicediscovery$operations$list_tags_for_resource <- servicediscovery_list_tags_for_resource

#' Creates or updates one or more records and, optionally, creates a health
#' check based on the settings in a specified service
#'
#' @description
#' Creates or updates one or more records and, optionally, creates a health
#' check based on the settings in a specified service. When you submit a
#' `RegisterInstance` request, the following occurs:
#' 
#' -   For each DNS record that you define in the service that is specified
#'     by `ServiceId`, a record is created or updated in the hosted zone
#'     that is associated with the corresponding namespace.
#' 
#' -   If the service includes `HealthCheckConfig`, a health check is
#'     created based on the settings in the health check configuration.
#' 
#' -   The health check, if any, is associated with each of the new or
#'     updated records.
#' 
#' One `RegisterInstance` request must complete before you can submit
#' another request and specify the same service ID and instance ID.
#' 
#' For more information, see
#' [CreateService](https://docs.aws.amazon.com/cloud-map/latest/api/API_CreateService.html).
#' 
#' When AWS Cloud Map receives a DNS query for the specified DNS name, it
#' returns the applicable value:
#' 
#' -   **If the health check is healthy**: returns all the records
#' 
#' -   **If the health check is unhealthy**: returns the applicable value
#'     for the last healthy instance
#' 
#' -   **If you didn't specify a health check configuration**: returns all
#'     the records
#' 
#' For the current quota on the number of instances that you can register
#' using the same namespace and using the same service, see [AWS Cloud Map
#' Limits](https://docs.aws.amazon.com/cloud-map/latest/dg/cloud-map-limits.html)
#' in the *AWS Cloud Map Developer Guide*.
#'
#' @usage
#' servicediscovery_register_instance(ServiceId, InstanceId,
#'   CreatorRequestId, Attributes)
#'
#' @param ServiceId &#91;required&#93; The ID of the service that you want to use for settings for the
#' instance.
#' @param InstanceId &#91;required&#93; An identifier that you want to associate with the instance. Note the
#' following:
#' 
#' -   If the service that is specified by `ServiceId` includes settings
#'     for an `SRV` record, the value of `InstanceId` is automatically
#'     included as part of the value for the `SRV` record. For more
#'     information, see [DnsRecord &gt;
#'     Type](https://docs.aws.amazon.com/cloud-map/latest/api/API_DnsRecord.html#cloudmap-Type-DnsRecord-Type).
#' 
#' -   You can use this value to update an existing instance.
#' 
#' -   To register a new instance, you must specify a value that is unique
#'     among instances that you register by using the same service.
#' 
#' -   If you specify an existing `InstanceId` and `ServiceId`, AWS Cloud
#'     Map updates the existing DNS records, if any. If there's also an
#'     existing health check, AWS Cloud Map deletes the old health check
#'     and creates a new one.
#' 
#'     The health check isn't deleted immediately, so it will still appear
#'     for a while if you submit a `ListHealthChecks` request, for example.
#' @param CreatorRequestId A unique string that identifies the request and that allows failed
#' `RegisterInstance` requests to be retried without the risk of executing
#' the operation twice. You must use a unique `CreatorRequestId` string
#' every time you submit a `RegisterInstance` request if you're registering
#' additional instances for the same namespace and service.
#' `CreatorRequestId` can be any unique string, for example, a date/time
#' stamp.
#' @param Attributes &#91;required&#93; A string map that contains the following information for the service
#' that you specify in `ServiceId`:
#' 
#' -   The attributes that apply to the records that are defined in the
#'     service.
#' 
#' -   For each attribute, the applicable value.
#' 
#' Supported attribute keys include the following:
#' 
#' **AWS\\_ALIAS\\_DNS\\_NAME**
#' 
#' If you want AWS Cloud Map to create an Amazon Route 53 alias record that
#' routes traffic to an Elastic Load Balancing load balancer, specify the
#' DNS name that is associated with the load balancer. For information
#' about how to get the DNS name, see "DNSName" in the topic
#' [AliasTarget](https://docs.aws.amazon.com/Route53/latest/APIReference/API_AliasTarget.html)
#' in the *Route 53 API Reference*.
#' 
#' Note the following:
#' 
#' -   The configuration for the service that is specified by `ServiceId`
#'     must include settings for an `A` record, an `AAAA` record, or both.
#' 
#' -   In the service that is specified by `ServiceId`, the value of
#'     `RoutingPolicy` must be `WEIGHTED`.
#' 
#' -   If the service that is specified by `ServiceId` includes
#'     `HealthCheckConfig` settings, AWS Cloud Map will create the Route 53
#'     health check, but it won't associate the health check with the alias
#'     record.
#' 
#' -   Auto naming currently doesn't support creating alias records that
#'     route traffic to AWS resources other than Elastic Load Balancing
#'     load balancers.
#' 
#' -   If you specify a value for `AWS_ALIAS_DNS_NAME`, don't specify
#'     values for any of the `AWS_INSTANCE` attributes.
#' 
#' **AWS\\_EC2\\_INSTANCE\\_ID**
#' 
#' *HTTP namespaces only.* The Amazon EC2 instance ID for the instance. If
#' the `AWS_EC2_INSTANCE_ID` attribute is specified, then the only other
#' attribute that can be specified is `AWS_INIT_HEALTH_STATUS`. When the
#' `AWS_EC2_INSTANCE_ID` attribute is specified, then the
#' `AWS_INSTANCE_IPV4` attribute will be filled out with the primary
#' private IPv4 address.
#' 
#' **AWS\\_INIT\\_HEALTH\\_STATUS**
#' 
#' If the service configuration includes `HealthCheckCustomConfig`, you can
#' optionally use `AWS_INIT_HEALTH_STATUS` to specify the initial status of
#' the custom health check, `HEALTHY` or `UNHEALTHY`. If you don't specify
#' a value for `AWS_INIT_HEALTH_STATUS`, the initial status is `HEALTHY`.
#' 
#' **AWS\\_INSTANCE\\_CNAME**
#' 
#' If the service configuration includes a `CNAME` record, the domain name
#' that you want Route 53 to return in response to DNS queries, for
#' example, `example.com`.
#' 
#' This value is required if the service specified by `ServiceId` includes
#' settings for an `CNAME` record.
#' 
#' **AWS\\_INSTANCE\\_IPV4**
#' 
#' If the service configuration includes an `A` record, the IPv4 address
#' that you want Route 53 to return in response to DNS queries, for
#' example, `192.0.2.44`.
#' 
#' This value is required if the service specified by `ServiceId` includes
#' settings for an `A` record. If the service includes settings for an
#' `SRV` record, you must specify a value for `AWS_INSTANCE_IPV4`,
#' `AWS_INSTANCE_IPV6`, or both.
#' 
#' **AWS\\_INSTANCE\\_IPV6**
#' 
#' If the service configuration includes an `AAAA` record, the IPv6 address
#' that you want Route 53 to return in response to DNS queries, for
#' example, `2001:0db8:85a3:0000:0000:abcd:0001:2345`.
#' 
#' This value is required if the service specified by `ServiceId` includes
#' settings for an `AAAA` record. If the service includes settings for an
#' `SRV` record, you must specify a value for `AWS_INSTANCE_IPV4`,
#' `AWS_INSTANCE_IPV6`, or both.
#' 
#' **AWS\\_INSTANCE\\_PORT**
#' 
#' If the service includes an `SRV` record, the value that you want
#' Route 53 to return for the port.
#' 
#' If the service includes `HealthCheckConfig`, the port on the endpoint
#' that you want Route 53 to send requests to.
#' 
#' This value is required if you specified settings for an `SRV` record or
#' a Route 53 health check when you created the service.
#' 
#' **Custom attributes**
#' 
#' You can add up to 30 custom attributes. For each key-value pair, the
#' maximum length of the attribute name is 255 characters, and the maximum
#' length of the attribute value is 1,024 characters. The total size of all
#' provided attributes (sum of all keys and values) must not exceed 5,000
#' characters.
#'
#' @section Request syntax:
#' ```
#' svc$register_instance(
#'   ServiceId = "string",
#'   InstanceId = "string",
#'   CreatorRequestId = "string",
#'   Attributes = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Example: Register Instance
#' svc$register_instance(
#'   Attributes = list(
#'     AWS_INSTANCE_IPV4 = "172.2.1.3",
#'     AWS_INSTANCE_PORT = "808"
#'   ),
#'   CreatorRequestId = "7a48a98a-72e6-4849-bfa7-1a458e030d7b",
#'   InstanceId = "myservice-53",
#'   ServiceId = "srv-p5zdwlg5uvvzjita"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname servicediscovery_register_instance
servicediscovery_register_instance <- function(ServiceId, InstanceId, CreatorRequestId = NULL, Attributes) {
  op <- new_operation(
    name = "RegisterInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicediscovery$register_instance_input(ServiceId = ServiceId, InstanceId = InstanceId, CreatorRequestId = CreatorRequestId, Attributes = Attributes)
  output <- .servicediscovery$register_instance_output()
  config <- get_config()
  svc <- .servicediscovery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicediscovery$operations$register_instance <- servicediscovery_register_instance

#' Adds one or more tags to the specified resource
#'
#' @description
#' Adds one or more tags to the specified resource.
#'
#' @usage
#' servicediscovery_tag_resource(ResourceARN, Tags)
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name (ARN) of the resource that you want to retrieve
#' tags for.
#' @param Tags &#91;required&#93; The tags to add to the specified resource. Specifying the tag key is
#' required. You can set the value of a tag to an empty string, but you
#' can't set the value of a tag to null.
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   ResourceARN = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example adds "Department" and "Project" tags to a resource.
#' svc$tag_resource(
#'   ResourceARN = "arn:aws:servicediscovery:us-east-1:123456789012:namespace/ns-ylexjili4cdxy3...",
#'   Tags = list(
#'     list(
#'       Key = "Department",
#'       Value = "Engineering"
#'     ),
#'     list(
#'       Key = "Project",
#'       Value = "Zeta"
#'     )
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname servicediscovery_tag_resource
servicediscovery_tag_resource <- function(ResourceARN, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicediscovery$tag_resource_input(ResourceARN = ResourceARN, Tags = Tags)
  output <- .servicediscovery$tag_resource_output()
  config <- get_config()
  svc <- .servicediscovery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicediscovery$operations$tag_resource <- servicediscovery_tag_resource

#' Removes one or more tags from the specified resource
#'
#' @description
#' Removes one or more tags from the specified resource.
#'
#' @usage
#' servicediscovery_untag_resource(ResourceARN, TagKeys)
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name (ARN) of the resource that you want to retrieve
#' tags for.
#' @param TagKeys &#91;required&#93; The tag keys to remove from the specified resource.
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   ResourceARN = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example removes the "Department" and "Project" tags from a
#' # resource.
#' svc$untag_resource(
#'   ResourceARN = "arn:aws:servicediscovery:us-east-1:123456789012:namespace/ns-ylexjili4cdxy3...",
#'   TagKeys = list(
#'     "Project",
#'     "Department"
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname servicediscovery_untag_resource
servicediscovery_untag_resource <- function(ResourceARN, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicediscovery$untag_resource_input(ResourceARN = ResourceARN, TagKeys = TagKeys)
  output <- .servicediscovery$untag_resource_output()
  config <- get_config()
  svc <- .servicediscovery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicediscovery$operations$untag_resource <- servicediscovery_untag_resource

#' Submits a request to change the health status of a custom health check
#' to healthy or unhealthy
#'
#' @description
#' Submits a request to change the health status of a custom health check
#' to healthy or unhealthy.
#' 
#' You can use `UpdateInstanceCustomHealthStatus` to change the status only
#' for custom health checks, which you define using
#' `HealthCheckCustomConfig` when you create a service. You can't use it to
#' change the status for Route 53 health checks, which you define using
#' `HealthCheckConfig`.
#' 
#' For more information, see
#' [HealthCheckCustomConfig](https://docs.aws.amazon.com/cloud-map/latest/api/API_HealthCheckCustomConfig.html).
#'
#' @usage
#' servicediscovery_update_instance_custom_health_status(ServiceId,
#'   InstanceId, Status)
#'
#' @param ServiceId &#91;required&#93; The ID of the service that includes the configuration for the custom
#' health check that you want to change the status for.
#' @param InstanceId &#91;required&#93; The ID of the instance that you want to change the health status for.
#' @param Status &#91;required&#93; The new status of the instance, `HEALTHY` or `UNHEALTHY`.
#'
#' @section Request syntax:
#' ```
#' svc$update_instance_custom_health_status(
#'   ServiceId = "string",
#'   InstanceId = "string",
#'   Status = "HEALTHY"|"UNHEALTHY"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example submits a request to change the health status of an
#' # instance associated with a service with a custom health check to
#' # HEALTHY.
#' svc$update_instance_custom_health_status(
#'   InstanceId = "i-abcd1234",
#'   ServiceId = "srv-e4anhexample0004",
#'   Status = "HEALTHY"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname servicediscovery_update_instance_custom_health_status
servicediscovery_update_instance_custom_health_status <- function(ServiceId, InstanceId, Status) {
  op <- new_operation(
    name = "UpdateInstanceCustomHealthStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicediscovery$update_instance_custom_health_status_input(ServiceId = ServiceId, InstanceId = InstanceId, Status = Status)
  output <- .servicediscovery$update_instance_custom_health_status_output()
  config <- get_config()
  svc <- .servicediscovery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicediscovery$operations$update_instance_custom_health_status <- servicediscovery_update_instance_custom_health_status

#' Submits a request to perform the following operations: - Update the TTL
#' setting for existing DnsRecords configurations - Add, update, or delete
#' HealthCheckConfig for a specified service You can't add, update, or
#' delete a HealthCheckCustomConfig configuration
#'
#' @description
#' Submits a request to perform the following operations:
#' 
#' -   Update the TTL setting for existing `DnsRecords` configurations
#' 
#' -   Add, update, or delete `HealthCheckConfig` for a specified service
#' 
#'     You can't add, update, or delete a `HealthCheckCustomConfig`
#'     configuration.
#' 
#' For public and private DNS namespaces, note the following:
#' 
#' -   If you omit any existing `DnsRecords` or `HealthCheckConfig`
#'     configurations from an `UpdateService` request, the configurations
#'     are deleted from the service.
#' 
#' -   If you omit an existing `HealthCheckCustomConfig` configuration from
#'     an `UpdateService` request, the configuration is not deleted from
#'     the service.
#' 
#' When you update settings for a service, AWS Cloud Map also updates the
#' corresponding settings in all the records and health checks that were
#' created by using the specified service.
#'
#' @usage
#' servicediscovery_update_service(Id, Service)
#'
#' @param Id &#91;required&#93; The ID of the service that you want to update.
#' @param Service &#91;required&#93; A complex type that contains the new settings for the service.
#'
#' @section Request syntax:
#' ```
#' svc$update_service(
#'   Id = "string",
#'   Service = list(
#'     Description = "string",
#'     DnsConfig = list(
#'       DnsRecords = list(
#'         list(
#'           Type = "SRV"|"A"|"AAAA"|"CNAME",
#'           TTL = 123
#'         )
#'       )
#'     ),
#'     HealthCheckConfig = list(
#'       Type = "HTTP"|"HTTPS"|"TCP",
#'       ResourcePath = "string",
#'       FailureThreshold = 123
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example submits a request to replace the DnsConfig and
#' # HealthCheckConfig settings of a specified service.
#' svc$update_service(
#'   Id = "srv-e4anhexample0004",
#'   Service = list(
#'     DnsConfig = list(
#'       DnsRecords = list(
#'         list(
#'           TTL = 60L,
#'           Type = "A"
#'         )
#'       )
#'     ),
#'     HealthCheckConfig = list(
#'       FailureThreshold = 2L,
#'       ResourcePath = "/",
#'       Type = "HTTP"
#'     )
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname servicediscovery_update_service
servicediscovery_update_service <- function(Id, Service) {
  op <- new_operation(
    name = "UpdateService",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicediscovery$update_service_input(Id = Id, Service = Service)
  output <- .servicediscovery$update_service_output()
  config <- get_config()
  svc <- .servicediscovery$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicediscovery$operations$update_service <- servicediscovery_update_service
