% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudfront_operations.R
\name{cloudfront_delete_key_group}
\alias{cloudfront_delete_key_group}
\title{Deletes a key group}
\usage{
cloudfront_delete_key_group(Id, IfMatch)
}
\arguments{
\item{Id}{[required] The identifier of the key group that you are deleting. To get the
identifier, use \code{ListKeyGroups}.}

\item{IfMatch}{The version of the key group that you are deleting. The version is the
key group’s \code{ETag} value. To get the \code{ETag}, use \code{GetKeyGroup} or
\code{GetKeyGroupConfig}.}
}
\description{
Deletes a key group.

You cannot delete a key group that is referenced in a cache behavior.
First update your distributions to remove the key group from all cache
behaviors, then delete the key group.

To delete a key group, you must provide the key group’s identifier and
version. To get these values, use \code{ListKeyGroups} followed by
\code{GetKeyGroup} or \code{GetKeyGroupConfig}.
}
\section{Request syntax}{
\preformatted{svc$delete_key_group(
  Id = "string",
  IfMatch = "string"
)
}
}

\keyword{internal}
