% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elbv2_operations.R
\name{elbv2_modify_load_balancer_attributes}
\alias{elbv2_modify_load_balancer_attributes}
\title{Modifies the specified attributes of the specified Application Load
Balancer, Network Load Balancer, or Gateway Load Balancer}
\usage{
elbv2_modify_load_balancer_attributes(LoadBalancerArn, Attributes)
}
\arguments{
\item{LoadBalancerArn}{[required] The Amazon Resource Name (ARN) of the load balancer.}

\item{Attributes}{[required] The load balancer attributes.}
}
\description{
Modifies the specified attributes of the specified Application Load
Balancer, Network Load Balancer, or Gateway Load Balancer.

If any of the specified attributes can't be modified as requested, the
call fails. Any existing attributes that you do not modify retain their
current values.
}
\section{Request syntax}{
\preformatted{svc$modify_load_balancer_attributes(
  LoadBalancerArn = "string",
  Attributes = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\examples{
\dontrun{
# This example enables deletion protection for the specified load
# balancer.
svc$modify_load_balancer_attributes(
  Attributes = list(
    list(
      Key = "deletion_protection.enabled",
      Value = "true"
    )
  ),
  LoadBalancerArn = "arn:aws:elasticloadbalancing:us-west-2:123456789012:loadbalancer/app/my..."
)

# This example changes the idle timeout value for the specified load
# balancer.
svc$modify_load_balancer_attributes(
  Attributes = list(
    list(
      Key = "idle_timeout.timeout_seconds",
      Value = "30"
    )
  ),
  LoadBalancerArn = "arn:aws:elasticloadbalancing:us-west-2:123456789012:loadbalancer/app/my..."
)

# This example enables access logs for the specified load balancer. Note
# that the S3 bucket must exist in the same region as the load balancer
# and must have a policy attached that grants access to the Elastic Load
# Balancing service.
svc$modify_load_balancer_attributes(
  Attributes = list(
    list(
      Key = "access_logs.s3.enabled",
      Value = "true"
    ),
    list(
      Key = "access_logs.s3.bucket",
      Value = "my-loadbalancer-logs"
    ),
    list(
      Key = "access_logs.s3.prefix",
      Value = "myapp"
    )
  ),
  LoadBalancerArn = "arn:aws:elasticloadbalancing:us-west-2:123456789012:loadbalancer/app/my..."
)
}

}
\keyword{internal}
