% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/globalaccelerator_operations.R
\name{globalaccelerator_list_custom_routing_port_mappings_by_destination}
\alias{globalaccelerator_list_custom_routing_port_mappings_by_destination}
\title{List the port mappings for a specific EC2 instance (destination) in a
VPC subnet endpoint}
\usage{
globalaccelerator_list_custom_routing_port_mappings_by_destination(
  EndpointId, DestinationAddress, MaxResults, NextToken)
}
\arguments{
\item{EndpointId}{[required] The ID for the virtual private cloud (VPC) subnet.}

\item{DestinationAddress}{[required] The endpoint IP address in a virtual private cloud (VPC) subnet for
which you want to receive back port mappings.}

\item{MaxResults}{The number of destination port mappings that you want to return with
this call. The default value is 10.}

\item{NextToken}{The token for the next set of results. You receive this token from a
previous call.}
}
\description{
List the port mappings for a specific EC2 instance (destination) in a
VPC subnet endpoint. The response is the mappings for one destination IP
address. This is useful when your subnet endpoint has mappings that span
multiple custom routing accelerators in your account, or for scenarios
where you only want to list the port mappings for a specific destination
instance.
}
\section{Request syntax}{
\preformatted{svc$list_custom_routing_port_mappings_by_destination(
  EndpointId = "string",
  DestinationAddress = "string",
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
