% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53domains_operations.R
\name{route53domains_renew_domain}
\alias{route53domains_renew_domain}
\title{This operation renews a domain for the specified number of years}
\usage{
route53domains_renew_domain(DomainName, DurationInYears,
  CurrentExpiryYear)
}
\arguments{
\item{DomainName}{[required] The name of the domain that you want to renew.}

\item{DurationInYears}{The number of years that you want to renew the domain for. The maximum
number of years depends on the top-level domain. For the range of valid
values for your domain, see \href{https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html}{Domains that You Can Register with Amazon Route 53}
in the \emph{Amazon Route 53 Developer Guide}.

Default: 1}

\item{CurrentExpiryYear}{[required] The year when the registration for the domain is set to expire. This
value must match the current expiration date for the domain.}
}
\description{
This operation renews a domain for the specified number of years. The
cost of renewing your domain is billed to your AWS account.

We recommend that you renew your domain several weeks before the
expiration date. Some TLD registries delete domains before the
expiration date if you haven't renewed far enough in advance. For more
information about renewing domain registration, see \href{https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/domain-renew.html}{Renewing Registration for a Domain}
in the \emph{Amazon Route 53 Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$renew_domain(
  DomainName = "string",
  DurationInYears = 123,
  CurrentExpiryYear = 123
)
}
}

\keyword{internal}
