% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apigatewayv2_operations.R
\name{apigatewayv2_export_api}
\alias{apigatewayv2_export_api}
\title{Export api}
\usage{
apigatewayv2_export_api(ApiId, ExportVersion, IncludeExtensions,
  OutputType, Specification, StageName)
}
\arguments{
\item{ApiId}{[required] The API identifier.}

\item{ExportVersion}{The version of the API Gateway export algorithm. API Gateway uses the
latest version by default. Currently, the only supported version is 1.0.}

\item{IncludeExtensions}{Specifies whether to include \href{https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions.html}{API Gateway extensions}
in the exported API definition. API Gateway extensions are included by
default.}

\item{OutputType}{[required] The output type of the exported definition file. Valid values are JSON
and YAML.}

\item{Specification}{[required] The version of the API specification to use. OAS30, for OpenAPI 3.0, is
the only supported value.}

\item{StageName}{The name of the API stage to export. If you don't specify this property,
a representation of the latest API configuration is exported.}
}
\value{
A list with the following syntax:\preformatted{list(
  body = raw
)
}
}
\description{
Export api
}
\section{Request syntax}{
\preformatted{svc$export_api(
  ApiId = "string",
  ExportVersion = "string",
  IncludeExtensions = TRUE|FALSE,
  OutputType = "YAML"|"JSON",
  Specification = "OAS30",
  StageName = "string"
)
}
}

\keyword{internal}
