% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53_operations.R
\name{route53_list_hosted_zones}
\alias{route53_list_hosted_zones}
\title{Retrieves a list of the public and private hosted zones that are
associated with the current AWS account}
\usage{
route53_list_hosted_zones(Marker, MaxItems, DelegationSetId)
}
\arguments{
\item{Marker}{If the value of \code{IsTruncated} in the previous response was \code{true}, you
have more hosted zones. To get more hosted zones, submit another
\code{\link[=route53_list_hosted_zones]{list_hosted_zones}} request.

For the value of \code{marker}, specify the value of \code{NextMarker} from the
previous response, which is the ID of the first hosted zone that Amazon
Route 53 will return if you submit another request.

If the value of \code{IsTruncated} in the previous response was \code{false},
there are no more hosted zones to get.}

\item{MaxItems}{(Optional) The maximum number of hosted zones that you want Amazon Route
53 to return. If you have more than \code{maxitems} hosted zones, the value
of \code{IsTruncated} in the response is \code{true}, and the value of
\code{NextMarker} is the hosted zone ID of the first hosted zone that Route
53 will return if you submit another request.}

\item{DelegationSetId}{If you're using reusable delegation sets and you want to list all of the
hosted zones that are associated with a reusable delegation set, specify
the ID of that reusable delegation set.}
}
\value{
A list with the following syntax:\preformatted{list(
  HostedZones = list(
    list(
      Id = "string",
      Name = "string",
      CallerReference = "string",
      Config = list(
        Comment = "string",
        PrivateZone = TRUE|FALSE
      ),
      ResourceRecordSetCount = 123,
      LinkedService = list(
        ServicePrincipal = "string",
        Description = "string"
      )
    )
  ),
  Marker = "string",
  IsTruncated = TRUE|FALSE,
  NextMarker = "string",
  MaxItems = "string"
)
}
}
\description{
Retrieves a list of the public and private hosted zones that are
associated with the current AWS account. The response includes a
\code{HostedZones} child element for each hosted zone.

Amazon Route 53 returns a maximum of 100 items in each response. If you
have a lot of hosted zones, you can use the \code{maxitems} parameter to list
them in groups of up to 100.
}
\section{Request syntax}{
\preformatted{svc$list_hosted_zones(
  Marker = "string",
  MaxItems = "string",
  DelegationSetId = "string"
)
}
}

\keyword{internal}
