% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53resolver_operations.R
\name{route53resolver_update_resolver_dnssec_config}
\alias{route53resolver_update_resolver_dnssec_config}
\title{Updates an existing DNSSEC validation configuration}
\usage{
route53resolver_update_resolver_dnssec_config(ResourceId, Validation)
}
\arguments{
\item{ResourceId}{[required] The ID of the virtual private cloud (VPC) that you're updating the
DNSSEC validation status for.}

\item{Validation}{[required] The new value that you are specifying for DNSSEC validation for the VPC.
The value can be \code{ENABLE} or \code{DISABLE}. Be aware that it can take time
for a validation status change to be completed.}
}
\value{
A list with the following syntax:\preformatted{list(
  ResolverDNSSECConfig = list(
    Id = "string",
    OwnerId = "string",
    ResourceId = "string",
    ValidationStatus = "ENABLING"|"ENABLED"|"DISABLING"|"DISABLED"
  )
)
}
}
\description{
Updates an existing DNSSEC validation configuration. If there is no
existing DNSSEC validation configuration, one is created.
}
\section{Request syntax}{
\preformatted{svc$update_resolver_dnssec_config(
  ResourceId = "string",
  Validation = "ENABLE"|"DISABLE"
)
}
}

\keyword{internal}
