# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_operation new_request send_request
#' @include elb_service.R
NULL

#' Adds the specified tags to the specified load balancer
#'
#' Adds the specified tags to the specified load balancer. Each load
#' balancer can have a maximum of 10 tags.
#' 
#' Each tag consists of a key and an optional value. If a tag with the same
#' key is already associated with the load balancer, `AddTags` updates its
#' value.
#' 
#' For more information, see [Tag Your Classic Load
#' Balancer](http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/add-remove-tags.html)
#' in the *Classic Load Balancers Guide*.
#'
#' @usage
#' elb_add_tags(LoadBalancerNames, Tags)
#'
#' @param LoadBalancerNames &#91;required&#93; The name of the load balancer. You can specify one load balancer only.
#' @param Tags &#91;required&#93; The tags.
#'
#' @section Request syntax:
#' ```
#' svc$add_tags(
#'   LoadBalancerNames = list(
#'     "string"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' # This example adds two tags to the specified load balancer.
#' \donttest{svc$add_tags(
#'   LoadBalancerNames = list(
#'     "my-load-balancer"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "project",
#'       Value = "lima"
#'     ),
#'     list(
#'       Key = "department",
#'       Value = "digital-media"
#'     )
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname elb_add_tags
elb_add_tags <- function(LoadBalancerNames, Tags) {
  op <- new_operation(
    name = "AddTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elb$add_tags_input(LoadBalancerNames = LoadBalancerNames, Tags = Tags)
  output <- .elb$add_tags_output()
  svc <- .elb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$add_tags <- elb_add_tags

#' Associates one or more security groups with your load balancer in a
#' virtual private cloud (VPC)
#'
#' Associates one or more security groups with your load balancer in a
#' virtual private cloud (VPC). The specified security groups override the
#' previously associated security groups.
#' 
#' For more information, see [Security Groups for Load Balancers in a
#' VPC](http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-security-groups.html#elb-vpc-security-groups)
#' in the *Classic Load Balancers Guide*.
#'
#' @usage
#' elb_apply_security_groups_to_load_balancer(LoadBalancerName,
#'   SecurityGroups)
#'
#' @param LoadBalancerName &#91;required&#93; The name of the load balancer.
#' @param SecurityGroups &#91;required&#93; The IDs of the security groups to associate with the load balancer. Note
#' that you cannot specify the name of the security group.
#'
#' @section Request syntax:
#' ```
#' svc$apply_security_groups_to_load_balancer(
#'   LoadBalancerName = "string",
#'   SecurityGroups = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # This example associates a security group with the specified load
#' # balancer in a VPC.
#' \donttest{svc$apply_security_groups_to_load_balancer(
#'   LoadBalancerName = "my-load-balancer",
#'   SecurityGroups = list(
#'     "sg-fc448899"
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname elb_apply_security_groups_to_load_balancer
elb_apply_security_groups_to_load_balancer <- function(LoadBalancerName, SecurityGroups) {
  op <- new_operation(
    name = "ApplySecurityGroupsToLoadBalancer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elb$apply_security_groups_to_load_balancer_input(LoadBalancerName = LoadBalancerName, SecurityGroups = SecurityGroups)
  output <- .elb$apply_security_groups_to_load_balancer_output()
  svc <- .elb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$apply_security_groups_to_load_balancer <- elb_apply_security_groups_to_load_balancer

#' Adds one or more subnets to the set of configured subnets for the
#' specified load balancer
#'
#' Adds one or more subnets to the set of configured subnets for the
#' specified load balancer.
#' 
#' The load balancer evenly distributes requests across all registered
#' subnets. For more information, see [Add or Remove Subnets for Your Load
#' Balancer in a
#' VPC](http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-manage-subnets.html)
#' in the *Classic Load Balancers Guide*.
#'
#' @usage
#' elb_attach_load_balancer_to_subnets(LoadBalancerName, Subnets)
#'
#' @param LoadBalancerName &#91;required&#93; The name of the load balancer.
#' @param Subnets &#91;required&#93; The IDs of the subnets to add. You can add only one subnet per
#' Availability Zone.
#'
#' @section Request syntax:
#' ```
#' svc$attach_load_balancer_to_subnets(
#'   LoadBalancerName = "string",
#'   Subnets = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # This example adds the specified subnet to the set of configured subnets
#' # for the specified load balancer.
#' \donttest{svc$attach_load_balancer_to_subnets(
#'   LoadBalancerName = "my-load-balancer",
#'   Subnets = list(
#'     "subnet-0ecac448"
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname elb_attach_load_balancer_to_subnets
elb_attach_load_balancer_to_subnets <- function(LoadBalancerName, Subnets) {
  op <- new_operation(
    name = "AttachLoadBalancerToSubnets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elb$attach_load_balancer_to_subnets_input(LoadBalancerName = LoadBalancerName, Subnets = Subnets)
  output <- .elb$attach_load_balancer_to_subnets_output()
  svc <- .elb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$attach_load_balancer_to_subnets <- elb_attach_load_balancer_to_subnets

#' Specifies the health check settings to use when evaluating the health
#' state of your EC2 instances
#'
#' Specifies the health check settings to use when evaluating the health
#' state of your EC2 instances.
#' 
#' For more information, see [Configure Health Checks for Your Load
#' Balancer](http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-healthchecks.html)
#' in the *Classic Load Balancers Guide*.
#'
#' @usage
#' elb_configure_health_check(LoadBalancerName, HealthCheck)
#'
#' @param LoadBalancerName &#91;required&#93; The name of the load balancer.
#' @param HealthCheck &#91;required&#93; The configuration information.
#'
#' @section Request syntax:
#' ```
#' svc$configure_health_check(
#'   LoadBalancerName = "string",
#'   HealthCheck = list(
#'     Target = "string",
#'     Interval = 123,
#'     Timeout = 123,
#'     UnhealthyThreshold = 123,
#'     HealthyThreshold = 123
#'   )
#' )
#' ```
#'
#' @examples
#' # This example specifies the health check settings used to evaluate the
#' # health of your backend EC2 instances.
#' \donttest{svc$configure_health_check(
#'   HealthCheck = list(
#'     HealthyThreshold = 2L,
#'     Interval = 30L,
#'     Target = "HTTP:80/png",
#'     Timeout = 3L,
#'     UnhealthyThreshold = 2L
#'   ),
#'   LoadBalancerName = "my-load-balancer"
#' )}
#'
#' @keywords internal
#'
#' @rdname elb_configure_health_check
elb_configure_health_check <- function(LoadBalancerName, HealthCheck) {
  op <- new_operation(
    name = "ConfigureHealthCheck",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elb$configure_health_check_input(LoadBalancerName = LoadBalancerName, HealthCheck = HealthCheck)
  output <- .elb$configure_health_check_output()
  svc <- .elb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$configure_health_check <- elb_configure_health_check

#' Generates a stickiness policy with sticky session lifetimes that follow
#' that of an application-generated cookie
#'
#' Generates a stickiness policy with sticky session lifetimes that follow
#' that of an application-generated cookie. This policy can be associated
#' only with HTTP/HTTPS listeners.
#' 
#' This policy is similar to the policy created by
#' CreateLBCookieStickinessPolicy, except that the lifetime of the special
#' Elastic Load Balancing cookie, `AWSELB`, follows the lifetime of the
#' application-generated cookie specified in the policy configuration. The
#' load balancer only inserts a new stickiness cookie when the application
#' response includes a new application cookie.
#' 
#' If the application cookie is explicitly removed or expires, the session
#' stops being sticky until a new application cookie is issued.
#' 
#' For more information, see [Application-Controlled Session
#' Stickiness](http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-sticky-sessions.html#enable-sticky-sessions-application)
#' in the *Classic Load Balancers Guide*.
#'
#' @usage
#' elb_create_app_cookie_stickiness_policy(LoadBalancerName, PolicyName,
#'   CookieName)
#'
#' @param LoadBalancerName &#91;required&#93; The name of the load balancer.
#' @param PolicyName &#91;required&#93; The name of the policy being created. Policy names must consist of
#' alphanumeric characters and dashes (-). This name must be unique within
#' the set of policies for this load balancer.
#' @param CookieName &#91;required&#93; The name of the application cookie used for stickiness.
#'
#' @section Request syntax:
#' ```
#' svc$create_app_cookie_stickiness_policy(
#'   LoadBalancerName = "string",
#'   PolicyName = "string",
#'   CookieName = "string"
#' )
#' ```
#'
#' @examples
#' # This example generates a stickiness policy that follows the sticky
#' # session lifetimes of the application-generated cookie.
#' \donttest{svc$create_app_cookie_stickiness_policy(
#'   CookieName = "my-app-cookie",
#'   LoadBalancerName = "my-load-balancer",
#'   PolicyName = "my-app-cookie-policy"
#' )}
#'
#' @keywords internal
#'
#' @rdname elb_create_app_cookie_stickiness_policy
elb_create_app_cookie_stickiness_policy <- function(LoadBalancerName, PolicyName, CookieName) {
  op <- new_operation(
    name = "CreateAppCookieStickinessPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elb$create_app_cookie_stickiness_policy_input(LoadBalancerName = LoadBalancerName, PolicyName = PolicyName, CookieName = CookieName)
  output <- .elb$create_app_cookie_stickiness_policy_output()
  svc <- .elb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$create_app_cookie_stickiness_policy <- elb_create_app_cookie_stickiness_policy

#' Generates a stickiness policy with sticky session lifetimes controlled
#' by the lifetime of the browser (user-agent) or a specified expiration
#' period
#'
#' Generates a stickiness policy with sticky session lifetimes controlled
#' by the lifetime of the browser (user-agent) or a specified expiration
#' period. This policy can be associated only with HTTP/HTTPS listeners.
#' 
#' When a load balancer implements this policy, the load balancer uses a
#' special cookie to track the instance for each request. When the load
#' balancer receives a request, it first checks to see if this cookie is
#' present in the request. If so, the load balancer sends the request to
#' the application server specified in the cookie. If not, the load
#' balancer sends the request to a server that is chosen based on the
#' existing load-balancing algorithm.
#' 
#' A cookie is inserted into the response for binding subsequent requests
#' from the same user to that server. The validity of the cookie is based
#' on the cookie expiration time, which is specified in the policy
#' configuration.
#' 
#' For more information, see [Duration-Based Session
#' Stickiness](http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-sticky-sessions.html#enable-sticky-sessions-duration)
#' in the *Classic Load Balancers Guide*.
#'
#' @usage
#' elb_create_lb_cookie_stickiness_policy(LoadBalancerName, PolicyName,
#'   CookieExpirationPeriod)
#'
#' @param LoadBalancerName &#91;required&#93; The name of the load balancer.
#' @param PolicyName &#91;required&#93; The name of the policy being created. Policy names must consist of
#' alphanumeric characters and dashes (-). This name must be unique within
#' the set of policies for this load balancer.
#' @param CookieExpirationPeriod The time period, in seconds, after which the cookie should be considered
#' stale. If you do not specify this parameter, the default value is 0,
#' which indicates that the sticky session should last for the duration of
#' the browser session.
#'
#' @section Request syntax:
#' ```
#' svc$create_lb_cookie_stickiness_policy(
#'   LoadBalancerName = "string",
#'   PolicyName = "string",
#'   CookieExpirationPeriod = 123
#' )
#' ```
#'
#' @examples
#' # This example generates a stickiness policy with sticky session lifetimes
#' # controlled by the specified expiration period.
#' \donttest{svc$create_lb_cookie_stickiness_policy(
#'   CookieExpirationPeriod = 60L,
#'   LoadBalancerName = "my-load-balancer",
#'   PolicyName = "my-duration-cookie-policy"
#' )}
#'
#' @keywords internal
#'
#' @rdname elb_create_lb_cookie_stickiness_policy
elb_create_lb_cookie_stickiness_policy <- function(LoadBalancerName, PolicyName, CookieExpirationPeriod = NULL) {
  op <- new_operation(
    name = "CreateLBCookieStickinessPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elb$create_lb_cookie_stickiness_policy_input(LoadBalancerName = LoadBalancerName, PolicyName = PolicyName, CookieExpirationPeriod = CookieExpirationPeriod)
  output <- .elb$create_lb_cookie_stickiness_policy_output()
  svc <- .elb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$create_lb_cookie_stickiness_policy <- elb_create_lb_cookie_stickiness_policy

#' Creates a Classic Load Balancer
#'
#' Creates a Classic Load Balancer.
#' 
#' You can add listeners, security groups, subnets, and tags when you
#' create your load balancer, or you can add them later using
#' CreateLoadBalancerListeners, ApplySecurityGroupsToLoadBalancer,
#' AttachLoadBalancerToSubnets, and AddTags.
#' 
#' To describe your current load balancers, see DescribeLoadBalancers. When
#' you are finished with a load balancer, you can delete it using
#' DeleteLoadBalancer.
#' 
#' You can create up to 20 load balancers per region per account. You can
#' request an increase for the number of load balancers for your account.
#' For more information, see [Limits for Your Classic Load
#' Balancer](http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-limits.html)
#' in the *Classic Load Balancers Guide*.
#'
#' @usage
#' elb_create_load_balancer(LoadBalancerName, Listeners, AvailabilityZones,
#'   Subnets, SecurityGroups, Scheme, Tags)
#'
#' @param LoadBalancerName &#91;required&#93; The name of the load balancer.
#' 
#' This name must be unique within your set of load balancers for the
#' region, must have a maximum of 32 characters, must contain only
#' alphanumeric characters or hyphens, and cannot begin or end with a
#' hyphen.
#' @param Listeners &#91;required&#93; The listeners.
#' 
#' For more information, see [Listeners for Your Classic Load
#' Balancer](http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-listener-config.html)
#' in the *Classic Load Balancers Guide*.
#' @param AvailabilityZones One or more Availability Zones from the same region as the load
#' balancer.
#' 
#' You must specify at least one Availability Zone.
#' 
#' You can add more Availability Zones after you create the load balancer
#' using EnableAvailabilityZonesForLoadBalancer.
#' @param Subnets The IDs of the subnets in your VPC to attach to the load balancer.
#' Specify one subnet per Availability Zone specified in
#' `AvailabilityZones`.
#' @param SecurityGroups The IDs of the security groups to assign to the load balancer.
#' @param Scheme The type of a load balancer. Valid only for load balancers in a VPC.
#' 
#' By default, Elastic Load Balancing creates an Internet-facing load
#' balancer with a DNS name that resolves to public IP addresses. For more
#' information about Internet-facing and Internal load balancers, see [Load
#' Balancer
#' Scheme](http://docs.aws.amazon.com/elasticloadbalancing/latest/userguide/how-elastic-load-balancing-works.html#load-balancer-scheme)
#' in the *Elastic Load Balancing User Guide*.
#' 
#' Specify `internal` to create a load balancer with a DNS name that
#' resolves to private IP addresses.
#' @param Tags A list of tags to assign to the load balancer.
#' 
#' For more information about tagging your load balancer, see [Tag Your
#' Classic Load
#' Balancer](http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/add-remove-tags.html)
#' in the *Classic Load Balancers Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$create_load_balancer(
#'   LoadBalancerName = "string",
#'   Listeners = list(
#'     list(
#'       Protocol = "string",
#'       LoadBalancerPort = 123,
#'       InstanceProtocol = "string",
#'       InstancePort = 123,
#'       SSLCertificateId = "string"
#'     )
#'   ),
#'   AvailabilityZones = list(
#'     "string"
#'   ),
#'   Subnets = list(
#'     "string"
#'   ),
#'   SecurityGroups = list(
#'     "string"
#'   ),
#'   Scheme = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' # This example creates a load balancer with an HTTP listener in a VPC.
#' \donttest{svc$create_load_balancer(
#'   Listeners = list(
#'     list(
#'       InstancePort = 80L,
#'       InstanceProtocol = "HTTP",
#'       LoadBalancerPort = 80L,
#'       Protocol = "HTTP"
#'     )
#'   ),
#'   LoadBalancerName = "my-load-balancer",
#'   SecurityGroups = list(
#'     "sg-a61988c3"
#'   ),
#'   Subnets = list(
#'     "subnet-15aaab61"
#'   )
#' )}
#' 
#' # This example creates a load balancer with an HTTP listener in
#' # EC2-Classic.
#' \donttest{svc$create_load_balancer(
#'   AvailabilityZones = list(
#'     "us-west-2a"
#'   ),
#'   Listeners = list(
#'     list(
#'       InstancePort = 80L,
#'       InstanceProtocol = "HTTP",
#'       LoadBalancerPort = 80L,
#'       Protocol = "HTTP"
#'     )
#'   ),
#'   LoadBalancerName = "my-load-balancer"
#' )}
#' 
#' # This example creates a load balancer with an HTTPS listener in a VPC.
#' \donttest{svc$create_load_balancer(
#'   Listeners = list(
#'     list(
#'       InstancePort = 80L,
#'       InstanceProtocol = "HTTP",
#'       LoadBalancerPort = 80L,
#'       Protocol = "HTTP"
#'     ),
#'     list(
#'       InstancePort = 80L,
#'       InstanceProtocol = "HTTP",
#'       LoadBalancerPort = 443L,
#'       Protocol = "HTTPS",
#'       SSLCertificateId = "arn:aws:iam::123456789012:server-certificate/my-server-cert"
#'     )
#'   ),
#'   LoadBalancerName = "my-load-balancer",
#'   SecurityGroups = list(
#'     "sg-a61988c3"
#'   ),
#'   Subnets = list(
#'     "subnet-15aaab61"
#'   )
#' )}
#' 
#' # This example creates a load balancer with an HTTPS listener in
#' # EC2-Classic.
#' \donttest{svc$create_load_balancer(
#'   AvailabilityZones = list(
#'     "us-west-2a"
#'   ),
#'   Listeners = list(
#'     list(
#'       InstancePort = 80L,
#'       InstanceProtocol = "HTTP",
#'       LoadBalancerPort = 80L,
#'       Protocol = "HTTP"
#'     ),
#'     list(
#'       InstancePort = 80L,
#'       InstanceProtocol = "HTTP",
#'       LoadBalancerPort = 443L,
#'       Protocol = "HTTPS",
#'       SSLCertificateId = "arn:aws:iam::123456789012:server-certificate/my-server-cert"
#'     )
#'   ),
#'   LoadBalancerName = "my-load-balancer"
#' )}
#' 
#' # This example creates an internal load balancer with an HTTP listener in
#' # a VPC.
#' \donttest{svc$create_load_balancer(
#'   Listeners = list(
#'     list(
#'       InstancePort = 80L,
#'       InstanceProtocol = "HTTP",
#'       LoadBalancerPort = 80L,
#'       Protocol = "HTTP"
#'     )
#'   ),
#'   LoadBalancerName = "my-load-balancer",
#'   Scheme = "internal",
#'   SecurityGroups = list(
#'     "sg-a61988c3"
#'   ),
#'   Subnets = list(
#'     "subnet-15aaab61"
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname elb_create_load_balancer
elb_create_load_balancer <- function(LoadBalancerName, Listeners, AvailabilityZones = NULL, Subnets = NULL, SecurityGroups = NULL, Scheme = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateLoadBalancer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elb$create_load_balancer_input(LoadBalancerName = LoadBalancerName, Listeners = Listeners, AvailabilityZones = AvailabilityZones, Subnets = Subnets, SecurityGroups = SecurityGroups, Scheme = Scheme, Tags = Tags)
  output <- .elb$create_load_balancer_output()
  svc <- .elb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$create_load_balancer <- elb_create_load_balancer

#' Creates one or more listeners for the specified load balancer
#'
#' Creates one or more listeners for the specified load balancer. If a
#' listener with the specified port does not already exist, it is created;
#' otherwise, the properties of the new listener must match the properties
#' of the existing listener.
#' 
#' For more information, see [Listeners for Your Classic Load
#' Balancer](http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-listener-config.html)
#' in the *Classic Load Balancers Guide*.
#'
#' @usage
#' elb_create_load_balancer_listeners(LoadBalancerName, Listeners)
#'
#' @param LoadBalancerName &#91;required&#93; The name of the load balancer.
#' @param Listeners &#91;required&#93; The listeners.
#'
#' @section Request syntax:
#' ```
#' svc$create_load_balancer_listeners(
#'   LoadBalancerName = "string",
#'   Listeners = list(
#'     list(
#'       Protocol = "string",
#'       LoadBalancerPort = 123,
#'       InstanceProtocol = "string",
#'       InstancePort = 123,
#'       SSLCertificateId = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' # This example creates a listener for your load balancer at port 80 using
#' # the HTTP protocol.
#' \donttest{svc$create_load_balancer_listeners(
#'   Listeners = list(
#'     list(
#'       InstancePort = 80L,
#'       InstanceProtocol = "HTTP",
#'       LoadBalancerPort = 80L,
#'       Protocol = "HTTP"
#'     )
#'   ),
#'   LoadBalancerName = "my-load-balancer"
#' )}
#' 
#' # This example creates a listener for your load balancer at port 443 using
#' # the HTTPS protocol.
#' \donttest{svc$create_load_balancer_listeners(
#'   Listeners = list(
#'     list(
#'       InstancePort = 80L,
#'       InstanceProtocol = "HTTP",
#'       LoadBalancerPort = 443L,
#'       Protocol = "HTTPS",
#'       SSLCertificateId = "arn:aws:iam::123456789012:server-certificate/my-server-cert"
#'     )
#'   ),
#'   LoadBalancerName = "my-load-balancer"
#' )}
#'
#' @keywords internal
#'
#' @rdname elb_create_load_balancer_listeners
elb_create_load_balancer_listeners <- function(LoadBalancerName, Listeners) {
  op <- new_operation(
    name = "CreateLoadBalancerListeners",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elb$create_load_balancer_listeners_input(LoadBalancerName = LoadBalancerName, Listeners = Listeners)
  output <- .elb$create_load_balancer_listeners_output()
  svc <- .elb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$create_load_balancer_listeners <- elb_create_load_balancer_listeners

#' Creates a policy with the specified attributes for the specified load
#' balancer
#'
#' Creates a policy with the specified attributes for the specified load
#' balancer.
#' 
#' Policies are settings that are saved for your load balancer and that can
#' be applied to the listener or the application server, depending on the
#' policy type.
#'
#' @usage
#' elb_create_load_balancer_policy(LoadBalancerName, PolicyName,
#'   PolicyTypeName, PolicyAttributes)
#'
#' @param LoadBalancerName &#91;required&#93; The name of the load balancer.
#' @param PolicyName &#91;required&#93; The name of the load balancer policy to be created. This name must be
#' unique within the set of policies for this load balancer.
#' @param PolicyTypeName &#91;required&#93; The name of the base policy type. To get the list of policy types, use
#' DescribeLoadBalancerPolicyTypes.
#' @param PolicyAttributes The policy attributes.
#'
#' @section Request syntax:
#' ```
#' svc$create_load_balancer_policy(
#'   LoadBalancerName = "string",
#'   PolicyName = "string",
#'   PolicyTypeName = "string",
#'   PolicyAttributes = list(
#'     list(
#'       AttributeName = "string",
#'       AttributeValue = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' # This example creates a policy that enables Proxy Protocol on the
#' # specified load balancer.
#' \donttest{svc$create_load_balancer_policy(
#'   LoadBalancerName = "my-load-balancer",
#'   PolicyAttributes = list(
#'     list(
#'       AttributeName = "ProxyProtocol",
#'       AttributeValue = "true"
#'     )
#'   ),
#'   PolicyName = "my-ProxyProtocol-policy",
#'   PolicyTypeName = "ProxyProtocolPolicyType"
#' )}
#' 
#' # This example creates a public key policy.
#' \donttest{svc$create_load_balancer_policy(
#'   LoadBalancerName = "my-load-balancer",
#'   PolicyAttributes = list(
#'     list(
#'       AttributeName = "PublicKey",
#'       AttributeValue = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwAYUjnfyEyXr1pxjhFWBpMlg..."
#'     )
#'   ),
#'   PolicyName = "my-PublicKey-policy",
#'   PolicyTypeName = "PublicKeyPolicyType"
#' )}
#' 
#' # This example creates a backend server authentication policy that enables
#' # authentication on your backend instance using a public key policy.
#' \donttest{svc$create_load_balancer_policy(
#'   LoadBalancerName = "my-load-balancer",
#'   PolicyAttributes = list(
#'     list(
#'       AttributeName = "PublicKeyPolicyName",
#'       AttributeValue = "my-PublicKey-policy"
#'     )
#'   ),
#'   PolicyName = "my-authentication-policy",
#'   PolicyTypeName = "BackendServerAuthenticationPolicyType"
#' )}
#'
#' @keywords internal
#'
#' @rdname elb_create_load_balancer_policy
elb_create_load_balancer_policy <- function(LoadBalancerName, PolicyName, PolicyTypeName, PolicyAttributes = NULL) {
  op <- new_operation(
    name = "CreateLoadBalancerPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elb$create_load_balancer_policy_input(LoadBalancerName = LoadBalancerName, PolicyName = PolicyName, PolicyTypeName = PolicyTypeName, PolicyAttributes = PolicyAttributes)
  output <- .elb$create_load_balancer_policy_output()
  svc <- .elb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$create_load_balancer_policy <- elb_create_load_balancer_policy

#' Deletes the specified load balancer
#'
#' Deletes the specified load balancer.
#' 
#' If you are attempting to recreate a load balancer, you must reconfigure
#' all settings. The DNS name associated with a deleted load balancer are
#' no longer usable. The name and associated DNS record of the deleted load
#' balancer no longer exist and traffic sent to any of its IP addresses is
#' no longer delivered to your instances.
#' 
#' If the load balancer does not exist or has already been deleted, the
#' call to `DeleteLoadBalancer` still succeeds.
#'
#' @usage
#' elb_delete_load_balancer(LoadBalancerName)
#'
#' @param LoadBalancerName &#91;required&#93; The name of the load balancer.
#'
#' @section Request syntax:
#' ```
#' svc$delete_load_balancer(
#'   LoadBalancerName = "string"
#' )
#' ```
#'
#' @examples
#' # This example deletes the specified load balancer.
#' \donttest{svc$delete_load_balancer(
#'   LoadBalancerName = "my-load-balancer"
#' )}
#'
#' @keywords internal
#'
#' @rdname elb_delete_load_balancer
elb_delete_load_balancer <- function(LoadBalancerName) {
  op <- new_operation(
    name = "DeleteLoadBalancer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elb$delete_load_balancer_input(LoadBalancerName = LoadBalancerName)
  output <- .elb$delete_load_balancer_output()
  svc <- .elb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$delete_load_balancer <- elb_delete_load_balancer

#' Deletes the specified listeners from the specified load balancer
#'
#' Deletes the specified listeners from the specified load balancer.
#'
#' @usage
#' elb_delete_load_balancer_listeners(LoadBalancerName, LoadBalancerPorts)
#'
#' @param LoadBalancerName &#91;required&#93; The name of the load balancer.
#' @param LoadBalancerPorts &#91;required&#93; The client port numbers of the listeners.
#'
#' @section Request syntax:
#' ```
#' svc$delete_load_balancer_listeners(
#'   LoadBalancerName = "string",
#'   LoadBalancerPorts = list(
#'     123
#'   )
#' )
#' ```
#'
#' @examples
#' # This example deletes the listener for the specified port from the
#' # specified load balancer.
#' \donttest{svc$delete_load_balancer_listeners(
#'   LoadBalancerName = "my-load-balancer",
#'   LoadBalancerPorts = list(
#'     80L
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname elb_delete_load_balancer_listeners
elb_delete_load_balancer_listeners <- function(LoadBalancerName, LoadBalancerPorts) {
  op <- new_operation(
    name = "DeleteLoadBalancerListeners",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elb$delete_load_balancer_listeners_input(LoadBalancerName = LoadBalancerName, LoadBalancerPorts = LoadBalancerPorts)
  output <- .elb$delete_load_balancer_listeners_output()
  svc <- .elb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$delete_load_balancer_listeners <- elb_delete_load_balancer_listeners

#' Deletes the specified policy from the specified load balancer
#'
#' Deletes the specified policy from the specified load balancer. This
#' policy must not be enabled for any listeners.
#'
#' @usage
#' elb_delete_load_balancer_policy(LoadBalancerName, PolicyName)
#'
#' @param LoadBalancerName &#91;required&#93; The name of the load balancer.
#' @param PolicyName &#91;required&#93; The name of the policy.
#'
#' @section Request syntax:
#' ```
#' svc$delete_load_balancer_policy(
#'   LoadBalancerName = "string",
#'   PolicyName = "string"
#' )
#' ```
#'
#' @examples
#' # This example deletes the specified policy from the specified load
#' # balancer. The policy must not be enabled on any listener.
#' \donttest{svc$delete_load_balancer_policy(
#'   LoadBalancerName = "my-load-balancer",
#'   PolicyName = "my-duration-cookie-policy"
#' )}
#'
#' @keywords internal
#'
#' @rdname elb_delete_load_balancer_policy
elb_delete_load_balancer_policy <- function(LoadBalancerName, PolicyName) {
  op <- new_operation(
    name = "DeleteLoadBalancerPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elb$delete_load_balancer_policy_input(LoadBalancerName = LoadBalancerName, PolicyName = PolicyName)
  output <- .elb$delete_load_balancer_policy_output()
  svc <- .elb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$delete_load_balancer_policy <- elb_delete_load_balancer_policy

#' Deregisters the specified instances from the specified load balancer
#'
#' Deregisters the specified instances from the specified load balancer.
#' After the instance is deregistered, it no longer receives traffic from
#' the load balancer.
#' 
#' You can use DescribeLoadBalancers to verify that the instance is
#' deregistered from the load balancer.
#' 
#' For more information, see [Register or De-Register EC2
#' Instances](http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-deregister-register-instances.html)
#' in the *Classic Load Balancers Guide*.
#'
#' @usage
#' elb_deregister_instances_from_load_balancer(LoadBalancerName, Instances)
#'
#' @param LoadBalancerName &#91;required&#93; The name of the load balancer.
#' @param Instances &#91;required&#93; The IDs of the instances.
#'
#' @section Request syntax:
#' ```
#' svc$deregister_instances_from_load_balancer(
#'   LoadBalancerName = "string",
#'   Instances = list(
#'     list(
#'       InstanceId = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' # This example deregisters the specified instance from the specified load
#' # balancer.
#' \donttest{svc$deregister_instances_from_load_balancer(
#'   Instances = list(
#'     list(
#'       InstanceId = "i-d6f6fae3"
#'     )
#'   ),
#'   LoadBalancerName = "my-load-balancer"
#' )}
#'
#' @keywords internal
#'
#' @rdname elb_deregister_instances_from_load_balancer
elb_deregister_instances_from_load_balancer <- function(LoadBalancerName, Instances) {
  op <- new_operation(
    name = "DeregisterInstancesFromLoadBalancer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elb$deregister_instances_from_load_balancer_input(LoadBalancerName = LoadBalancerName, Instances = Instances)
  output <- .elb$deregister_instances_from_load_balancer_output()
  svc <- .elb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$deregister_instances_from_load_balancer <- elb_deregister_instances_from_load_balancer

#' Describes the current Elastic Load Balancing resource limits for your
#' AWS account
#'
#' Describes the current Elastic Load Balancing resource limits for your
#' AWS account.
#' 
#' For more information, see [Limits for Your Classic Load
#' Balancer](http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-limits.html)
#' in the *Classic Load Balancers Guide*.
#'
#' @usage
#' elb_describe_account_limits(Marker, PageSize)
#'
#' @param Marker The marker for the next set of results. (You received this marker from a
#' previous call.)
#' @param PageSize The maximum number of results to return with this call.
#'
#' @section Request syntax:
#' ```
#' svc$describe_account_limits(
#'   Marker = "string",
#'   PageSize = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elb_describe_account_limits
elb_describe_account_limits <- function(Marker = NULL, PageSize = NULL) {
  op <- new_operation(
    name = "DescribeAccountLimits",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elb$describe_account_limits_input(Marker = Marker, PageSize = PageSize)
  output <- .elb$describe_account_limits_output()
  svc <- .elb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$describe_account_limits <- elb_describe_account_limits

#' Describes the state of the specified instances with respect to the
#' specified load balancer
#'
#' Describes the state of the specified instances with respect to the
#' specified load balancer. If no instances are specified, the call
#' describes the state of all instances that are currently registered with
#' the load balancer. If instances are specified, their state is returned
#' even if they are no longer registered with the load balancer. The state
#' of terminated instances is not returned.
#'
#' @usage
#' elb_describe_instance_health(LoadBalancerName, Instances)
#'
#' @param LoadBalancerName &#91;required&#93; The name of the load balancer.
#' @param Instances The IDs of the instances.
#'
#' @section Request syntax:
#' ```
#' svc$describe_instance_health(
#'   LoadBalancerName = "string",
#'   Instances = list(
#'     list(
#'       InstanceId = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' # This example describes the health of the instances for the specified
#' # load balancer.
#' \donttest{svc$describe_instance_health(
#'   LoadBalancerName = "my-load-balancer"
#' )}
#'
#' @keywords internal
#'
#' @rdname elb_describe_instance_health
elb_describe_instance_health <- function(LoadBalancerName, Instances = NULL) {
  op <- new_operation(
    name = "DescribeInstanceHealth",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elb$describe_instance_health_input(LoadBalancerName = LoadBalancerName, Instances = Instances)
  output <- .elb$describe_instance_health_output()
  svc <- .elb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$describe_instance_health <- elb_describe_instance_health

#' Describes the attributes for the specified load balancer
#'
#' Describes the attributes for the specified load balancer.
#'
#' @usage
#' elb_describe_load_balancer_attributes(LoadBalancerName)
#'
#' @param LoadBalancerName &#91;required&#93; The name of the load balancer.
#'
#' @section Request syntax:
#' ```
#' svc$describe_load_balancer_attributes(
#'   LoadBalancerName = "string"
#' )
#' ```
#'
#' @examples
#' # This example describes the attributes of the specified load balancer.
#' \donttest{svc$describe_load_balancer_attributes(
#'   LoadBalancerName = "my-load-balancer"
#' )}
#'
#' @keywords internal
#'
#' @rdname elb_describe_load_balancer_attributes
elb_describe_load_balancer_attributes <- function(LoadBalancerName) {
  op <- new_operation(
    name = "DescribeLoadBalancerAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elb$describe_load_balancer_attributes_input(LoadBalancerName = LoadBalancerName)
  output <- .elb$describe_load_balancer_attributes_output()
  svc <- .elb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$describe_load_balancer_attributes <- elb_describe_load_balancer_attributes

#' Describes the specified policies
#'
#' Describes the specified policies.
#' 
#' If you specify a load balancer name, the action returns the descriptions
#' of all policies created for the load balancer. If you specify a policy
#' name associated with your load balancer, the action returns the
#' description of that policy. If you don\'t specify a load balancer name,
#' the action returns descriptions of the specified sample policies, or
#' descriptions of all sample policies. The names of the sample policies
#' have the `ELBSample-` prefix.
#'
#' @usage
#' elb_describe_load_balancer_policies(LoadBalancerName, PolicyNames)
#'
#' @param LoadBalancerName The name of the load balancer.
#' @param PolicyNames The names of the policies.
#'
#' @section Request syntax:
#' ```
#' svc$describe_load_balancer_policies(
#'   LoadBalancerName = "string",
#'   PolicyNames = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # This example describes the specified policy associated with the
#' # specified load balancer.
#' \donttest{svc$describe_load_balancer_policies(
#'   LoadBalancerName = "my-load-balancer",
#'   PolicyNames = list(
#'     "my-authentication-policy"
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname elb_describe_load_balancer_policies
elb_describe_load_balancer_policies <- function(LoadBalancerName = NULL, PolicyNames = NULL) {
  op <- new_operation(
    name = "DescribeLoadBalancerPolicies",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elb$describe_load_balancer_policies_input(LoadBalancerName = LoadBalancerName, PolicyNames = PolicyNames)
  output <- .elb$describe_load_balancer_policies_output()
  svc <- .elb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$describe_load_balancer_policies <- elb_describe_load_balancer_policies

#' Describes the specified load balancer policy types or all load balancer
#' policy types
#'
#' Describes the specified load balancer policy types or all load balancer
#' policy types.
#' 
#' The description of each type indicates how it can be used. For example,
#' some policies can be used only with layer 7 listeners, some policies can
#' be used only with layer 4 listeners, and some policies can be used only
#' with your EC2 instances.
#' 
#' You can use CreateLoadBalancerPolicy to create a policy configuration
#' for any of these policy types. Then, depending on the policy type, use
#' either SetLoadBalancerPoliciesOfListener or
#' SetLoadBalancerPoliciesForBackendServer to set the policy.
#'
#' @usage
#' elb_describe_load_balancer_policy_types(PolicyTypeNames)
#'
#' @param PolicyTypeNames The names of the policy types. If no names are specified, describes all
#' policy types defined by Elastic Load Balancing.
#'
#' @section Request syntax:
#' ```
#' svc$describe_load_balancer_policy_types(
#'   PolicyTypeNames = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # This example describes the specified load balancer policy type.
#' \donttest{svc$describe_load_balancer_policy_types(
#'   PolicyTypeNames = list(
#'     "ProxyProtocolPolicyType"
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname elb_describe_load_balancer_policy_types
elb_describe_load_balancer_policy_types <- function(PolicyTypeNames = NULL) {
  op <- new_operation(
    name = "DescribeLoadBalancerPolicyTypes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elb$describe_load_balancer_policy_types_input(PolicyTypeNames = PolicyTypeNames)
  output <- .elb$describe_load_balancer_policy_types_output()
  svc <- .elb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$describe_load_balancer_policy_types <- elb_describe_load_balancer_policy_types

#' Describes the specified the load balancers
#'
#' Describes the specified the load balancers. If no load balancers are
#' specified, the call describes all of your load balancers.
#'
#' @usage
#' elb_describe_load_balancers(LoadBalancerNames, Marker, PageSize)
#'
#' @param LoadBalancerNames The names of the load balancers.
#' @param Marker The marker for the next set of results. (You received this marker from a
#' previous call.)
#' @param PageSize The maximum number of results to return with this call (a number from 1
#' to 400). The default is 400.
#'
#' @section Request syntax:
#' ```
#' svc$describe_load_balancers(
#'   LoadBalancerNames = list(
#'     "string"
#'   ),
#'   Marker = "string",
#'   PageSize = 123
#' )
#' ```
#'
#' @examples
#' # This example describes the specified load balancer.
#' \donttest{svc$describe_load_balancers(
#'   LoadBalancerNames = list(
#'     "my-load-balancer"
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname elb_describe_load_balancers
elb_describe_load_balancers <- function(LoadBalancerNames = NULL, Marker = NULL, PageSize = NULL) {
  op <- new_operation(
    name = "DescribeLoadBalancers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elb$describe_load_balancers_input(LoadBalancerNames = LoadBalancerNames, Marker = Marker, PageSize = PageSize)
  output <- .elb$describe_load_balancers_output()
  svc <- .elb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$describe_load_balancers <- elb_describe_load_balancers

#' Describes the tags associated with the specified load balancers
#'
#' Describes the tags associated with the specified load balancers.
#'
#' @usage
#' elb_describe_tags(LoadBalancerNames)
#'
#' @param LoadBalancerNames &#91;required&#93; The names of the load balancers.
#'
#' @section Request syntax:
#' ```
#' svc$describe_tags(
#'   LoadBalancerNames = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # This example describes the tags for the specified load balancer.
#' \donttest{svc$describe_tags(
#'   LoadBalancerNames = list(
#'     "my-load-balancer"
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname elb_describe_tags
elb_describe_tags <- function(LoadBalancerNames) {
  op <- new_operation(
    name = "DescribeTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elb$describe_tags_input(LoadBalancerNames = LoadBalancerNames)
  output <- .elb$describe_tags_output()
  svc <- .elb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$describe_tags <- elb_describe_tags

#' Removes the specified subnets from the set of configured subnets for the
#' load balancer
#'
#' Removes the specified subnets from the set of configured subnets for the
#' load balancer.
#' 
#' After a subnet is removed, all EC2 instances registered with the load
#' balancer in the removed subnet go into the `OutOfService` state. Then,
#' the load balancer balances the traffic among the remaining routable
#' subnets.
#'
#' @usage
#' elb_detach_load_balancer_from_subnets(LoadBalancerName, Subnets)
#'
#' @param LoadBalancerName &#91;required&#93; The name of the load balancer.
#' @param Subnets &#91;required&#93; The IDs of the subnets.
#'
#' @section Request syntax:
#' ```
#' svc$detach_load_balancer_from_subnets(
#'   LoadBalancerName = "string",
#'   Subnets = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # This example detaches the specified load balancer from the specified
#' # subnet.
#' \donttest{svc$detach_load_balancer_from_subnets(
#'   LoadBalancerName = "my-load-balancer",
#'   Subnets = list(
#'     "subnet-0ecac448"
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname elb_detach_load_balancer_from_subnets
elb_detach_load_balancer_from_subnets <- function(LoadBalancerName, Subnets) {
  op <- new_operation(
    name = "DetachLoadBalancerFromSubnets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elb$detach_load_balancer_from_subnets_input(LoadBalancerName = LoadBalancerName, Subnets = Subnets)
  output <- .elb$detach_load_balancer_from_subnets_output()
  svc <- .elb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$detach_load_balancer_from_subnets <- elb_detach_load_balancer_from_subnets

#' Removes the specified Availability Zones from the set of Availability
#' Zones for the specified load balancer in EC2-Classic or a default VPC
#'
#' Removes the specified Availability Zones from the set of Availability
#' Zones for the specified load balancer in EC2-Classic or a default VPC.
#' 
#' For load balancers in a non-default VPC, use
#' DetachLoadBalancerFromSubnets.
#' 
#' There must be at least one Availability Zone registered with a load
#' balancer at all times. After an Availability Zone is removed, all
#' instances registered with the load balancer that are in the removed
#' Availability Zone go into the `OutOfService` state. Then, the load
#' balancer attempts to equally balance the traffic among its remaining
#' Availability Zones.
#' 
#' For more information, see [Add or Remove Availability
#' Zones](http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-disable-az.html)
#' in the *Classic Load Balancers Guide*.
#'
#' @usage
#' elb_disable_availability_zones_for_load_balancer(LoadBalancerName,
#'   AvailabilityZones)
#'
#' @param LoadBalancerName &#91;required&#93; The name of the load balancer.
#' @param AvailabilityZones &#91;required&#93; The Availability Zones.
#'
#' @section Request syntax:
#' ```
#' svc$disable_availability_zones_for_load_balancer(
#'   LoadBalancerName = "string",
#'   AvailabilityZones = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # This example removes the specified Availability Zone from the set of
#' # Availability Zones for the specified load balancer.
#' \donttest{svc$disable_availability_zones_for_load_balancer(
#'   AvailabilityZones = list(
#'     "us-west-2a"
#'   ),
#'   LoadBalancerName = "my-load-balancer"
#' )}
#'
#' @keywords internal
#'
#' @rdname elb_disable_availability_zones_for_load_balancer
elb_disable_availability_zones_for_load_balancer <- function(LoadBalancerName, AvailabilityZones) {
  op <- new_operation(
    name = "DisableAvailabilityZonesForLoadBalancer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elb$disable_availability_zones_for_load_balancer_input(LoadBalancerName = LoadBalancerName, AvailabilityZones = AvailabilityZones)
  output <- .elb$disable_availability_zones_for_load_balancer_output()
  svc <- .elb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$disable_availability_zones_for_load_balancer <- elb_disable_availability_zones_for_load_balancer

#' Adds the specified Availability Zones to the set of Availability Zones
#' for the specified load balancer in EC2-Classic or a default VPC
#'
#' Adds the specified Availability Zones to the set of Availability Zones
#' for the specified load balancer in EC2-Classic or a default VPC.
#' 
#' For load balancers in a non-default VPC, use
#' AttachLoadBalancerToSubnets.
#' 
#' The load balancer evenly distributes requests across all its registered
#' Availability Zones that contain instances. For more information, see
#' [Add or Remove Availability
#' Zones](http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-disable-az.html)
#' in the *Classic Load Balancers Guide*.
#'
#' @usage
#' elb_enable_availability_zones_for_load_balancer(LoadBalancerName,
#'   AvailabilityZones)
#'
#' @param LoadBalancerName &#91;required&#93; The name of the load balancer.
#' @param AvailabilityZones &#91;required&#93; The Availability Zones. These must be in the same region as the load
#' balancer.
#'
#' @section Request syntax:
#' ```
#' svc$enable_availability_zones_for_load_balancer(
#'   LoadBalancerName = "string",
#'   AvailabilityZones = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # This example adds the specified Availability Zone to the specified load
#' # balancer.
#' \donttest{svc$enable_availability_zones_for_load_balancer(
#'   AvailabilityZones = list(
#'     "us-west-2b"
#'   ),
#'   LoadBalancerName = "my-load-balancer"
#' )}
#'
#' @keywords internal
#'
#' @rdname elb_enable_availability_zones_for_load_balancer
elb_enable_availability_zones_for_load_balancer <- function(LoadBalancerName, AvailabilityZones) {
  op <- new_operation(
    name = "EnableAvailabilityZonesForLoadBalancer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elb$enable_availability_zones_for_load_balancer_input(LoadBalancerName = LoadBalancerName, AvailabilityZones = AvailabilityZones)
  output <- .elb$enable_availability_zones_for_load_balancer_output()
  svc <- .elb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$enable_availability_zones_for_load_balancer <- elb_enable_availability_zones_for_load_balancer

#' Modifies the attributes of the specified load balancer
#'
#' Modifies the attributes of the specified load balancer.
#' 
#' You can modify the load balancer attributes, such as `AccessLogs`,
#' `ConnectionDraining`, and `CrossZoneLoadBalancing` by either enabling or
#' disabling them. Or, you can modify the load balancer attribute
#' `ConnectionSettings` by specifying an idle connection timeout value for
#' your load balancer.
#' 
#' For more information, see the following in the *Classic Load Balancers
#' Guide*:
#' 
#' -   [Cross-Zone Load
#'     Balancing](http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-disable-crosszone-lb.html)
#' 
#' -   [Connection
#'     Draining](http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/config-conn-drain.html)
#' 
#' -   [Access
#'     Logs](http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/access-log-collection.html)
#' 
#' -   [Idle Connection
#'     Timeout](http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/config-idle-timeout.html)
#'
#' @usage
#' elb_modify_load_balancer_attributes(LoadBalancerName,
#'   LoadBalancerAttributes)
#'
#' @param LoadBalancerName &#91;required&#93; The name of the load balancer.
#' @param LoadBalancerAttributes &#91;required&#93; The attributes for the load balancer.
#'
#' @section Request syntax:
#' ```
#' svc$modify_load_balancer_attributes(
#'   LoadBalancerName = "string",
#'   LoadBalancerAttributes = list(
#'     CrossZoneLoadBalancing = list(
#'       Enabled = TRUE|FALSE
#'     ),
#'     AccessLog = list(
#'       Enabled = TRUE|FALSE,
#'       S3BucketName = "string",
#'       EmitInterval = 123,
#'       S3BucketPrefix = "string"
#'     ),
#'     ConnectionDraining = list(
#'       Enabled = TRUE|FALSE,
#'       Timeout = 123
#'     ),
#'     ConnectionSettings = list(
#'       IdleTimeout = 123
#'     ),
#'     AdditionalAttributes = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' # This example enables cross-zone load balancing for the specified load
#' # balancer.
#' \donttest{svc$modify_load_balancer_attributes(
#'   LoadBalancerAttributes = list(
#'     CrossZoneLoadBalancing = list(
#'       Enabled = TRUE
#'     )
#'   ),
#'   LoadBalancerName = "my-load-balancer"
#' )}
#' 
#' # This example enables connection draining for the specified load
#' # balancer.
#' \donttest{svc$modify_load_balancer_attributes(
#'   LoadBalancerAttributes = list(
#'     ConnectionDraining = list(
#'       Enabled = TRUE,
#'       Timeout = 300L
#'     )
#'   ),
#'   LoadBalancerName = "my-load-balancer"
#' )}
#'
#' @keywords internal
#'
#' @rdname elb_modify_load_balancer_attributes
elb_modify_load_balancer_attributes <- function(LoadBalancerName, LoadBalancerAttributes) {
  op <- new_operation(
    name = "ModifyLoadBalancerAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elb$modify_load_balancer_attributes_input(LoadBalancerName = LoadBalancerName, LoadBalancerAttributes = LoadBalancerAttributes)
  output <- .elb$modify_load_balancer_attributes_output()
  svc <- .elb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$modify_load_balancer_attributes <- elb_modify_load_balancer_attributes

#' Adds the specified instances to the specified load balancer
#'
#' Adds the specified instances to the specified load balancer.
#' 
#' The instance must be a running instance in the same network as the load
#' balancer (EC2-Classic or the same VPC). If you have EC2-Classic
#' instances and a load balancer in a VPC with ClassicLink enabled, you can
#' link the EC2-Classic instances to that VPC and then register the linked
#' EC2-Classic instances with the load balancer in the VPC.
#' 
#' Note that `RegisterInstanceWithLoadBalancer` completes when the request
#' has been registered. Instance registration takes a little time to
#' complete. To check the state of the registered instances, use
#' DescribeLoadBalancers or DescribeInstanceHealth.
#' 
#' After the instance is registered, it starts receiving traffic and
#' requests from the load balancer. Any instance that is not in one of the
#' Availability Zones registered for the load balancer is moved to the
#' `OutOfService` state. If an Availability Zone is added to the load
#' balancer later, any instances registered with the load balancer move to
#' the `InService` state.
#' 
#' To deregister instances from a load balancer, use
#' DeregisterInstancesFromLoadBalancer.
#' 
#' For more information, see [Register or De-Register EC2
#' Instances](http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-deregister-register-instances.html)
#' in the *Classic Load Balancers Guide*.
#'
#' @usage
#' elb_register_instances_with_load_balancer(LoadBalancerName, Instances)
#'
#' @param LoadBalancerName &#91;required&#93; The name of the load balancer.
#' @param Instances &#91;required&#93; The IDs of the instances.
#'
#' @section Request syntax:
#' ```
#' svc$register_instances_with_load_balancer(
#'   LoadBalancerName = "string",
#'   Instances = list(
#'     list(
#'       InstanceId = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' # This example registers the specified instance with the specified load
#' # balancer.
#' \donttest{svc$register_instances_with_load_balancer(
#'   Instances = list(
#'     list(
#'       InstanceId = "i-d6f6fae3"
#'     )
#'   ),
#'   LoadBalancerName = "my-load-balancer"
#' )}
#'
#' @keywords internal
#'
#' @rdname elb_register_instances_with_load_balancer
elb_register_instances_with_load_balancer <- function(LoadBalancerName, Instances) {
  op <- new_operation(
    name = "RegisterInstancesWithLoadBalancer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elb$register_instances_with_load_balancer_input(LoadBalancerName = LoadBalancerName, Instances = Instances)
  output <- .elb$register_instances_with_load_balancer_output()
  svc <- .elb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$register_instances_with_load_balancer <- elb_register_instances_with_load_balancer

#' Removes one or more tags from the specified load balancer
#'
#' Removes one or more tags from the specified load balancer.
#'
#' @usage
#' elb_remove_tags(LoadBalancerNames, Tags)
#'
#' @param LoadBalancerNames &#91;required&#93; The name of the load balancer. You can specify a maximum of one load
#' balancer name.
#' @param Tags &#91;required&#93; The list of tag keys to remove.
#'
#' @section Request syntax:
#' ```
#' svc$remove_tags(
#'   LoadBalancerNames = list(
#'     "string"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' # This example removes the specified tag from the specified load balancer.
#' \donttest{svc$remove_tags(
#'   LoadBalancerNames = list(
#'     "my-load-balancer"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "project"
#'     )
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname elb_remove_tags
elb_remove_tags <- function(LoadBalancerNames, Tags) {
  op <- new_operation(
    name = "RemoveTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elb$remove_tags_input(LoadBalancerNames = LoadBalancerNames, Tags = Tags)
  output <- .elb$remove_tags_output()
  svc <- .elb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$remove_tags <- elb_remove_tags

#' Sets the certificate that terminates the specified listener's SSL
#' connections
#'
#' Sets the certificate that terminates the specified listener\'s SSL
#' connections. The specified certificate replaces any prior certificate
#' that was used on the same load balancer and port.
#' 
#' For more information about updating your SSL certificate, see [Replace
#' the SSL Certificate for Your Load
#' Balancer](http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-update-ssl-cert.html)
#' in the *Classic Load Balancers Guide*.
#'
#' @usage
#' elb_set_load_balancer_listener_ssl_certificate(LoadBalancerName,
#'   LoadBalancerPort, SSLCertificateId)
#'
#' @param LoadBalancerName &#91;required&#93; The name of the load balancer.
#' @param LoadBalancerPort &#91;required&#93; The port that uses the specified SSL certificate.
#' @param SSLCertificateId &#91;required&#93; The Amazon Resource Name (ARN) of the SSL certificate.
#'
#' @section Request syntax:
#' ```
#' svc$set_load_balancer_listener_ssl_certificate(
#'   LoadBalancerName = "string",
#'   LoadBalancerPort = 123,
#'   SSLCertificateId = "string"
#' )
#' ```
#'
#' @examples
#' # This example replaces the existing SSL certificate for the specified
#' # HTTPS listener.
#' \donttest{svc$set_load_balancer_listener_ssl_certificate(
#'   LoadBalancerName = "my-load-balancer",
#'   LoadBalancerPort = 443L,
#'   SSLCertificateId = "arn:aws:iam::123456789012:server-certificate/new-server-cert"
#' )}
#'
#' @keywords internal
#'
#' @rdname elb_set_load_balancer_listener_ssl_certificate
elb_set_load_balancer_listener_ssl_certificate <- function(LoadBalancerName, LoadBalancerPort, SSLCertificateId) {
  op <- new_operation(
    name = "SetLoadBalancerListenerSSLCertificate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elb$set_load_balancer_listener_ssl_certificate_input(LoadBalancerName = LoadBalancerName, LoadBalancerPort = LoadBalancerPort, SSLCertificateId = SSLCertificateId)
  output <- .elb$set_load_balancer_listener_ssl_certificate_output()
  svc <- .elb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$set_load_balancer_listener_ssl_certificate <- elb_set_load_balancer_listener_ssl_certificate

#' Replaces the set of policies associated with the specified port on which
#' the EC2 instance is listening with a new set of policies
#'
#' Replaces the set of policies associated with the specified port on which
#' the EC2 instance is listening with a new set of policies. At this time,
#' only the back-end server authentication policy type can be applied to
#' the instance ports; this policy type is composed of multiple public key
#' policies.
#' 
#' Each time you use `SetLoadBalancerPoliciesForBackendServer` to enable
#' the policies, use the `PolicyNames` parameter to list the policies that
#' you want to enable.
#' 
#' You can use DescribeLoadBalancers or DescribeLoadBalancerPolicies to
#' verify that the policy is associated with the EC2 instance.
#' 
#' For more information about enabling back-end instance authentication,
#' see [Configure Back-end Instance
#' Authentication](http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-create-https-ssl-load-balancer.html#configure_backendauth_clt)
#' in the *Classic Load Balancers Guide*. For more information about Proxy
#' Protocol, see [Configure Proxy Protocol
#' Support](http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-proxy-protocol.html)
#' in the *Classic Load Balancers Guide*.
#'
#' @usage
#' elb_set_load_balancer_policies_for_backend_server(LoadBalancerName,
#'   InstancePort, PolicyNames)
#'
#' @param LoadBalancerName &#91;required&#93; The name of the load balancer.
#' @param InstancePort &#91;required&#93; The port number associated with the EC2 instance.
#' @param PolicyNames &#91;required&#93; The names of the policies. If the list is empty, then all current
#' polices are removed from the EC2 instance.
#'
#' @section Request syntax:
#' ```
#' svc$set_load_balancer_policies_for_backend_server(
#'   LoadBalancerName = "string",
#'   InstancePort = 123,
#'   PolicyNames = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # This example replaces the policies that are currently associated with
#' # the specified port.
#' \donttest{svc$set_load_balancer_policies_for_backend_server(
#'   InstancePort = 80L,
#'   LoadBalancerName = "my-load-balancer",
#'   PolicyNames = list(
#'     "my-ProxyProtocol-policy"
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname elb_set_load_balancer_policies_for_backend_server
elb_set_load_balancer_policies_for_backend_server <- function(LoadBalancerName, InstancePort, PolicyNames) {
  op <- new_operation(
    name = "SetLoadBalancerPoliciesForBackendServer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elb$set_load_balancer_policies_for_backend_server_input(LoadBalancerName = LoadBalancerName, InstancePort = InstancePort, PolicyNames = PolicyNames)
  output <- .elb$set_load_balancer_policies_for_backend_server_output()
  svc <- .elb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$set_load_balancer_policies_for_backend_server <- elb_set_load_balancer_policies_for_backend_server

#' Replaces the current set of policies for the specified load balancer
#' port with the specified set of policies
#'
#' Replaces the current set of policies for the specified load balancer
#' port with the specified set of policies.
#' 
#' To enable back-end server authentication, use
#' SetLoadBalancerPoliciesForBackendServer.
#' 
#' For more information about setting policies, see [Update the SSL
#' Negotiation
#' Configuration](http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/ssl-config-update.html),
#' [Duration-Based Session
#' Stickiness](http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-sticky-sessions.html#enable-sticky-sessions-duration),
#' and [Application-Controlled Session
#' Stickiness](http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-sticky-sessions.html#enable-sticky-sessions-application)
#' in the *Classic Load Balancers Guide*.
#'
#' @usage
#' elb_set_load_balancer_policies_of_listener(LoadBalancerName,
#'   LoadBalancerPort, PolicyNames)
#'
#' @param LoadBalancerName &#91;required&#93; The name of the load balancer.
#' @param LoadBalancerPort &#91;required&#93; The external port of the load balancer.
#' @param PolicyNames &#91;required&#93; The names of the policies. This list must include all policies to be
#' enabled. If you omit a policy that is currently enabled, it is disabled.
#' If the list is empty, all current policies are disabled.
#'
#' @section Request syntax:
#' ```
#' svc$set_load_balancer_policies_of_listener(
#'   LoadBalancerName = "string",
#'   LoadBalancerPort = 123,
#'   PolicyNames = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # This example replaces the policies that are currently associated with
#' # the specified listener.
#' \donttest{svc$set_load_balancer_policies_of_listener(
#'   LoadBalancerName = "my-load-balancer",
#'   LoadBalancerPort = 80L,
#'   PolicyNames = list(
#'     "my-SSLNegotiation-policy"
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname elb_set_load_balancer_policies_of_listener
elb_set_load_balancer_policies_of_listener <- function(LoadBalancerName, LoadBalancerPort, PolicyNames) {
  op <- new_operation(
    name = "SetLoadBalancerPoliciesOfListener",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elb$set_load_balancer_policies_of_listener_input(LoadBalancerName = LoadBalancerName, LoadBalancerPort = LoadBalancerPort, PolicyNames = PolicyNames)
  output <- .elb$set_load_balancer_policies_of_listener_output()
  svc <- .elb$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elb$operations$set_load_balancer_policies_of_listener <- elb_set_load_balancer_policies_of_listener
