% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudfront_operations.R
\name{cloudfront_create_distribution_with_tags}
\alias{cloudfront_create_distribution_with_tags}
\title{Create a new distribution with tags}
\usage{
cloudfront_create_distribution_with_tags(DistributionConfigWithTags)
}
\arguments{
\item{DistributionConfigWithTags}{[required] The distribution's configuration information.}
}
\description{
Create a new distribution with tags.
}
\section{Request syntax}{
\preformatted{svc$create_distribution_with_tags(
  DistributionConfigWithTags = list(
    DistributionConfig = list(
      CallerReference = "string",
      Aliases = list(
        Quantity = 123,
        Items = list(
          "string"
        )
      ),
      DefaultRootObject = "string",
      Origins = list(
        Quantity = 123,
        Items = list(
          list(
            Id = "string",
            DomainName = "string",
            OriginPath = "string",
            CustomHeaders = list(
              Quantity = 123,
              Items = list(
                list(
                  HeaderName = "string",
                  HeaderValue = "string"
                )
              )
            ),
            S3OriginConfig = list(
              OriginAccessIdentity = "string"
            ),
            CustomOriginConfig = list(
              HTTPPort = 123,
              HTTPSPort = 123,
              OriginProtocolPolicy = "http-only"|"match-viewer"|"https-only",
              OriginSslProtocols = list(
                Quantity = 123,
                Items = list(
                  "SSLv3"|"TLSv1"|"TLSv1.1"|"TLSv1.2"
                )
              ),
              OriginReadTimeout = 123,
              OriginKeepaliveTimeout = 123
            )
          )
        )
      ),
      OriginGroups = list(
        Quantity = 123,
        Items = list(
          list(
            Id = "string",
            FailoverCriteria = list(
              StatusCodes = list(
                Quantity = 123,
                Items = list(
                  123
                )
              )
            ),
            Members = list(
              Quantity = 123,
              Items = list(
                list(
                  OriginId = "string"
                )
              )
            )
          )
        )
      ),
      DefaultCacheBehavior = list(
        TargetOriginId = "string",
        ForwardedValues = list(
          QueryString = TRUE|FALSE,
          Cookies = list(
            Forward = "none"|"whitelist"|"all",
            WhitelistedNames = list(
              Quantity = 123,
              Items = list(
                "string"
              )
            )
          ),
          Headers = list(
            Quantity = 123,
            Items = list(
              "string"
            )
          ),
          QueryStringCacheKeys = list(
            Quantity = 123,
            Items = list(
              "string"
            )
          )
        ),
        TrustedSigners = list(
          Enabled = TRUE|FALSE,
          Quantity = 123,
          Items = list(
            "string"
          )
        ),
        ViewerProtocolPolicy = "allow-all"|"https-only"|"redirect-to-https",
        MinTTL = 123,
        AllowedMethods = list(
          Quantity = 123,
          Items = list(
            "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
          ),
          CachedMethods = list(
            Quantity = 123,
            Items = list(
              "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
            )
          )
        ),
        SmoothStreaming = TRUE|FALSE,
        DefaultTTL = 123,
        MaxTTL = 123,
        Compress = TRUE|FALSE,
        LambdaFunctionAssociations = list(
          Quantity = 123,
          Items = list(
            list(
              LambdaFunctionARN = "string",
              EventType = "viewer-request"|"viewer-response"|"origin-request"|"origin-response",
              IncludeBody = TRUE|FALSE
            )
          )
        ),
        FieldLevelEncryptionId = "string"
      ),
      CacheBehaviors = list(
        Quantity = 123,
        Items = list(
          list(
            PathPattern = "string",
            TargetOriginId = "string",
            ForwardedValues = list(
              QueryString = TRUE|FALSE,
              Cookies = list(
                Forward = "none"|"whitelist"|"all",
                WhitelistedNames = list(
                  Quantity = 123,
                  Items = list(
                    "string"
                  )
                )
              ),
              Headers = list(
                Quantity = 123,
                Items = list(
                  "string"
                )
              ),
              QueryStringCacheKeys = list(
                Quantity = 123,
                Items = list(
                  "string"
                )
              )
            ),
            TrustedSigners = list(
              Enabled = TRUE|FALSE,
              Quantity = 123,
              Items = list(
                "string"
              )
            ),
            ViewerProtocolPolicy = "allow-all"|"https-only"|"redirect-to-https",
            MinTTL = 123,
            AllowedMethods = list(
              Quantity = 123,
              Items = list(
                "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
              ),
              CachedMethods = list(
                Quantity = 123,
                Items = list(
                  "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
                )
              )
            ),
            SmoothStreaming = TRUE|FALSE,
            DefaultTTL = 123,
            MaxTTL = 123,
            Compress = TRUE|FALSE,
            LambdaFunctionAssociations = list(
              Quantity = 123,
              Items = list(
                list(
                  LambdaFunctionARN = "string",
                  EventType = "viewer-request"|"viewer-response"|"origin-request"|"origin-response",
                  IncludeBody = TRUE|FALSE
                )
              )
            ),
            FieldLevelEncryptionId = "string"
          )
        )
      ),
      CustomErrorResponses = list(
        Quantity = 123,
        Items = list(
          list(
            ErrorCode = 123,
            ResponsePagePath = "string",
            ResponseCode = "string",
            ErrorCachingMinTTL = 123
          )
        )
      ),
      Comment = "string",
      Logging = list(
        Enabled = TRUE|FALSE,
        IncludeCookies = TRUE|FALSE,
        Bucket = "string",
        Prefix = "string"
      ),
      PriceClass = "PriceClass_100"|"PriceClass_200"|"PriceClass_All",
      Enabled = TRUE|FALSE,
      ViewerCertificate = list(
        CloudFrontDefaultCertificate = TRUE|FALSE,
        IAMCertificateId = "string",
        ACMCertificateArn = "string",
        SSLSupportMethod = "sni-only"|"vip",
        MinimumProtocolVersion = "SSLv3"|"TLSv1"|"TLSv1_2016"|"TLSv1.1_2016"|"TLSv1.2_2018",
        Certificate = "string",
        CertificateSource = "cloudfront"|"iam"|"acm"
      ),
      Restrictions = list(
        GeoRestriction = list(
          RestrictionType = "blacklist"|"whitelist"|"none",
          Quantity = 123,
          Items = list(
            "string"
          )
        )
      ),
      WebACLId = "string",
      HttpVersion = "http1.1"|"http2",
      IsIPV6Enabled = TRUE|FALSE
    ),
    Tags = list(
      Items = list(
        list(
          Key = "string",
          Value = "string"
        )
      )
    )
  )
)
}
}

\keyword{internal}
