% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appmesh_operations.R
\name{appmesh_update_route}
\alias{appmesh_update_route}
\title{Updates an existing route for a specified service mesh and virtual
router}
\usage{
appmesh_update_route(clientToken, meshName, routeName, spec,
  virtualRouterName)
}
\arguments{
\item{clientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. Up to 36 letters, numbers, hyphens, and
underscores are allowed.}

\item{meshName}{[required] The name of the service mesh that the route resides in.}

\item{routeName}{[required] The name of the route to update.}

\item{spec}{[required] The new route specification to apply. This overwrites the existing data.}

\item{virtualRouterName}{[required] The name of the virtual router that the route is associated with.}
}
\description{
Updates an existing route for a specified service mesh and virtual
router.
}
\section{Request syntax}{
\preformatted{svc$update_route(
  clientToken = "string",
  meshName = "string",
  routeName = "string",
  spec = list(
    httpRoute = list(
      action = list(
        weightedTargets = list(
          list(
            virtualNode = "string",
            weight = 123
          )
        )
      ),
      match = list(
        prefix = "string"
      )
    ),
    tcpRoute = list(
      action = list(
        weightedTargets = list(
          list(
            virtualNode = "string",
            weight = 123
          )
        )
      )
    )
  ),
  virtualRouterName = "string"
)
}
}

\keyword{internal}
