% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elb_operations.R
\name{elb_create_load_balancer_policy}
\alias{elb_create_load_balancer_policy}
\title{Creates a policy with the specified attributes for the specified load
balancer}
\usage{
elb_create_load_balancer_policy(LoadBalancerName, PolicyName,
  PolicyTypeName, PolicyAttributes)
}
\arguments{
\item{LoadBalancerName}{[required] The name of the load balancer.}

\item{PolicyName}{[required] The name of the load balancer policy to be created. This name must be
unique within the set of policies for this load balancer.}

\item{PolicyTypeName}{[required] The name of the base policy type. To get the list of policy types, use
DescribeLoadBalancerPolicyTypes.}

\item{PolicyAttributes}{The policy attributes.}
}
\description{
Creates a policy with the specified attributes for the specified load
balancer.
}
\details{
Policies are settings that are saved for your load balancer and that can
be applied to the listener or the application server, depending on the
policy type.
}
\section{Request syntax}{
\preformatted{svc$create_load_balancer_policy(
  LoadBalancerName = "string",
  PolicyName = "string",
  PolicyTypeName = "string",
  PolicyAttributes = list(
    list(
      AttributeName = "string",
      AttributeValue = "string"
    )
  )
)
}
}

\examples{
# This example creates a policy that enables Proxy Protocol on the
# specified load balancer.
\donttest{svc$create_load_balancer_policy(
  LoadBalancerName = "my-load-balancer",
  PolicyAttributes = list(
    list(
      AttributeName = "ProxyProtocol",
      AttributeValue = "true"
    )
  ),
  PolicyName = "my-ProxyProtocol-policy",
  PolicyTypeName = "ProxyProtocolPolicyType"
)}

# This example creates a public key policy.
\donttest{svc$create_load_balancer_policy(
  LoadBalancerName = "my-load-balancer",
  PolicyAttributes = list(
    list(
      AttributeName = "PublicKey",
      AttributeValue = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwAYUjnfyEyXr1pxjhFWBpMlg..."
    )
  ),
  PolicyName = "my-PublicKey-policy",
  PolicyTypeName = "PublicKeyPolicyType"
)}

# This example creates a backend server authentication policy that enables
# authentication on your backend instance using a public key policy.
\donttest{svc$create_load_balancer_policy(
  LoadBalancerName = "my-load-balancer",
  PolicyAttributes = list(
    list(
      AttributeName = "PublicKeyPolicyName",
      AttributeValue = "my-PublicKey-policy"
    )
  ),
  PolicyName = "my-authentication-policy",
  PolicyTypeName = "BackendServerAuthenticationPolicyType"
)}

}
\keyword{internal}
