% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53_operations.R
\name{route53_create_reusable_delegation_set}
\alias{route53_create_reusable_delegation_set}
\title{Creates a delegation set (a group of four name servers) that can be
reused by multiple hosted zones}
\usage{
route53_create_reusable_delegation_set(CallerReference, HostedZoneId)
}
\arguments{
\item{CallerReference}{[required] A unique string that identifies the request, and that allows you to
retry failed \code{CreateReusableDelegationSet} requests without the risk of
executing the operation twice. You must use a unique \code{CallerReference}
string every time you submit a \code{CreateReusableDelegationSet} request.
\code{CallerReference} can be any unique string, for example a date/time
stamp.}

\item{HostedZoneId}{If you want to mark the delegation set for an existing hosted zone as
reusable, the ID for that hosted zone.}
}
\description{
Creates a delegation set (a group of four name servers) that can be
reused by multiple hosted zones. If a hosted zoned ID is specified,
\code{CreateReusableDelegationSet} marks the delegation set associated with
that zone as reusable.
}
\details{
You can't associate a reusable delegation set with a private hosted
zone.

For information about using a reusable delegation set to configure white
label name servers, see \href{http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/white-label-name-servers.html}{Configuring White Label Name Servers}.

The process for migrating existing hosted zones to use a reusable
delegation set is comparable to the process for configuring white label
name servers. You need to perform the following steps:
\enumerate{
\item Create a reusable delegation set.
\item Recreate hosted zones, and reduce the TTL to 60 seconds or less.
\item Recreate resource record sets in the new hosted zones.
\item Change the registrar's name servers to use the name servers for the
new hosted zones.
\item Monitor traffic for the website or application.
\item Change TTLs back to their original values.
}

If you want to migrate existing hosted zones to use a reusable
delegation set, the existing hosted zones can't use any of the name
servers that are assigned to the reusable delegation set. If one or more
hosted zones do use one or more name servers that are assigned to the
reusable delegation set, you can do one of the following:
\itemize{
\item For small numbers of hosted zones---up to a few hundred---it's
relatively easy to create reusable delegation sets until you get one
that has four name servers that don't overlap with any of the name
servers in your hosted zones.
\item For larger numbers of hosted zones, the easiest solution is to use
more than one reusable delegation set.
\item For larger numbers of hosted zones, you can also migrate hosted
zones that have overlapping name servers to hosted zones that don't
have overlapping name servers, then migrate the hosted zones again
to use the reusable delegation set.
}
}
\section{Request syntax}{
\preformatted{svc$create_reusable_delegation_set(
  CallerReference = "string",
  HostedZoneId = "string"
)
}
}

\keyword{internal}
