% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appmesh_operations.R
\name{appmesh_list_tags_for_resource}
\alias{appmesh_list_tags_for_resource}
\title{List the tags for an App Mesh resource}
\usage{
appmesh_list_tags_for_resource(limit, nextToken, resourceArn)
}
\arguments{
\item{limit}{The maximum number of tag results returned by \code{ListTagsForResource} in
paginated output. When this parameter is used, \code{ListTagsForResource}
returns only \code{limit} results in a single page along with a \code{nextToken}
response element. You can see the remaining results of the initial
request by sending another \code{ListTagsForResource} request with the
returned \code{nextToken} value. This value can be between 1 and 100. If you
don\'t use this parameter, \code{ListTagsForResource} returns up to 100
results and a \code{nextToken} value if applicable.}

\item{nextToken}{The \code{nextToken} value returned from a previous paginated
\code{ListTagsForResource} request where \code{limit} was used and the results
exceeded the value of that parameter. Pagination continues from the end
of the previous results that returned the \code{nextToken} value.}

\item{resourceArn}{[required] The Amazon Resource Name (ARN) that identifies the resource to list the
tags for.}
}
\description{
List the tags for an App Mesh resource.
}
\section{Request syntax}{
\preformatted{svc$list_tags_for_resource(
  limit = 123,
  nextToken = "string",
  resourceArn = "string"
)
}
}

\keyword{internal}
