% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elb_operations.R
\name{elb_describe_load_balancer_policies}
\alias{elb_describe_load_balancer_policies}
\title{Describes the specified policies}
\usage{
elb_describe_load_balancer_policies(LoadBalancerName, PolicyNames)
}
\arguments{
\item{LoadBalancerName}{The name of the load balancer.}

\item{PolicyNames}{The names of the policies.}
}
\description{
Describes the specified policies.
}
\details{
If you specify a load balancer name, the action returns the descriptions
of all policies created for the load balancer. If you specify a policy
name associated with your load balancer, the action returns the
description of that policy. If you don\'t specify a load balancer name,
the action returns descriptions of the specified sample policies, or
descriptions of all sample policies. The names of the sample policies
have the \verb{ELBSample-} prefix.
}
\section{Request syntax}{
\preformatted{svc$describe_load_balancer_policies(
  LoadBalancerName = "string",
  PolicyNames = list(
    "string"
  )
)
}
}

\examples{
# This example describes the specified policy associated with the
# specified load balancer.
\dontrun{svc$describe_load_balancer_policies(
  LoadBalancerName = "my-load-balancer",
  PolicyNames = list(
    "my-authentication-policy"
  )
)}

}
\keyword{internal}
