% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53_operations.R
\name{route53_change_tags_for_resource}
\alias{route53_change_tags_for_resource}
\title{Adds, edits, or deletes tags for a health check or a hosted zone}
\usage{
route53_change_tags_for_resource(ResourceType, ResourceId, AddTags,
  RemoveTagKeys)
}
\arguments{
\item{ResourceType}{[required] The type of the resource.
\itemize{
\item The resource type for health checks is \code{healthcheck}.
\item The resource type for hosted zones is \code{hostedzone}.
}}

\item{ResourceId}{[required] The ID of the resource for which you want to add, change, or delete
tags.}

\item{AddTags}{A complex type that contains a list of the tags that you want to add to
the specified health check or hosted zone and/or the tags that you want
to edit \code{Value} for.

You can add a maximum of 10 tags to a health check or a hosted zone.}

\item{RemoveTagKeys}{A complex type that contains a list of the tags that you want to delete
from the specified health check or hosted zone. You can specify up to 10
keys.}
}
\description{
Adds, edits, or deletes tags for a health check or a hosted zone.
}
\details{
For information about using tags for cost allocation, see \href{https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html}{Using Cost Allocation Tags}
in the \emph{AWS Billing and Cost Management User Guide}.
}
\section{Request syntax}{
\preformatted{svc$change_tags_for_resource(
  ResourceType = "healthcheck"|"hostedzone",
  ResourceId = "string",
  AddTags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  RemoveTagKeys = list(
    "string"
  )
)
}
}

\examples{
# The following example adds two tags and removes one tag from the hosted
# zone with ID Z3M3LMPEXAMPLE.
\dontrun{svc$change_tags_for_resource(
  AddTags = list(
    list(
      Key = "apex",
      Value = "3874"
    ),
    list(
      Key = "acme",
      Value = "4938"
    )
  ),
  RemoveTagKeys = list(
    "Nadir"
  ),
  ResourceId = "Z3M3LMPEXAMPLE",
  ResourceType = "hostedzone"
)}

}
\keyword{internal}
