% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appmesh_operations.R
\name{appmesh_update_virtual_router}
\alias{appmesh_update_virtual_router}
\title{Updates an existing virtual router in a specified service mesh}
\usage{
appmesh_update_virtual_router(clientToken, meshName, meshOwner, spec,
  virtualRouterName)
}
\arguments{
\item{clientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. Up to 36 letters, numbers, hyphens, and
underscores are allowed.}

\item{meshName}{[required] The name of the service mesh that the virtual router resides in.}

\item{meshOwner}{The AWS IAM account ID of the service mesh owner. If the account ID is
not your own, then it\'s the ID of the account that shared the mesh with
your account. For more information about mesh sharing, see \href{https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html}{Working with shared meshes}.}

\item{spec}{[required] The new virtual router specification to apply. This overwrites the
existing data.}

\item{virtualRouterName}{[required] The name of the virtual router to update.}
}
\description{
Updates an existing virtual router in a specified service mesh.
}
\section{Request syntax}{
\preformatted{svc$update_virtual_router(
  clientToken = "string",
  meshName = "string",
  meshOwner = "string",
  spec = list(
    listeners = list(
      list(
        portMapping = list(
          port = 123,
          protocol = "grpc"|"http"|"http2"|"tcp"
        )
      )
    )
  ),
  virtualRouterName = "string"
)
}
}

\keyword{internal}
