% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53resolver_operations.R
\name{route53resolver_tag_resource}
\alias{route53resolver_tag_resource}
\title{Adds one or more tags to a specified resource}
\usage{
route53resolver_tag_resource(ResourceArn, Tags)
}
\arguments{
\item{ResourceArn}{[required] The Amazon Resource Name (ARN) for the resource that you want to add
tags to. To get the ARN for a resource, use the applicable \code{Get} or
\code{List} command:
\itemize{
\item GetResolverEndpoint
\item GetResolverRule
\item GetResolverRuleAssociation
\item ListResolverEndpoints
\item ListResolverRuleAssociations
\item ListResolverRules
}}

\item{Tags}{[required] The tags that you want to add to the specified resource.}
}
\description{
Adds one or more tags to a specified resource.
}
\section{Request syntax}{
\preformatted{svc$tag_resource(
  ResourceArn = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
