# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include networkmanager_service.R
NULL

#' Accepts a core network attachment request
#'
#' @description
#' Accepts a core network attachment request.
#'
#' See [https://paws-r.github.io/docs/networkmanager/accept_attachment.html](https://paws-r.github.io/docs/networkmanager/accept_attachment.html) for full documentation.
#'
#' @param AttachmentId &#91;required&#93; The ID of the attachment.
#'
#' @keywords internal
#'
#' @rdname networkmanager_accept_attachment
networkmanager_accept_attachment <- function(AttachmentId) {
  op <- new_operation(
    name = "AcceptAttachment",
    http_method = "POST",
    http_path = "/attachments/{attachmentId}/accept",
    paginator = list()
  )
  input <- .networkmanager$accept_attachment_input(AttachmentId = AttachmentId)
  output <- .networkmanager$accept_attachment_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$accept_attachment <- networkmanager_accept_attachment

#' Associates a core network Connect peer with a device and optionally,
#' with a link
#'
#' @description
#' Associates a core network Connect peer with a device and optionally, with a link.
#'
#' See [https://paws-r.github.io/docs/networkmanager/associate_connect_peer.html](https://paws-r.github.io/docs/networkmanager/associate_connect_peer.html) for full documentation.
#'
#' @param GlobalNetworkId &#91;required&#93; The ID of your global network.
#' @param ConnectPeerId &#91;required&#93; The ID of the Connect peer.
#' @param DeviceId &#91;required&#93; The ID of the device.
#' @param LinkId The ID of the link.
#'
#' @keywords internal
#'
#' @rdname networkmanager_associate_connect_peer
networkmanager_associate_connect_peer <- function(GlobalNetworkId, ConnectPeerId, DeviceId, LinkId = NULL) {
  op <- new_operation(
    name = "AssociateConnectPeer",
    http_method = "POST",
    http_path = "/global-networks/{globalNetworkId}/connect-peer-associations",
    paginator = list()
  )
  input <- .networkmanager$associate_connect_peer_input(GlobalNetworkId = GlobalNetworkId, ConnectPeerId = ConnectPeerId, DeviceId = DeviceId, LinkId = LinkId)
  output <- .networkmanager$associate_connect_peer_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$associate_connect_peer <- networkmanager_associate_connect_peer

#' Associates a customer gateway with a device and optionally, with a link
#'
#' @description
#' Associates a customer gateway with a device and optionally, with a link. If you specify a link, it must be associated with the specified device.
#'
#' See [https://paws-r.github.io/docs/networkmanager/associate_customer_gateway.html](https://paws-r.github.io/docs/networkmanager/associate_customer_gateway.html) for full documentation.
#'
#' @param CustomerGatewayArn &#91;required&#93; The Amazon Resource Name (ARN) of the customer gateway.
#' @param GlobalNetworkId &#91;required&#93; The ID of the global network.
#' @param DeviceId &#91;required&#93; The ID of the device.
#' @param LinkId The ID of the link.
#'
#' @keywords internal
#'
#' @rdname networkmanager_associate_customer_gateway
networkmanager_associate_customer_gateway <- function(CustomerGatewayArn, GlobalNetworkId, DeviceId, LinkId = NULL) {
  op <- new_operation(
    name = "AssociateCustomerGateway",
    http_method = "POST",
    http_path = "/global-networks/{globalNetworkId}/customer-gateway-associations",
    paginator = list()
  )
  input <- .networkmanager$associate_customer_gateway_input(CustomerGatewayArn = CustomerGatewayArn, GlobalNetworkId = GlobalNetworkId, DeviceId = DeviceId, LinkId = LinkId)
  output <- .networkmanager$associate_customer_gateway_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$associate_customer_gateway <- networkmanager_associate_customer_gateway

#' Associates a link to a device
#'
#' @description
#' Associates a link to a device. A device can be associated to multiple links and a link can be associated to multiple devices. The device and link must be in the same global network and the same site.
#'
#' See [https://paws-r.github.io/docs/networkmanager/associate_link.html](https://paws-r.github.io/docs/networkmanager/associate_link.html) for full documentation.
#'
#' @param GlobalNetworkId &#91;required&#93; The ID of the global network.
#' @param DeviceId &#91;required&#93; The ID of the device.
#' @param LinkId &#91;required&#93; The ID of the link.
#'
#' @keywords internal
#'
#' @rdname networkmanager_associate_link
networkmanager_associate_link <- function(GlobalNetworkId, DeviceId, LinkId) {
  op <- new_operation(
    name = "AssociateLink",
    http_method = "POST",
    http_path = "/global-networks/{globalNetworkId}/link-associations",
    paginator = list()
  )
  input <- .networkmanager$associate_link_input(GlobalNetworkId = GlobalNetworkId, DeviceId = DeviceId, LinkId = LinkId)
  output <- .networkmanager$associate_link_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$associate_link <- networkmanager_associate_link

#' Associates a transit gateway Connect peer with a device, and optionally,
#' with a link
#'
#' @description
#' Associates a transit gateway Connect peer with a device, and optionally, with a link. If you specify a link, it must be associated with the specified device.
#'
#' See [https://paws-r.github.io/docs/networkmanager/associate_transit_gateway_connect_peer.html](https://paws-r.github.io/docs/networkmanager/associate_transit_gateway_connect_peer.html) for full documentation.
#'
#' @param GlobalNetworkId &#91;required&#93; The ID of the global network.
#' @param TransitGatewayConnectPeerArn &#91;required&#93; The Amazon Resource Name (ARN) of the Connect peer.
#' @param DeviceId &#91;required&#93; The ID of the device.
#' @param LinkId The ID of the link.
#'
#' @keywords internal
#'
#' @rdname networkmanager_associate_transit_gateway_connect_peer
networkmanager_associate_transit_gateway_connect_peer <- function(GlobalNetworkId, TransitGatewayConnectPeerArn, DeviceId, LinkId = NULL) {
  op <- new_operation(
    name = "AssociateTransitGatewayConnectPeer",
    http_method = "POST",
    http_path = "/global-networks/{globalNetworkId}/transit-gateway-connect-peer-associations",
    paginator = list()
  )
  input <- .networkmanager$associate_transit_gateway_connect_peer_input(GlobalNetworkId = GlobalNetworkId, TransitGatewayConnectPeerArn = TransitGatewayConnectPeerArn, DeviceId = DeviceId, LinkId = LinkId)
  output <- .networkmanager$associate_transit_gateway_connect_peer_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$associate_transit_gateway_connect_peer <- networkmanager_associate_transit_gateway_connect_peer

#' Creates a core network Connect attachment from a specified core network
#' attachment
#'
#' @description
#' Creates a core network Connect attachment from a specified core network attachment.
#'
#' See [https://paws-r.github.io/docs/networkmanager/create_connect_attachment.html](https://paws-r.github.io/docs/networkmanager/create_connect_attachment.html) for full documentation.
#'
#' @param CoreNetworkId &#91;required&#93; The ID of a core network where you want to create the attachment.
#' @param EdgeLocation &#91;required&#93; The Region where the edge is located.
#' @param TransportAttachmentId &#91;required&#93; The ID of the attachment between the two connections.
#' @param Options &#91;required&#93; Options for creating an attachment.
#' @param Tags The list of key-value tags associated with the request.
#' @param ClientToken The client token associated with the request.
#'
#' @keywords internal
#'
#' @rdname networkmanager_create_connect_attachment
networkmanager_create_connect_attachment <- function(CoreNetworkId, EdgeLocation, TransportAttachmentId, Options, Tags = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "CreateConnectAttachment",
    http_method = "POST",
    http_path = "/connect-attachments",
    paginator = list()
  )
  input <- .networkmanager$create_connect_attachment_input(CoreNetworkId = CoreNetworkId, EdgeLocation = EdgeLocation, TransportAttachmentId = TransportAttachmentId, Options = Options, Tags = Tags, ClientToken = ClientToken)
  output <- .networkmanager$create_connect_attachment_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$create_connect_attachment <- networkmanager_create_connect_attachment

#' Creates a core network Connect peer for a specified core network connect
#' attachment between a core network and an appliance
#'
#' @description
#' Creates a core network Connect peer for a specified core network connect attachment between a core network and an appliance. The peer address and transit gateway address must be the same IP address family (IPv4 or IPv6).
#'
#' See [https://paws-r.github.io/docs/networkmanager/create_connect_peer.html](https://paws-r.github.io/docs/networkmanager/create_connect_peer.html) for full documentation.
#'
#' @param ConnectAttachmentId &#91;required&#93; The ID of the connection attachment.
#' @param CoreNetworkAddress A Connect peer core network address.
#' @param PeerAddress &#91;required&#93; The Connect peer address.
#' @param BgpOptions The Connect peer BGP options.
#' @param InsideCidrBlocks &#91;required&#93; The inside IP addresses used for BGP peering.
#' @param Tags The tags associated with the peer request.
#' @param ClientToken The client token associated with the request.
#'
#' @keywords internal
#'
#' @rdname networkmanager_create_connect_peer
networkmanager_create_connect_peer <- function(ConnectAttachmentId, CoreNetworkAddress = NULL, PeerAddress, BgpOptions = NULL, InsideCidrBlocks, Tags = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "CreateConnectPeer",
    http_method = "POST",
    http_path = "/connect-peers",
    paginator = list()
  )
  input <- .networkmanager$create_connect_peer_input(ConnectAttachmentId = ConnectAttachmentId, CoreNetworkAddress = CoreNetworkAddress, PeerAddress = PeerAddress, BgpOptions = BgpOptions, InsideCidrBlocks = InsideCidrBlocks, Tags = Tags, ClientToken = ClientToken)
  output <- .networkmanager$create_connect_peer_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$create_connect_peer <- networkmanager_create_connect_peer

#' Creates a connection between two devices
#'
#' @description
#' Creates a connection between two devices. The devices can be a physical or virtual appliance that connects to a third-party appliance in a VPC, or a physical appliance that connects to another physical appliance in an on-premises network.
#'
#' See [https://paws-r.github.io/docs/networkmanager/create_connection.html](https://paws-r.github.io/docs/networkmanager/create_connection.html) for full documentation.
#'
#' @param GlobalNetworkId &#91;required&#93; The ID of the global network.
#' @param DeviceId &#91;required&#93; The ID of the first device in the connection.
#' @param ConnectedDeviceId &#91;required&#93; The ID of the second device in the connection.
#' @param LinkId The ID of the link for the first device.
#' @param ConnectedLinkId The ID of the link for the second device.
#' @param Description A description of the connection.
#' 
#' Length Constraints: Maximum length of 256 characters.
#' @param Tags The tags to apply to the resource during creation.
#'
#' @keywords internal
#'
#' @rdname networkmanager_create_connection
networkmanager_create_connection <- function(GlobalNetworkId, DeviceId, ConnectedDeviceId, LinkId = NULL, ConnectedLinkId = NULL, Description = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateConnection",
    http_method = "POST",
    http_path = "/global-networks/{globalNetworkId}/connections",
    paginator = list()
  )
  input <- .networkmanager$create_connection_input(GlobalNetworkId = GlobalNetworkId, DeviceId = DeviceId, ConnectedDeviceId = ConnectedDeviceId, LinkId = LinkId, ConnectedLinkId = ConnectedLinkId, Description = Description, Tags = Tags)
  output <- .networkmanager$create_connection_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$create_connection <- networkmanager_create_connection

#' Creates a core network as part of your global network, and optionally,
#' with a core network policy
#'
#' @description
#' Creates a core network as part of your global network, and optionally, with a core network policy.
#'
#' See [https://paws-r.github.io/docs/networkmanager/create_core_network.html](https://paws-r.github.io/docs/networkmanager/create_core_network.html) for full documentation.
#'
#' @param GlobalNetworkId &#91;required&#93; The ID of the global network that a core network will be a part of.
#' @param Description The description of a core network.
#' @param Tags Key-value tags associated with a core network request.
#' @param PolicyDocument The policy document for creating a core network.
#' @param ClientToken The client token associated with a core network request.
#'
#' @keywords internal
#'
#' @rdname networkmanager_create_core_network
networkmanager_create_core_network <- function(GlobalNetworkId, Description = NULL, Tags = NULL, PolicyDocument = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "CreateCoreNetwork",
    http_method = "POST",
    http_path = "/core-networks",
    paginator = list()
  )
  input <- .networkmanager$create_core_network_input(GlobalNetworkId = GlobalNetworkId, Description = Description, Tags = Tags, PolicyDocument = PolicyDocument, ClientToken = ClientToken)
  output <- .networkmanager$create_core_network_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$create_core_network <- networkmanager_create_core_network

#' Creates a new device in a global network
#'
#' @description
#' Creates a new device in a global network. If you specify both a site ID and a location, the location of the site is used for visualization in the Network Manager console.
#'
#' See [https://paws-r.github.io/docs/networkmanager/create_device.html](https://paws-r.github.io/docs/networkmanager/create_device.html) for full documentation.
#'
#' @param GlobalNetworkId &#91;required&#93; The ID of the global network.
#' @param AWSLocation The Amazon Web Services location of the device, if applicable. For an
#' on-premises device, you can omit this parameter.
#' @param Description A description of the device.
#' 
#' Constraints: Maximum length of 256 characters.
#' @param Type The type of the device.
#' @param Vendor The vendor of the device.
#' 
#' Constraints: Maximum length of 128 characters.
#' @param Model The model of the device.
#' 
#' Constraints: Maximum length of 128 characters.
#' @param SerialNumber The serial number of the device.
#' 
#' Constraints: Maximum length of 128 characters.
#' @param Location The location of the device.
#' @param SiteId The ID of the site.
#' @param Tags The tags to apply to the resource during creation.
#'
#' @keywords internal
#'
#' @rdname networkmanager_create_device
networkmanager_create_device <- function(GlobalNetworkId, AWSLocation = NULL, Description = NULL, Type = NULL, Vendor = NULL, Model = NULL, SerialNumber = NULL, Location = NULL, SiteId = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateDevice",
    http_method = "POST",
    http_path = "/global-networks/{globalNetworkId}/devices",
    paginator = list()
  )
  input <- .networkmanager$create_device_input(GlobalNetworkId = GlobalNetworkId, AWSLocation = AWSLocation, Description = Description, Type = Type, Vendor = Vendor, Model = Model, SerialNumber = SerialNumber, Location = Location, SiteId = SiteId, Tags = Tags)
  output <- .networkmanager$create_device_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$create_device <- networkmanager_create_device

#' Creates a new, empty global network
#'
#' @description
#' Creates a new, empty global network.
#'
#' See [https://paws-r.github.io/docs/networkmanager/create_global_network.html](https://paws-r.github.io/docs/networkmanager/create_global_network.html) for full documentation.
#'
#' @param Description A description of the global network.
#' 
#' Constraints: Maximum length of 256 characters.
#' @param Tags The tags to apply to the resource during creation.
#'
#' @keywords internal
#'
#' @rdname networkmanager_create_global_network
networkmanager_create_global_network <- function(Description = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateGlobalNetwork",
    http_method = "POST",
    http_path = "/global-networks",
    paginator = list()
  )
  input <- .networkmanager$create_global_network_input(Description = Description, Tags = Tags)
  output <- .networkmanager$create_global_network_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$create_global_network <- networkmanager_create_global_network

#' Creates a new link for a specified site
#'
#' @description
#' Creates a new link for a specified site.
#'
#' See [https://paws-r.github.io/docs/networkmanager/create_link.html](https://paws-r.github.io/docs/networkmanager/create_link.html) for full documentation.
#'
#' @param GlobalNetworkId &#91;required&#93; The ID of the global network.
#' @param Description A description of the link.
#' 
#' Constraints: Maximum length of 256 characters.
#' @param Type The type of the link.
#' 
#' Constraints: Maximum length of 128 characters. Cannot include the
#' following characters: | \\ ^
#' @param Bandwidth &#91;required&#93; The upload speed and download speed in Mbps.
#' @param Provider The provider of the link.
#' 
#' Constraints: Maximum length of 128 characters. Cannot include the
#' following characters: | \\ ^
#' @param SiteId &#91;required&#93; The ID of the site.
#' @param Tags The tags to apply to the resource during creation.
#'
#' @keywords internal
#'
#' @rdname networkmanager_create_link
networkmanager_create_link <- function(GlobalNetworkId, Description = NULL, Type = NULL, Bandwidth, Provider = NULL, SiteId, Tags = NULL) {
  op <- new_operation(
    name = "CreateLink",
    http_method = "POST",
    http_path = "/global-networks/{globalNetworkId}/links",
    paginator = list()
  )
  input <- .networkmanager$create_link_input(GlobalNetworkId = GlobalNetworkId, Description = Description, Type = Type, Bandwidth = Bandwidth, Provider = Provider, SiteId = SiteId, Tags = Tags)
  output <- .networkmanager$create_link_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$create_link <- networkmanager_create_link

#' Creates a new site in a global network
#'
#' @description
#' Creates a new site in a global network.
#'
#' See [https://paws-r.github.io/docs/networkmanager/create_site.html](https://paws-r.github.io/docs/networkmanager/create_site.html) for full documentation.
#'
#' @param GlobalNetworkId &#91;required&#93; The ID of the global network.
#' @param Description A description of your site.
#' 
#' Constraints: Maximum length of 256 characters.
#' @param Location The site location. This information is used for visualization in the
#' Network Manager console. If you specify the address, the latitude and
#' longitude are automatically calculated.
#' 
#' -   `Address`: The physical address of the site.
#' 
#' -   `Latitude`: The latitude of the site.
#' 
#' -   `Longitude`: The longitude of the site.
#' @param Tags The tags to apply to the resource during creation.
#'
#' @keywords internal
#'
#' @rdname networkmanager_create_site
networkmanager_create_site <- function(GlobalNetworkId, Description = NULL, Location = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateSite",
    http_method = "POST",
    http_path = "/global-networks/{globalNetworkId}/sites",
    paginator = list()
  )
  input <- .networkmanager$create_site_input(GlobalNetworkId = GlobalNetworkId, Description = Description, Location = Location, Tags = Tags)
  output <- .networkmanager$create_site_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$create_site <- networkmanager_create_site

#' Creates an Amazon Web Services site-to-site VPN attachment on an edge
#' location of a core network
#'
#' @description
#' Creates an Amazon Web Services site-to-site VPN attachment on an edge location of a core network.
#'
#' See [https://paws-r.github.io/docs/networkmanager/create_site_to_site_vpn_attachment.html](https://paws-r.github.io/docs/networkmanager/create_site_to_site_vpn_attachment.html) for full documentation.
#'
#' @param CoreNetworkId &#91;required&#93; The ID of a core network where you're creating a site-to-site VPN
#' attachment.
#' @param VpnConnectionArn &#91;required&#93; The ARN identifying the VPN attachment.
#' @param Tags The tags associated with the request.
#' @param ClientToken The client token associated with the request.
#'
#' @keywords internal
#'
#' @rdname networkmanager_create_site_to_site_vpn_attachment
networkmanager_create_site_to_site_vpn_attachment <- function(CoreNetworkId, VpnConnectionArn, Tags = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "CreateSiteToSiteVpnAttachment",
    http_method = "POST",
    http_path = "/site-to-site-vpn-attachments",
    paginator = list()
  )
  input <- .networkmanager$create_site_to_site_vpn_attachment_input(CoreNetworkId = CoreNetworkId, VpnConnectionArn = VpnConnectionArn, Tags = Tags, ClientToken = ClientToken)
  output <- .networkmanager$create_site_to_site_vpn_attachment_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$create_site_to_site_vpn_attachment <- networkmanager_create_site_to_site_vpn_attachment

#' Creates a transit gateway peering connection
#'
#' @description
#' Creates a transit gateway peering connection.
#'
#' See [https://paws-r.github.io/docs/networkmanager/create_transit_gateway_peering.html](https://paws-r.github.io/docs/networkmanager/create_transit_gateway_peering.html) for full documentation.
#'
#' @param CoreNetworkId &#91;required&#93; The ID of a core network.
#' @param TransitGatewayArn &#91;required&#93; The ARN of the transit gateway for the peering request.
#' @param Tags The list of key-value tags associated with the request.
#' @param ClientToken The client token associated with the request.
#'
#' @keywords internal
#'
#' @rdname networkmanager_create_transit_gateway_peering
networkmanager_create_transit_gateway_peering <- function(CoreNetworkId, TransitGatewayArn, Tags = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "CreateTransitGatewayPeering",
    http_method = "POST",
    http_path = "/transit-gateway-peerings",
    paginator = list()
  )
  input <- .networkmanager$create_transit_gateway_peering_input(CoreNetworkId = CoreNetworkId, TransitGatewayArn = TransitGatewayArn, Tags = Tags, ClientToken = ClientToken)
  output <- .networkmanager$create_transit_gateway_peering_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$create_transit_gateway_peering <- networkmanager_create_transit_gateway_peering

#' Creates a transit gateway route table attachment
#'
#' @description
#' Creates a transit gateway route table attachment.
#'
#' See [https://paws-r.github.io/docs/networkmanager/create_transit_gateway_route_table_attachment.html](https://paws-r.github.io/docs/networkmanager/create_transit_gateway_route_table_attachment.html) for full documentation.
#'
#' @param PeeringId &#91;required&#93; The ID of the peer for the
#' @param TransitGatewayRouteTableArn &#91;required&#93; The ARN of the transit gateway route table for the attachment request.
#' @param Tags The list of key-value tags associated with the request.
#' @param ClientToken The client token associated with the request.
#'
#' @keywords internal
#'
#' @rdname networkmanager_create_transit_gateway_route_table_attachment
networkmanager_create_transit_gateway_route_table_attachment <- function(PeeringId, TransitGatewayRouteTableArn, Tags = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "CreateTransitGatewayRouteTableAttachment",
    http_method = "POST",
    http_path = "/transit-gateway-route-table-attachments",
    paginator = list()
  )
  input <- .networkmanager$create_transit_gateway_route_table_attachment_input(PeeringId = PeeringId, TransitGatewayRouteTableArn = TransitGatewayRouteTableArn, Tags = Tags, ClientToken = ClientToken)
  output <- .networkmanager$create_transit_gateway_route_table_attachment_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$create_transit_gateway_route_table_attachment <- networkmanager_create_transit_gateway_route_table_attachment

#' Creates a VPC attachment on an edge location of a core network
#'
#' @description
#' Creates a VPC attachment on an edge location of a core network.
#'
#' See [https://paws-r.github.io/docs/networkmanager/create_vpc_attachment.html](https://paws-r.github.io/docs/networkmanager/create_vpc_attachment.html) for full documentation.
#'
#' @param CoreNetworkId &#91;required&#93; The ID of a core network for the VPC attachment.
#' @param VpcArn &#91;required&#93; The ARN of the VPC.
#' @param SubnetArns &#91;required&#93; The subnet ARN of the VPC attachment.
#' @param Options Options for the VPC attachment.
#' @param Tags The key-value tags associated with the request.
#' @param ClientToken The client token associated with the request.
#'
#' @keywords internal
#'
#' @rdname networkmanager_create_vpc_attachment
networkmanager_create_vpc_attachment <- function(CoreNetworkId, VpcArn, SubnetArns, Options = NULL, Tags = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "CreateVpcAttachment",
    http_method = "POST",
    http_path = "/vpc-attachments",
    paginator = list()
  )
  input <- .networkmanager$create_vpc_attachment_input(CoreNetworkId = CoreNetworkId, VpcArn = VpcArn, SubnetArns = SubnetArns, Options = Options, Tags = Tags, ClientToken = ClientToken)
  output <- .networkmanager$create_vpc_attachment_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$create_vpc_attachment <- networkmanager_create_vpc_attachment

#' Deletes an attachment
#'
#' @description
#' Deletes an attachment. Supports all attachment types.
#'
#' See [https://paws-r.github.io/docs/networkmanager/delete_attachment.html](https://paws-r.github.io/docs/networkmanager/delete_attachment.html) for full documentation.
#'
#' @param AttachmentId &#91;required&#93; The ID of the attachment to delete.
#'
#' @keywords internal
#'
#' @rdname networkmanager_delete_attachment
networkmanager_delete_attachment <- function(AttachmentId) {
  op <- new_operation(
    name = "DeleteAttachment",
    http_method = "DELETE",
    http_path = "/attachments/{attachmentId}",
    paginator = list()
  )
  input <- .networkmanager$delete_attachment_input(AttachmentId = AttachmentId)
  output <- .networkmanager$delete_attachment_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$delete_attachment <- networkmanager_delete_attachment

#' Deletes a Connect peer
#'
#' @description
#' Deletes a Connect peer.
#'
#' See [https://paws-r.github.io/docs/networkmanager/delete_connect_peer.html](https://paws-r.github.io/docs/networkmanager/delete_connect_peer.html) for full documentation.
#'
#' @param ConnectPeerId &#91;required&#93; The ID of the deleted Connect peer.
#'
#' @keywords internal
#'
#' @rdname networkmanager_delete_connect_peer
networkmanager_delete_connect_peer <- function(ConnectPeerId) {
  op <- new_operation(
    name = "DeleteConnectPeer",
    http_method = "DELETE",
    http_path = "/connect-peers/{connectPeerId}",
    paginator = list()
  )
  input <- .networkmanager$delete_connect_peer_input(ConnectPeerId = ConnectPeerId)
  output <- .networkmanager$delete_connect_peer_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$delete_connect_peer <- networkmanager_delete_connect_peer

#' Deletes the specified connection in your global network
#'
#' @description
#' Deletes the specified connection in your global network.
#'
#' See [https://paws-r.github.io/docs/networkmanager/delete_connection.html](https://paws-r.github.io/docs/networkmanager/delete_connection.html) for full documentation.
#'
#' @param GlobalNetworkId &#91;required&#93; The ID of the global network.
#' @param ConnectionId &#91;required&#93; The ID of the connection.
#'
#' @keywords internal
#'
#' @rdname networkmanager_delete_connection
networkmanager_delete_connection <- function(GlobalNetworkId, ConnectionId) {
  op <- new_operation(
    name = "DeleteConnection",
    http_method = "DELETE",
    http_path = "/global-networks/{globalNetworkId}/connections/{connectionId}",
    paginator = list()
  )
  input <- .networkmanager$delete_connection_input(GlobalNetworkId = GlobalNetworkId, ConnectionId = ConnectionId)
  output <- .networkmanager$delete_connection_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$delete_connection <- networkmanager_delete_connection

#' Deletes a core network along with all core network policies
#'
#' @description
#' Deletes a core network along with all core network policies. This can only be done if there are no attachments on a core network.
#'
#' See [https://paws-r.github.io/docs/networkmanager/delete_core_network.html](https://paws-r.github.io/docs/networkmanager/delete_core_network.html) for full documentation.
#'
#' @param CoreNetworkId &#91;required&#93; The network ID of the deleted core network.
#'
#' @keywords internal
#'
#' @rdname networkmanager_delete_core_network
networkmanager_delete_core_network <- function(CoreNetworkId) {
  op <- new_operation(
    name = "DeleteCoreNetwork",
    http_method = "DELETE",
    http_path = "/core-networks/{coreNetworkId}",
    paginator = list()
  )
  input <- .networkmanager$delete_core_network_input(CoreNetworkId = CoreNetworkId)
  output <- .networkmanager$delete_core_network_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$delete_core_network <- networkmanager_delete_core_network

#' Deletes a policy version from a core network
#'
#' @description
#' Deletes a policy version from a core network. You can't delete the current LIVE policy.
#'
#' See [https://paws-r.github.io/docs/networkmanager/delete_core_network_policy_version.html](https://paws-r.github.io/docs/networkmanager/delete_core_network_policy_version.html) for full documentation.
#'
#' @param CoreNetworkId &#91;required&#93; The ID of a core network for the deleted policy.
#' @param PolicyVersionId &#91;required&#93; The version ID of the deleted policy.
#'
#' @keywords internal
#'
#' @rdname networkmanager_delete_core_network_policy_version
networkmanager_delete_core_network_policy_version <- function(CoreNetworkId, PolicyVersionId) {
  op <- new_operation(
    name = "DeleteCoreNetworkPolicyVersion",
    http_method = "DELETE",
    http_path = "/core-networks/{coreNetworkId}/core-network-policy-versions/{policyVersionId}",
    paginator = list()
  )
  input <- .networkmanager$delete_core_network_policy_version_input(CoreNetworkId = CoreNetworkId, PolicyVersionId = PolicyVersionId)
  output <- .networkmanager$delete_core_network_policy_version_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$delete_core_network_policy_version <- networkmanager_delete_core_network_policy_version

#' Deletes an existing device
#'
#' @description
#' Deletes an existing device. You must first disassociate the device from any links and customer gateways.
#'
#' See [https://paws-r.github.io/docs/networkmanager/delete_device.html](https://paws-r.github.io/docs/networkmanager/delete_device.html) for full documentation.
#'
#' @param GlobalNetworkId &#91;required&#93; The ID of the global network.
#' @param DeviceId &#91;required&#93; The ID of the device.
#'
#' @keywords internal
#'
#' @rdname networkmanager_delete_device
networkmanager_delete_device <- function(GlobalNetworkId, DeviceId) {
  op <- new_operation(
    name = "DeleteDevice",
    http_method = "DELETE",
    http_path = "/global-networks/{globalNetworkId}/devices/{deviceId}",
    paginator = list()
  )
  input <- .networkmanager$delete_device_input(GlobalNetworkId = GlobalNetworkId, DeviceId = DeviceId)
  output <- .networkmanager$delete_device_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$delete_device <- networkmanager_delete_device

#' Deletes an existing global network
#'
#' @description
#' Deletes an existing global network. You must first delete all global network objects (devices, links, and sites), deregister all transit gateways, and delete any core networks.
#'
#' See [https://paws-r.github.io/docs/networkmanager/delete_global_network.html](https://paws-r.github.io/docs/networkmanager/delete_global_network.html) for full documentation.
#'
#' @param GlobalNetworkId &#91;required&#93; The ID of the global network.
#'
#' @keywords internal
#'
#' @rdname networkmanager_delete_global_network
networkmanager_delete_global_network <- function(GlobalNetworkId) {
  op <- new_operation(
    name = "DeleteGlobalNetwork",
    http_method = "DELETE",
    http_path = "/global-networks/{globalNetworkId}",
    paginator = list()
  )
  input <- .networkmanager$delete_global_network_input(GlobalNetworkId = GlobalNetworkId)
  output <- .networkmanager$delete_global_network_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$delete_global_network <- networkmanager_delete_global_network

#' Deletes an existing link
#'
#' @description
#' Deletes an existing link. You must first disassociate the link from any devices and customer gateways.
#'
#' See [https://paws-r.github.io/docs/networkmanager/delete_link.html](https://paws-r.github.io/docs/networkmanager/delete_link.html) for full documentation.
#'
#' @param GlobalNetworkId &#91;required&#93; The ID of the global network.
#' @param LinkId &#91;required&#93; The ID of the link.
#'
#' @keywords internal
#'
#' @rdname networkmanager_delete_link
networkmanager_delete_link <- function(GlobalNetworkId, LinkId) {
  op <- new_operation(
    name = "DeleteLink",
    http_method = "DELETE",
    http_path = "/global-networks/{globalNetworkId}/links/{linkId}",
    paginator = list()
  )
  input <- .networkmanager$delete_link_input(GlobalNetworkId = GlobalNetworkId, LinkId = LinkId)
  output <- .networkmanager$delete_link_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$delete_link <- networkmanager_delete_link

#' Deletes an existing peering connection
#'
#' @description
#' Deletes an existing peering connection.
#'
#' See [https://paws-r.github.io/docs/networkmanager/delete_peering.html](https://paws-r.github.io/docs/networkmanager/delete_peering.html) for full documentation.
#'
#' @param PeeringId &#91;required&#93; The ID of the peering connection to delete.
#'
#' @keywords internal
#'
#' @rdname networkmanager_delete_peering
networkmanager_delete_peering <- function(PeeringId) {
  op <- new_operation(
    name = "DeletePeering",
    http_method = "DELETE",
    http_path = "/peerings/{peeringId}",
    paginator = list()
  )
  input <- .networkmanager$delete_peering_input(PeeringId = PeeringId)
  output <- .networkmanager$delete_peering_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$delete_peering <- networkmanager_delete_peering

#' Deletes a resource policy for the specified resource
#'
#' @description
#' Deletes a resource policy for the specified resource. This revokes the access of the principals specified in the resource policy.
#'
#' See [https://paws-r.github.io/docs/networkmanager/delete_resource_policy.html](https://paws-r.github.io/docs/networkmanager/delete_resource_policy.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The ARN of the policy to delete.
#'
#' @keywords internal
#'
#' @rdname networkmanager_delete_resource_policy
networkmanager_delete_resource_policy <- function(ResourceArn) {
  op <- new_operation(
    name = "DeleteResourcePolicy",
    http_method = "DELETE",
    http_path = "/resource-policy/{resourceArn}",
    paginator = list()
  )
  input <- .networkmanager$delete_resource_policy_input(ResourceArn = ResourceArn)
  output <- .networkmanager$delete_resource_policy_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$delete_resource_policy <- networkmanager_delete_resource_policy

#' Deletes an existing site
#'
#' @description
#' Deletes an existing site. The site cannot be associated with any device or link.
#'
#' See [https://paws-r.github.io/docs/networkmanager/delete_site.html](https://paws-r.github.io/docs/networkmanager/delete_site.html) for full documentation.
#'
#' @param GlobalNetworkId &#91;required&#93; The ID of the global network.
#' @param SiteId &#91;required&#93; The ID of the site.
#'
#' @keywords internal
#'
#' @rdname networkmanager_delete_site
networkmanager_delete_site <- function(GlobalNetworkId, SiteId) {
  op <- new_operation(
    name = "DeleteSite",
    http_method = "DELETE",
    http_path = "/global-networks/{globalNetworkId}/sites/{siteId}",
    paginator = list()
  )
  input <- .networkmanager$delete_site_input(GlobalNetworkId = GlobalNetworkId, SiteId = SiteId)
  output <- .networkmanager$delete_site_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$delete_site <- networkmanager_delete_site

#' Deregisters a transit gateway from your global network
#'
#' @description
#' Deregisters a transit gateway from your global network. This action does not delete your transit gateway, or modify any of its attachments. This action removes any customer gateway associations.
#'
#' See [https://paws-r.github.io/docs/networkmanager/deregister_transit_gateway.html](https://paws-r.github.io/docs/networkmanager/deregister_transit_gateway.html) for full documentation.
#'
#' @param GlobalNetworkId &#91;required&#93; The ID of the global network.
#' @param TransitGatewayArn &#91;required&#93; The Amazon Resource Name (ARN) of the transit gateway.
#'
#' @keywords internal
#'
#' @rdname networkmanager_deregister_transit_gateway
networkmanager_deregister_transit_gateway <- function(GlobalNetworkId, TransitGatewayArn) {
  op <- new_operation(
    name = "DeregisterTransitGateway",
    http_method = "DELETE",
    http_path = "/global-networks/{globalNetworkId}/transit-gateway-registrations/{transitGatewayArn}",
    paginator = list()
  )
  input <- .networkmanager$deregister_transit_gateway_input(GlobalNetworkId = GlobalNetworkId, TransitGatewayArn = TransitGatewayArn)
  output <- .networkmanager$deregister_transit_gateway_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$deregister_transit_gateway <- networkmanager_deregister_transit_gateway

#' Describes one or more global networks
#'
#' @description
#' Describes one or more global networks. By default, all global networks are described. To describe the objects in your global network, you must use the appropriate `Get*` action. For example, to list the transit gateways in your global network, use [`get_transit_gateway_registrations`][networkmanager_get_transit_gateway_registrations].
#'
#' See [https://paws-r.github.io/docs/networkmanager/describe_global_networks.html](https://paws-r.github.io/docs/networkmanager/describe_global_networks.html) for full documentation.
#'
#' @param GlobalNetworkIds The IDs of one or more global networks. The maximum is 10.
#' @param MaxResults The maximum number of results to return.
#' @param NextToken The token for the next page of results.
#'
#' @keywords internal
#'
#' @rdname networkmanager_describe_global_networks
networkmanager_describe_global_networks <- function(GlobalNetworkIds = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeGlobalNetworks",
    http_method = "GET",
    http_path = "/global-networks",
    paginator = list()
  )
  input <- .networkmanager$describe_global_networks_input(GlobalNetworkIds = GlobalNetworkIds, MaxResults = MaxResults, NextToken = NextToken)
  output <- .networkmanager$describe_global_networks_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$describe_global_networks <- networkmanager_describe_global_networks

#' Disassociates a core network Connect peer from a device and a link
#'
#' @description
#' Disassociates a core network Connect peer from a device and a link.
#'
#' See [https://paws-r.github.io/docs/networkmanager/disassociate_connect_peer.html](https://paws-r.github.io/docs/networkmanager/disassociate_connect_peer.html) for full documentation.
#'
#' @param GlobalNetworkId &#91;required&#93; The ID of the global network.
#' @param ConnectPeerId &#91;required&#93; The ID of the Connect peer to disassociate from a device.
#'
#' @keywords internal
#'
#' @rdname networkmanager_disassociate_connect_peer
networkmanager_disassociate_connect_peer <- function(GlobalNetworkId, ConnectPeerId) {
  op <- new_operation(
    name = "DisassociateConnectPeer",
    http_method = "DELETE",
    http_path = "/global-networks/{globalNetworkId}/connect-peer-associations/{connectPeerId}",
    paginator = list()
  )
  input <- .networkmanager$disassociate_connect_peer_input(GlobalNetworkId = GlobalNetworkId, ConnectPeerId = ConnectPeerId)
  output <- .networkmanager$disassociate_connect_peer_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$disassociate_connect_peer <- networkmanager_disassociate_connect_peer

#' Disassociates a customer gateway from a device and a link
#'
#' @description
#' Disassociates a customer gateway from a device and a link.
#'
#' See [https://paws-r.github.io/docs/networkmanager/disassociate_customer_gateway.html](https://paws-r.github.io/docs/networkmanager/disassociate_customer_gateway.html) for full documentation.
#'
#' @param GlobalNetworkId &#91;required&#93; The ID of the global network.
#' @param CustomerGatewayArn &#91;required&#93; The Amazon Resource Name (ARN) of the customer gateway.
#'
#' @keywords internal
#'
#' @rdname networkmanager_disassociate_customer_gateway
networkmanager_disassociate_customer_gateway <- function(GlobalNetworkId, CustomerGatewayArn) {
  op <- new_operation(
    name = "DisassociateCustomerGateway",
    http_method = "DELETE",
    http_path = "/global-networks/{globalNetworkId}/customer-gateway-associations/{customerGatewayArn}",
    paginator = list()
  )
  input <- .networkmanager$disassociate_customer_gateway_input(GlobalNetworkId = GlobalNetworkId, CustomerGatewayArn = CustomerGatewayArn)
  output <- .networkmanager$disassociate_customer_gateway_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$disassociate_customer_gateway <- networkmanager_disassociate_customer_gateway

#' Disassociates an existing device from a link
#'
#' @description
#' Disassociates an existing device from a link. You must first disassociate any customer gateways that are associated with the link.
#'
#' See [https://paws-r.github.io/docs/networkmanager/disassociate_link.html](https://paws-r.github.io/docs/networkmanager/disassociate_link.html) for full documentation.
#'
#' @param GlobalNetworkId &#91;required&#93; The ID of the global network.
#' @param DeviceId &#91;required&#93; The ID of the device.
#' @param LinkId &#91;required&#93; The ID of the link.
#'
#' @keywords internal
#'
#' @rdname networkmanager_disassociate_link
networkmanager_disassociate_link <- function(GlobalNetworkId, DeviceId, LinkId) {
  op <- new_operation(
    name = "DisassociateLink",
    http_method = "DELETE",
    http_path = "/global-networks/{globalNetworkId}/link-associations",
    paginator = list()
  )
  input <- .networkmanager$disassociate_link_input(GlobalNetworkId = GlobalNetworkId, DeviceId = DeviceId, LinkId = LinkId)
  output <- .networkmanager$disassociate_link_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$disassociate_link <- networkmanager_disassociate_link

#' Disassociates a transit gateway Connect peer from a device and link
#'
#' @description
#' Disassociates a transit gateway Connect peer from a device and link.
#'
#' See [https://paws-r.github.io/docs/networkmanager/disassociate_transit_gateway_connect_peer.html](https://paws-r.github.io/docs/networkmanager/disassociate_transit_gateway_connect_peer.html) for full documentation.
#'
#' @param GlobalNetworkId &#91;required&#93; The ID of the global network.
#' @param TransitGatewayConnectPeerArn &#91;required&#93; The Amazon Resource Name (ARN) of the transit gateway Connect peer.
#'
#' @keywords internal
#'
#' @rdname networkmanager_disassociate_transit_gateway_connect_peer
networkmanager_disassociate_transit_gateway_connect_peer <- function(GlobalNetworkId, TransitGatewayConnectPeerArn) {
  op <- new_operation(
    name = "DisassociateTransitGatewayConnectPeer",
    http_method = "DELETE",
    http_path = "/global-networks/{globalNetworkId}/transit-gateway-connect-peer-associations/{transitGatewayConnectPeerArn}",
    paginator = list()
  )
  input <- .networkmanager$disassociate_transit_gateway_connect_peer_input(GlobalNetworkId = GlobalNetworkId, TransitGatewayConnectPeerArn = TransitGatewayConnectPeerArn)
  output <- .networkmanager$disassociate_transit_gateway_connect_peer_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$disassociate_transit_gateway_connect_peer <- networkmanager_disassociate_transit_gateway_connect_peer

#' Executes a change set on your core network
#'
#' @description
#' Executes a change set on your core network. Deploys changes globally based on the policy submitted..
#'
#' See [https://paws-r.github.io/docs/networkmanager/execute_core_network_change_set.html](https://paws-r.github.io/docs/networkmanager/execute_core_network_change_set.html) for full documentation.
#'
#' @param CoreNetworkId &#91;required&#93; The ID of a core network.
#' @param PolicyVersionId &#91;required&#93; The ID of the policy version.
#'
#' @keywords internal
#'
#' @rdname networkmanager_execute_core_network_change_set
networkmanager_execute_core_network_change_set <- function(CoreNetworkId, PolicyVersionId) {
  op <- new_operation(
    name = "ExecuteCoreNetworkChangeSet",
    http_method = "POST",
    http_path = "/core-networks/{coreNetworkId}/core-network-change-sets/{policyVersionId}/execute",
    paginator = list()
  )
  input <- .networkmanager$execute_core_network_change_set_input(CoreNetworkId = CoreNetworkId, PolicyVersionId = PolicyVersionId)
  output <- .networkmanager$execute_core_network_change_set_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$execute_core_network_change_set <- networkmanager_execute_core_network_change_set

#' Returns information about a core network Connect attachment
#'
#' @description
#' Returns information about a core network Connect attachment.
#'
#' See [https://paws-r.github.io/docs/networkmanager/get_connect_attachment.html](https://paws-r.github.io/docs/networkmanager/get_connect_attachment.html) for full documentation.
#'
#' @param AttachmentId &#91;required&#93; The ID of the attachment.
#'
#' @keywords internal
#'
#' @rdname networkmanager_get_connect_attachment
networkmanager_get_connect_attachment <- function(AttachmentId) {
  op <- new_operation(
    name = "GetConnectAttachment",
    http_method = "GET",
    http_path = "/connect-attachments/{attachmentId}",
    paginator = list()
  )
  input <- .networkmanager$get_connect_attachment_input(AttachmentId = AttachmentId)
  output <- .networkmanager$get_connect_attachment_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$get_connect_attachment <- networkmanager_get_connect_attachment

#' Returns information about a core network Connect peer
#'
#' @description
#' Returns information about a core network Connect peer.
#'
#' See [https://paws-r.github.io/docs/networkmanager/get_connect_peer.html](https://paws-r.github.io/docs/networkmanager/get_connect_peer.html) for full documentation.
#'
#' @param ConnectPeerId &#91;required&#93; The ID of the Connect peer.
#'
#' @keywords internal
#'
#' @rdname networkmanager_get_connect_peer
networkmanager_get_connect_peer <- function(ConnectPeerId) {
  op <- new_operation(
    name = "GetConnectPeer",
    http_method = "GET",
    http_path = "/connect-peers/{connectPeerId}",
    paginator = list()
  )
  input <- .networkmanager$get_connect_peer_input(ConnectPeerId = ConnectPeerId)
  output <- .networkmanager$get_connect_peer_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$get_connect_peer <- networkmanager_get_connect_peer

#' Returns information about a core network Connect peer associations
#'
#' @description
#' Returns information about a core network Connect peer associations.
#'
#' See [https://paws-r.github.io/docs/networkmanager/get_connect_peer_associations.html](https://paws-r.github.io/docs/networkmanager/get_connect_peer_associations.html) for full documentation.
#'
#' @param GlobalNetworkId &#91;required&#93; The ID of the global network.
#' @param ConnectPeerIds The IDs of the Connect peers.
#' @param MaxResults The maximum number of results to return.
#' @param NextToken The token for the next page of results.
#'
#' @keywords internal
#'
#' @rdname networkmanager_get_connect_peer_associations
networkmanager_get_connect_peer_associations <- function(GlobalNetworkId, ConnectPeerIds = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetConnectPeerAssociations",
    http_method = "GET",
    http_path = "/global-networks/{globalNetworkId}/connect-peer-associations",
    paginator = list()
  )
  input <- .networkmanager$get_connect_peer_associations_input(GlobalNetworkId = GlobalNetworkId, ConnectPeerIds = ConnectPeerIds, MaxResults = MaxResults, NextToken = NextToken)
  output <- .networkmanager$get_connect_peer_associations_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$get_connect_peer_associations <- networkmanager_get_connect_peer_associations

#' Gets information about one or more of your connections in a global
#' network
#'
#' @description
#' Gets information about one or more of your connections in a global network.
#'
#' See [https://paws-r.github.io/docs/networkmanager/get_connections.html](https://paws-r.github.io/docs/networkmanager/get_connections.html) for full documentation.
#'
#' @param GlobalNetworkId &#91;required&#93; The ID of the global network.
#' @param ConnectionIds One or more connection IDs.
#' @param DeviceId The ID of the device.
#' @param MaxResults The maximum number of results to return.
#' @param NextToken The token for the next page of results.
#'
#' @keywords internal
#'
#' @rdname networkmanager_get_connections
networkmanager_get_connections <- function(GlobalNetworkId, ConnectionIds = NULL, DeviceId = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetConnections",
    http_method = "GET",
    http_path = "/global-networks/{globalNetworkId}/connections",
    paginator = list()
  )
  input <- .networkmanager$get_connections_input(GlobalNetworkId = GlobalNetworkId, ConnectionIds = ConnectionIds, DeviceId = DeviceId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .networkmanager$get_connections_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$get_connections <- networkmanager_get_connections

#' Returns information about the LIVE policy for a core network
#'
#' @description
#' Returns information about the LIVE policy for a core network.
#'
#' See [https://paws-r.github.io/docs/networkmanager/get_core_network.html](https://paws-r.github.io/docs/networkmanager/get_core_network.html) for full documentation.
#'
#' @param CoreNetworkId &#91;required&#93; The ID of a core network.
#'
#' @keywords internal
#'
#' @rdname networkmanager_get_core_network
networkmanager_get_core_network <- function(CoreNetworkId) {
  op <- new_operation(
    name = "GetCoreNetwork",
    http_method = "GET",
    http_path = "/core-networks/{coreNetworkId}",
    paginator = list()
  )
  input <- .networkmanager$get_core_network_input(CoreNetworkId = CoreNetworkId)
  output <- .networkmanager$get_core_network_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$get_core_network <- networkmanager_get_core_network

#' Returns information about a core network change event
#'
#' @description
#' Returns information about a core network change event.
#'
#' See [https://paws-r.github.io/docs/networkmanager/get_core_network_change_events.html](https://paws-r.github.io/docs/networkmanager/get_core_network_change_events.html) for full documentation.
#'
#' @param CoreNetworkId &#91;required&#93; The ID of a core network.
#' @param PolicyVersionId &#91;required&#93; The ID of the policy version.
#' @param MaxResults The maximum number of results to return.
#' @param NextToken The token for the next page of results.
#'
#' @keywords internal
#'
#' @rdname networkmanager_get_core_network_change_events
networkmanager_get_core_network_change_events <- function(CoreNetworkId, PolicyVersionId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetCoreNetworkChangeEvents",
    http_method = "GET",
    http_path = "/core-networks/{coreNetworkId}/core-network-change-events/{policyVersionId}",
    paginator = list()
  )
  input <- .networkmanager$get_core_network_change_events_input(CoreNetworkId = CoreNetworkId, PolicyVersionId = PolicyVersionId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .networkmanager$get_core_network_change_events_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$get_core_network_change_events <- networkmanager_get_core_network_change_events

#' Returns a change set between the LIVE core network policy and a
#' submitted policy
#'
#' @description
#' Returns a change set between the LIVE core network policy and a submitted policy.
#'
#' See [https://paws-r.github.io/docs/networkmanager/get_core_network_change_set.html](https://paws-r.github.io/docs/networkmanager/get_core_network_change_set.html) for full documentation.
#'
#' @param CoreNetworkId &#91;required&#93; The ID of a core network.
#' @param PolicyVersionId &#91;required&#93; The ID of the policy version.
#' @param MaxResults The maximum number of results to return.
#' @param NextToken The token for the next page of results.
#'
#' @keywords internal
#'
#' @rdname networkmanager_get_core_network_change_set
networkmanager_get_core_network_change_set <- function(CoreNetworkId, PolicyVersionId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetCoreNetworkChangeSet",
    http_method = "GET",
    http_path = "/core-networks/{coreNetworkId}/core-network-change-sets/{policyVersionId}",
    paginator = list()
  )
  input <- .networkmanager$get_core_network_change_set_input(CoreNetworkId = CoreNetworkId, PolicyVersionId = PolicyVersionId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .networkmanager$get_core_network_change_set_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$get_core_network_change_set <- networkmanager_get_core_network_change_set

#' Returns details about a core network policy
#'
#' @description
#' Returns details about a core network policy. You can get details about your current live policy or any previous policy version.
#'
#' See [https://paws-r.github.io/docs/networkmanager/get_core_network_policy.html](https://paws-r.github.io/docs/networkmanager/get_core_network_policy.html) for full documentation.
#'
#' @param CoreNetworkId &#91;required&#93; The ID of a core network.
#' @param PolicyVersionId The ID of a core network policy version.
#' @param Alias The alias of a core network policy
#'
#' @keywords internal
#'
#' @rdname networkmanager_get_core_network_policy
networkmanager_get_core_network_policy <- function(CoreNetworkId, PolicyVersionId = NULL, Alias = NULL) {
  op <- new_operation(
    name = "GetCoreNetworkPolicy",
    http_method = "GET",
    http_path = "/core-networks/{coreNetworkId}/core-network-policy",
    paginator = list()
  )
  input <- .networkmanager$get_core_network_policy_input(CoreNetworkId = CoreNetworkId, PolicyVersionId = PolicyVersionId, Alias = Alias)
  output <- .networkmanager$get_core_network_policy_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$get_core_network_policy <- networkmanager_get_core_network_policy

#' Gets the association information for customer gateways that are
#' associated with devices and links in your global network
#'
#' @description
#' Gets the association information for customer gateways that are associated with devices and links in your global network.
#'
#' See [https://paws-r.github.io/docs/networkmanager/get_customer_gateway_associations.html](https://paws-r.github.io/docs/networkmanager/get_customer_gateway_associations.html) for full documentation.
#'
#' @param GlobalNetworkId &#91;required&#93; The ID of the global network.
#' @param CustomerGatewayArns One or more customer gateway Amazon Resource Names (ARNs). The maximum
#' is 10.
#' @param MaxResults The maximum number of results to return.
#' @param NextToken The token for the next page of results.
#'
#' @keywords internal
#'
#' @rdname networkmanager_get_customer_gateway_associations
networkmanager_get_customer_gateway_associations <- function(GlobalNetworkId, CustomerGatewayArns = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetCustomerGatewayAssociations",
    http_method = "GET",
    http_path = "/global-networks/{globalNetworkId}/customer-gateway-associations",
    paginator = list()
  )
  input <- .networkmanager$get_customer_gateway_associations_input(GlobalNetworkId = GlobalNetworkId, CustomerGatewayArns = CustomerGatewayArns, MaxResults = MaxResults, NextToken = NextToken)
  output <- .networkmanager$get_customer_gateway_associations_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$get_customer_gateway_associations <- networkmanager_get_customer_gateway_associations

#' Gets information about one or more of your devices in a global network
#'
#' @description
#' Gets information about one or more of your devices in a global network.
#'
#' See [https://paws-r.github.io/docs/networkmanager/get_devices.html](https://paws-r.github.io/docs/networkmanager/get_devices.html) for full documentation.
#'
#' @param GlobalNetworkId &#91;required&#93; The ID of the global network.
#' @param DeviceIds One or more device IDs. The maximum is 10.
#' @param SiteId The ID of the site.
#' @param MaxResults The maximum number of results to return.
#' @param NextToken The token for the next page of results.
#'
#' @keywords internal
#'
#' @rdname networkmanager_get_devices
networkmanager_get_devices <- function(GlobalNetworkId, DeviceIds = NULL, SiteId = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetDevices",
    http_method = "GET",
    http_path = "/global-networks/{globalNetworkId}/devices",
    paginator = list()
  )
  input <- .networkmanager$get_devices_input(GlobalNetworkId = GlobalNetworkId, DeviceIds = DeviceIds, SiteId = SiteId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .networkmanager$get_devices_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$get_devices <- networkmanager_get_devices

#' Gets the link associations for a device or a link
#'
#' @description
#' Gets the link associations for a device or a link. Either the device ID or the link ID must be specified.
#'
#' See [https://paws-r.github.io/docs/networkmanager/get_link_associations.html](https://paws-r.github.io/docs/networkmanager/get_link_associations.html) for full documentation.
#'
#' @param GlobalNetworkId &#91;required&#93; The ID of the global network.
#' @param DeviceId The ID of the device.
#' @param LinkId The ID of the link.
#' @param MaxResults The maximum number of results to return.
#' @param NextToken The token for the next page of results.
#'
#' @keywords internal
#'
#' @rdname networkmanager_get_link_associations
networkmanager_get_link_associations <- function(GlobalNetworkId, DeviceId = NULL, LinkId = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetLinkAssociations",
    http_method = "GET",
    http_path = "/global-networks/{globalNetworkId}/link-associations",
    paginator = list()
  )
  input <- .networkmanager$get_link_associations_input(GlobalNetworkId = GlobalNetworkId, DeviceId = DeviceId, LinkId = LinkId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .networkmanager$get_link_associations_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$get_link_associations <- networkmanager_get_link_associations

#' Gets information about one or more links in a specified global network
#'
#' @description
#' Gets information about one or more links in a specified global network.
#'
#' See [https://paws-r.github.io/docs/networkmanager/get_links.html](https://paws-r.github.io/docs/networkmanager/get_links.html) for full documentation.
#'
#' @param GlobalNetworkId &#91;required&#93; The ID of the global network.
#' @param LinkIds One or more link IDs. The maximum is 10.
#' @param SiteId The ID of the site.
#' @param Type The link type.
#' @param Provider The link provider.
#' @param MaxResults The maximum number of results to return.
#' @param NextToken The token for the next page of results.
#'
#' @keywords internal
#'
#' @rdname networkmanager_get_links
networkmanager_get_links <- function(GlobalNetworkId, LinkIds = NULL, SiteId = NULL, Type = NULL, Provider = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetLinks",
    http_method = "GET",
    http_path = "/global-networks/{globalNetworkId}/links",
    paginator = list()
  )
  input <- .networkmanager$get_links_input(GlobalNetworkId = GlobalNetworkId, LinkIds = LinkIds, SiteId = SiteId, Type = Type, Provider = Provider, MaxResults = MaxResults, NextToken = NextToken)
  output <- .networkmanager$get_links_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$get_links <- networkmanager_get_links

#' Gets the count of network resources, by resource type, for the specified
#' global network
#'
#' @description
#' Gets the count of network resources, by resource type, for the specified global network.
#'
#' See [https://paws-r.github.io/docs/networkmanager/get_network_resource_counts.html](https://paws-r.github.io/docs/networkmanager/get_network_resource_counts.html) for full documentation.
#'
#' @param GlobalNetworkId &#91;required&#93; The ID of the global network.
#' @param ResourceType The resource type.
#' 
#' The following are the supported resource types for Direct Connect:
#' 
#' -   `dxcon`
#' 
#' -   `dx-gateway`
#' 
#' -   `dx-vif`
#' 
#' The following are the supported resource types for Network Manager:
#' 
#' -   `connection`
#' 
#' -   `device`
#' 
#' -   `link`
#' 
#' -   `site`
#' 
#' The following are the supported resource types for Amazon VPC:
#' 
#' -   `customer-gateway`
#' 
#' -   `transit-gateway`
#' 
#' -   `transit-gateway-attachment`
#' 
#' -   `transit-gateway-connect-peer`
#' 
#' -   `transit-gateway-route-table`
#' 
#' -   `vpn-connection`
#' @param MaxResults The maximum number of results to return.
#' @param NextToken The token for the next page of results.
#'
#' @keywords internal
#'
#' @rdname networkmanager_get_network_resource_counts
networkmanager_get_network_resource_counts <- function(GlobalNetworkId, ResourceType = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetNetworkResourceCounts",
    http_method = "GET",
    http_path = "/global-networks/{globalNetworkId}/network-resource-count",
    paginator = list()
  )
  input <- .networkmanager$get_network_resource_counts_input(GlobalNetworkId = GlobalNetworkId, ResourceType = ResourceType, MaxResults = MaxResults, NextToken = NextToken)
  output <- .networkmanager$get_network_resource_counts_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$get_network_resource_counts <- networkmanager_get_network_resource_counts

#' Gets the network resource relationships for the specified global network
#'
#' @description
#' Gets the network resource relationships for the specified global network.
#'
#' See [https://paws-r.github.io/docs/networkmanager/get_network_resource_relationships.html](https://paws-r.github.io/docs/networkmanager/get_network_resource_relationships.html) for full documentation.
#'
#' @param GlobalNetworkId &#91;required&#93; The ID of the global network.
#' @param CoreNetworkId The ID of a core network.
#' @param RegisteredGatewayArn The ARN of the registered gateway.
#' @param AwsRegion The Amazon Web Services Region.
#' @param AccountId The Amazon Web Services account ID.
#' @param ResourceType The resource type.
#' 
#' The following are the supported resource types for Direct Connect:
#' 
#' -   `dxcon`
#' 
#' -   `dx-gateway`
#' 
#' -   `dx-vif`
#' 
#' The following are the supported resource types for Network Manager:
#' 
#' -   `connection`
#' 
#' -   `device`
#' 
#' -   `link`
#' 
#' -   `site`
#' 
#' The following are the supported resource types for Amazon VPC:
#' 
#' -   `customer-gateway`
#' 
#' -   `transit-gateway`
#' 
#' -   `transit-gateway-attachment`
#' 
#' -   `transit-gateway-connect-peer`
#' 
#' -   `transit-gateway-route-table`
#' 
#' -   `vpn-connection`
#' @param ResourceArn The ARN of the gateway.
#' @param MaxResults The maximum number of results to return.
#' @param NextToken The token for the next page of results.
#'
#' @keywords internal
#'
#' @rdname networkmanager_get_network_resource_relationships
networkmanager_get_network_resource_relationships <- function(GlobalNetworkId, CoreNetworkId = NULL, RegisteredGatewayArn = NULL, AwsRegion = NULL, AccountId = NULL, ResourceType = NULL, ResourceArn = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetNetworkResourceRelationships",
    http_method = "GET",
    http_path = "/global-networks/{globalNetworkId}/network-resource-relationships",
    paginator = list()
  )
  input <- .networkmanager$get_network_resource_relationships_input(GlobalNetworkId = GlobalNetworkId, CoreNetworkId = CoreNetworkId, RegisteredGatewayArn = RegisteredGatewayArn, AwsRegion = AwsRegion, AccountId = AccountId, ResourceType = ResourceType, ResourceArn = ResourceArn, MaxResults = MaxResults, NextToken = NextToken)
  output <- .networkmanager$get_network_resource_relationships_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$get_network_resource_relationships <- networkmanager_get_network_resource_relationships

#' Describes the network resources for the specified global network
#'
#' @description
#' Describes the network resources for the specified global network.
#'
#' See [https://paws-r.github.io/docs/networkmanager/get_network_resources.html](https://paws-r.github.io/docs/networkmanager/get_network_resources.html) for full documentation.
#'
#' @param GlobalNetworkId &#91;required&#93; The ID of the global network.
#' @param CoreNetworkId The ID of a core network.
#' @param RegisteredGatewayArn The ARN of the gateway.
#' @param AwsRegion The Amazon Web Services Region.
#' @param AccountId The Amazon Web Services account ID.
#' @param ResourceType The resource type.
#' 
#' The following are the supported resource types for Direct Connect:
#' 
#' -   `dxcon` - The definition model is
#'     [Connection](https://docs.aws.amazon.com/directconnect/latest/APIReference/API_Connection.html).
#' 
#' -   `dx-gateway` - The definition model is
#'     [DirectConnectGateway](https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DirectConnectGateway.html).
#' 
#' -   `dx-vif` - The definition model is
#'     [VirtualInterface](https://docs.aws.amazon.com/directconnect/latest/APIReference/API_VirtualInterface.html).
#' 
#' The following are the supported resource types for Network Manager:
#' 
#' -   `connection` - The definition model is
#'     [Connection](https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_Connection.html).
#' 
#' -   `device` - The definition model is
#'     [Device](https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_Device.html).
#' 
#' -   `link` - The definition model is
#'     [Link](https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_Link.html).
#' 
#' -   `site` - The definition model is
#'     [Site](https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_Site.html).
#' 
#' The following are the supported resource types for Amazon VPC:
#' 
#' -   `customer-gateway` - The definition model is
#'     [CustomerGateway](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CustomerGateway.html).
#' 
#' -   `transit-gateway` - The definition model is
#'     [TransitGateway](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TransitGateway.html).
#' 
#' -   `transit-gateway-attachment` - The definition model is
#'     [TransitGatewayAttachment](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TransitGatewayAttachment.html).
#' 
#' -   `transit-gateway-connect-peer` - The definition model is
#'     [TransitGatewayConnectPeer](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TransitGatewayConnectPeer.html).
#' 
#' -   `transit-gateway-route-table` - The definition model is
#'     [TransitGatewayRouteTable](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TransitGatewayRouteTable.html).
#' 
#' -   `vpn-connection` - The definition model is
#'     [VpnConnection](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_VpnConnection.html).
#' @param ResourceArn The ARN of the resource.
#' @param MaxResults The maximum number of results to return.
#' @param NextToken The token for the next page of results.
#'
#' @keywords internal
#'
#' @rdname networkmanager_get_network_resources
networkmanager_get_network_resources <- function(GlobalNetworkId, CoreNetworkId = NULL, RegisteredGatewayArn = NULL, AwsRegion = NULL, AccountId = NULL, ResourceType = NULL, ResourceArn = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetNetworkResources",
    http_method = "GET",
    http_path = "/global-networks/{globalNetworkId}/network-resources",
    paginator = list()
  )
  input <- .networkmanager$get_network_resources_input(GlobalNetworkId = GlobalNetworkId, CoreNetworkId = CoreNetworkId, RegisteredGatewayArn = RegisteredGatewayArn, AwsRegion = AwsRegion, AccountId = AccountId, ResourceType = ResourceType, ResourceArn = ResourceArn, MaxResults = MaxResults, NextToken = NextToken)
  output <- .networkmanager$get_network_resources_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$get_network_resources <- networkmanager_get_network_resources

#' Gets the network routes of the specified global network
#'
#' @description
#' Gets the network routes of the specified global network.
#'
#' See [https://paws-r.github.io/docs/networkmanager/get_network_routes.html](https://paws-r.github.io/docs/networkmanager/get_network_routes.html) for full documentation.
#'
#' @param GlobalNetworkId &#91;required&#93; The ID of the global network.
#' @param RouteTableIdentifier &#91;required&#93; The ID of the route table.
#' @param ExactCidrMatches An exact CIDR block.
#' @param LongestPrefixMatches The most specific route that matches the traffic (longest prefix match).
#' @param SubnetOfMatches The routes with a subnet that match the specified CIDR filter.
#' @param SupernetOfMatches The routes with a CIDR that encompasses the CIDR filter. Example: If you
#' specify 10.0.1.0/30, then the result returns 10.0.1.0/29.
#' @param PrefixListIds The IDs of the prefix lists.
#' @param States The route states.
#' @param Types The route types.
#' @param DestinationFilters Filter by route table destination. Possible Values:
#' TRANSIT_GATEWAY_ATTACHMENT_ID, RESOURCE_ID, or RESOURCE_TYPE.
#'
#' @keywords internal
#'
#' @rdname networkmanager_get_network_routes
networkmanager_get_network_routes <- function(GlobalNetworkId, RouteTableIdentifier, ExactCidrMatches = NULL, LongestPrefixMatches = NULL, SubnetOfMatches = NULL, SupernetOfMatches = NULL, PrefixListIds = NULL, States = NULL, Types = NULL, DestinationFilters = NULL) {
  op <- new_operation(
    name = "GetNetworkRoutes",
    http_method = "POST",
    http_path = "/global-networks/{globalNetworkId}/network-routes",
    paginator = list()
  )
  input <- .networkmanager$get_network_routes_input(GlobalNetworkId = GlobalNetworkId, RouteTableIdentifier = RouteTableIdentifier, ExactCidrMatches = ExactCidrMatches, LongestPrefixMatches = LongestPrefixMatches, SubnetOfMatches = SubnetOfMatches, SupernetOfMatches = SupernetOfMatches, PrefixListIds = PrefixListIds, States = States, Types = Types, DestinationFilters = DestinationFilters)
  output <- .networkmanager$get_network_routes_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$get_network_routes <- networkmanager_get_network_routes

#' Gets the network telemetry of the specified global network
#'
#' @description
#' Gets the network telemetry of the specified global network.
#'
#' See [https://paws-r.github.io/docs/networkmanager/get_network_telemetry.html](https://paws-r.github.io/docs/networkmanager/get_network_telemetry.html) for full documentation.
#'
#' @param GlobalNetworkId &#91;required&#93; The ID of the global network.
#' @param CoreNetworkId The ID of a core network.
#' @param RegisteredGatewayArn The ARN of the gateway.
#' @param AwsRegion The Amazon Web Services Region.
#' @param AccountId The Amazon Web Services account ID.
#' @param ResourceType The resource type.
#' 
#' The following are the supported resource types for Direct Connect:
#' 
#' -   `dxcon`
#' 
#' -   `dx-gateway`
#' 
#' -   `dx-vif`
#' 
#' The following are the supported resource types for Network Manager:
#' 
#' -   `connection`
#' 
#' -   `device`
#' 
#' -   `link`
#' 
#' -   `site`
#' 
#' The following are the supported resource types for Amazon VPC:
#' 
#' -   `customer-gateway`
#' 
#' -   `transit-gateway`
#' 
#' -   `transit-gateway-attachment`
#' 
#' -   `transit-gateway-connect-peer`
#' 
#' -   `transit-gateway-route-table`
#' 
#' -   `vpn-connection`
#' @param ResourceArn The ARN of the resource.
#' @param MaxResults The maximum number of results to return.
#' @param NextToken The token for the next page of results.
#'
#' @keywords internal
#'
#' @rdname networkmanager_get_network_telemetry
networkmanager_get_network_telemetry <- function(GlobalNetworkId, CoreNetworkId = NULL, RegisteredGatewayArn = NULL, AwsRegion = NULL, AccountId = NULL, ResourceType = NULL, ResourceArn = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetNetworkTelemetry",
    http_method = "GET",
    http_path = "/global-networks/{globalNetworkId}/network-telemetry",
    paginator = list()
  )
  input <- .networkmanager$get_network_telemetry_input(GlobalNetworkId = GlobalNetworkId, CoreNetworkId = CoreNetworkId, RegisteredGatewayArn = RegisteredGatewayArn, AwsRegion = AwsRegion, AccountId = AccountId, ResourceType = ResourceType, ResourceArn = ResourceArn, MaxResults = MaxResults, NextToken = NextToken)
  output <- .networkmanager$get_network_telemetry_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$get_network_telemetry <- networkmanager_get_network_telemetry

#' Returns information about a resource policy
#'
#' @description
#' Returns information about a resource policy.
#'
#' See [https://paws-r.github.io/docs/networkmanager/get_resource_policy.html](https://paws-r.github.io/docs/networkmanager/get_resource_policy.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The ARN of the resource.
#'
#' @keywords internal
#'
#' @rdname networkmanager_get_resource_policy
networkmanager_get_resource_policy <- function(ResourceArn) {
  op <- new_operation(
    name = "GetResourcePolicy",
    http_method = "GET",
    http_path = "/resource-policy/{resourceArn}",
    paginator = list()
  )
  input <- .networkmanager$get_resource_policy_input(ResourceArn = ResourceArn)
  output <- .networkmanager$get_resource_policy_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$get_resource_policy <- networkmanager_get_resource_policy

#' Gets information about the specified route analysis
#'
#' @description
#' Gets information about the specified route analysis.
#'
#' See [https://paws-r.github.io/docs/networkmanager/get_route_analysis.html](https://paws-r.github.io/docs/networkmanager/get_route_analysis.html) for full documentation.
#'
#' @param GlobalNetworkId &#91;required&#93; The ID of the global network.
#' @param RouteAnalysisId &#91;required&#93; The ID of the route analysis.
#'
#' @keywords internal
#'
#' @rdname networkmanager_get_route_analysis
networkmanager_get_route_analysis <- function(GlobalNetworkId, RouteAnalysisId) {
  op <- new_operation(
    name = "GetRouteAnalysis",
    http_method = "GET",
    http_path = "/global-networks/{globalNetworkId}/route-analyses/{routeAnalysisId}",
    paginator = list()
  )
  input <- .networkmanager$get_route_analysis_input(GlobalNetworkId = GlobalNetworkId, RouteAnalysisId = RouteAnalysisId)
  output <- .networkmanager$get_route_analysis_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$get_route_analysis <- networkmanager_get_route_analysis

#' Returns information about a site-to-site VPN attachment
#'
#' @description
#' Returns information about a site-to-site VPN attachment.
#'
#' See [https://paws-r.github.io/docs/networkmanager/get_site_to_site_vpn_attachment.html](https://paws-r.github.io/docs/networkmanager/get_site_to_site_vpn_attachment.html) for full documentation.
#'
#' @param AttachmentId &#91;required&#93; The ID of the attachment.
#'
#' @keywords internal
#'
#' @rdname networkmanager_get_site_to_site_vpn_attachment
networkmanager_get_site_to_site_vpn_attachment <- function(AttachmentId) {
  op <- new_operation(
    name = "GetSiteToSiteVpnAttachment",
    http_method = "GET",
    http_path = "/site-to-site-vpn-attachments/{attachmentId}",
    paginator = list()
  )
  input <- .networkmanager$get_site_to_site_vpn_attachment_input(AttachmentId = AttachmentId)
  output <- .networkmanager$get_site_to_site_vpn_attachment_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$get_site_to_site_vpn_attachment <- networkmanager_get_site_to_site_vpn_attachment

#' Gets information about one or more of your sites in a global network
#'
#' @description
#' Gets information about one or more of your sites in a global network.
#'
#' See [https://paws-r.github.io/docs/networkmanager/get_sites.html](https://paws-r.github.io/docs/networkmanager/get_sites.html) for full documentation.
#'
#' @param GlobalNetworkId &#91;required&#93; The ID of the global network.
#' @param SiteIds One or more site IDs. The maximum is 10.
#' @param MaxResults The maximum number of results to return.
#' @param NextToken The token for the next page of results.
#'
#' @keywords internal
#'
#' @rdname networkmanager_get_sites
networkmanager_get_sites <- function(GlobalNetworkId, SiteIds = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetSites",
    http_method = "GET",
    http_path = "/global-networks/{globalNetworkId}/sites",
    paginator = list()
  )
  input <- .networkmanager$get_sites_input(GlobalNetworkId = GlobalNetworkId, SiteIds = SiteIds, MaxResults = MaxResults, NextToken = NextToken)
  output <- .networkmanager$get_sites_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$get_sites <- networkmanager_get_sites

#' Gets information about one or more of your transit gateway Connect peer
#' associations in a global network
#'
#' @description
#' Gets information about one or more of your transit gateway Connect peer associations in a global network.
#'
#' See [https://paws-r.github.io/docs/networkmanager/get_transit_gateway_connect_peer_associations.html](https://paws-r.github.io/docs/networkmanager/get_transit_gateway_connect_peer_associations.html) for full documentation.
#'
#' @param GlobalNetworkId &#91;required&#93; The ID of the global network.
#' @param TransitGatewayConnectPeerArns One or more transit gateway Connect peer Amazon Resource Names (ARNs).
#' @param MaxResults The maximum number of results to return.
#' @param NextToken The token for the next page of results.
#'
#' @keywords internal
#'
#' @rdname networkmanager_get_transit_gateway_connect_peer_associations
networkmanager_get_transit_gateway_connect_peer_associations <- function(GlobalNetworkId, TransitGatewayConnectPeerArns = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetTransitGatewayConnectPeerAssociations",
    http_method = "GET",
    http_path = "/global-networks/{globalNetworkId}/transit-gateway-connect-peer-associations",
    paginator = list()
  )
  input <- .networkmanager$get_transit_gateway_connect_peer_associations_input(GlobalNetworkId = GlobalNetworkId, TransitGatewayConnectPeerArns = TransitGatewayConnectPeerArns, MaxResults = MaxResults, NextToken = NextToken)
  output <- .networkmanager$get_transit_gateway_connect_peer_associations_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$get_transit_gateway_connect_peer_associations <- networkmanager_get_transit_gateway_connect_peer_associations

#' Returns information about a transit gateway peer
#'
#' @description
#' Returns information about a transit gateway peer.
#'
#' See [https://paws-r.github.io/docs/networkmanager/get_transit_gateway_peering.html](https://paws-r.github.io/docs/networkmanager/get_transit_gateway_peering.html) for full documentation.
#'
#' @param PeeringId &#91;required&#93; The ID of the peering request.
#'
#' @keywords internal
#'
#' @rdname networkmanager_get_transit_gateway_peering
networkmanager_get_transit_gateway_peering <- function(PeeringId) {
  op <- new_operation(
    name = "GetTransitGatewayPeering",
    http_method = "GET",
    http_path = "/transit-gateway-peerings/{peeringId}",
    paginator = list()
  )
  input <- .networkmanager$get_transit_gateway_peering_input(PeeringId = PeeringId)
  output <- .networkmanager$get_transit_gateway_peering_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$get_transit_gateway_peering <- networkmanager_get_transit_gateway_peering

#' Gets information about the transit gateway registrations in a specified
#' global network
#'
#' @description
#' Gets information about the transit gateway registrations in a specified global network.
#'
#' See [https://paws-r.github.io/docs/networkmanager/get_transit_gateway_registrations.html](https://paws-r.github.io/docs/networkmanager/get_transit_gateway_registrations.html) for full documentation.
#'
#' @param GlobalNetworkId &#91;required&#93; The ID of the global network.
#' @param TransitGatewayArns The Amazon Resource Names (ARNs) of one or more transit gateways. The
#' maximum is 10.
#' @param MaxResults The maximum number of results to return.
#' @param NextToken The token for the next page of results.
#'
#' @keywords internal
#'
#' @rdname networkmanager_get_transit_gateway_registrations
networkmanager_get_transit_gateway_registrations <- function(GlobalNetworkId, TransitGatewayArns = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetTransitGatewayRegistrations",
    http_method = "GET",
    http_path = "/global-networks/{globalNetworkId}/transit-gateway-registrations",
    paginator = list()
  )
  input <- .networkmanager$get_transit_gateway_registrations_input(GlobalNetworkId = GlobalNetworkId, TransitGatewayArns = TransitGatewayArns, MaxResults = MaxResults, NextToken = NextToken)
  output <- .networkmanager$get_transit_gateway_registrations_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$get_transit_gateway_registrations <- networkmanager_get_transit_gateway_registrations

#' Returns information about a transit gateway route table attachment
#'
#' @description
#' Returns information about a transit gateway route table attachment.
#'
#' See [https://paws-r.github.io/docs/networkmanager/get_transit_gateway_route_table_attachment.html](https://paws-r.github.io/docs/networkmanager/get_transit_gateway_route_table_attachment.html) for full documentation.
#'
#' @param AttachmentId &#91;required&#93; The ID of the transit gateway route table attachment.
#'
#' @keywords internal
#'
#' @rdname networkmanager_get_transit_gateway_route_table_attachment
networkmanager_get_transit_gateway_route_table_attachment <- function(AttachmentId) {
  op <- new_operation(
    name = "GetTransitGatewayRouteTableAttachment",
    http_method = "GET",
    http_path = "/transit-gateway-route-table-attachments/{attachmentId}",
    paginator = list()
  )
  input <- .networkmanager$get_transit_gateway_route_table_attachment_input(AttachmentId = AttachmentId)
  output <- .networkmanager$get_transit_gateway_route_table_attachment_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$get_transit_gateway_route_table_attachment <- networkmanager_get_transit_gateway_route_table_attachment

#' Returns information about a VPC attachment
#'
#' @description
#' Returns information about a VPC attachment.
#'
#' See [https://paws-r.github.io/docs/networkmanager/get_vpc_attachment.html](https://paws-r.github.io/docs/networkmanager/get_vpc_attachment.html) for full documentation.
#'
#' @param AttachmentId &#91;required&#93; The ID of the attachment.
#'
#' @keywords internal
#'
#' @rdname networkmanager_get_vpc_attachment
networkmanager_get_vpc_attachment <- function(AttachmentId) {
  op <- new_operation(
    name = "GetVpcAttachment",
    http_method = "GET",
    http_path = "/vpc-attachments/{attachmentId}",
    paginator = list()
  )
  input <- .networkmanager$get_vpc_attachment_input(AttachmentId = AttachmentId)
  output <- .networkmanager$get_vpc_attachment_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$get_vpc_attachment <- networkmanager_get_vpc_attachment

#' Returns a list of core network attachments
#'
#' @description
#' Returns a list of core network attachments.
#'
#' See [https://paws-r.github.io/docs/networkmanager/list_attachments.html](https://paws-r.github.io/docs/networkmanager/list_attachments.html) for full documentation.
#'
#' @param CoreNetworkId The ID of a core network.
#' @param AttachmentType The type of attachment.
#' @param EdgeLocation The Region where the edge is located.
#' @param State The state of the attachment.
#' @param MaxResults The maximum number of results to return.
#' @param NextToken The token for the next page of results.
#'
#' @keywords internal
#'
#' @rdname networkmanager_list_attachments
networkmanager_list_attachments <- function(CoreNetworkId = NULL, AttachmentType = NULL, EdgeLocation = NULL, State = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListAttachments",
    http_method = "GET",
    http_path = "/attachments",
    paginator = list()
  )
  input <- .networkmanager$list_attachments_input(CoreNetworkId = CoreNetworkId, AttachmentType = AttachmentType, EdgeLocation = EdgeLocation, State = State, MaxResults = MaxResults, NextToken = NextToken)
  output <- .networkmanager$list_attachments_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$list_attachments <- networkmanager_list_attachments

#' Returns a list of core network Connect peers
#'
#' @description
#' Returns a list of core network Connect peers.
#'
#' See [https://paws-r.github.io/docs/networkmanager/list_connect_peers.html](https://paws-r.github.io/docs/networkmanager/list_connect_peers.html) for full documentation.
#'
#' @param CoreNetworkId The ID of a core network.
#' @param ConnectAttachmentId The ID of the attachment.
#' @param MaxResults The maximum number of results to return.
#' @param NextToken The token for the next page of results.
#'
#' @keywords internal
#'
#' @rdname networkmanager_list_connect_peers
networkmanager_list_connect_peers <- function(CoreNetworkId = NULL, ConnectAttachmentId = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListConnectPeers",
    http_method = "GET",
    http_path = "/connect-peers",
    paginator = list()
  )
  input <- .networkmanager$list_connect_peers_input(CoreNetworkId = CoreNetworkId, ConnectAttachmentId = ConnectAttachmentId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .networkmanager$list_connect_peers_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$list_connect_peers <- networkmanager_list_connect_peers

#' Returns a list of core network policy versions
#'
#' @description
#' Returns a list of core network policy versions.
#'
#' See [https://paws-r.github.io/docs/networkmanager/list_core_network_policy_versions.html](https://paws-r.github.io/docs/networkmanager/list_core_network_policy_versions.html) for full documentation.
#'
#' @param CoreNetworkId &#91;required&#93; The ID of a core network.
#' @param MaxResults The maximum number of results to return.
#' @param NextToken The token for the next page of results.
#'
#' @keywords internal
#'
#' @rdname networkmanager_list_core_network_policy_versions
networkmanager_list_core_network_policy_versions <- function(CoreNetworkId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListCoreNetworkPolicyVersions",
    http_method = "GET",
    http_path = "/core-networks/{coreNetworkId}/core-network-policy-versions",
    paginator = list()
  )
  input <- .networkmanager$list_core_network_policy_versions_input(CoreNetworkId = CoreNetworkId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .networkmanager$list_core_network_policy_versions_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$list_core_network_policy_versions <- networkmanager_list_core_network_policy_versions

#' Returns a list of owned and shared core networks
#'
#' @description
#' Returns a list of owned and shared core networks.
#'
#' See [https://paws-r.github.io/docs/networkmanager/list_core_networks.html](https://paws-r.github.io/docs/networkmanager/list_core_networks.html) for full documentation.
#'
#' @param MaxResults The maximum number of results to return.
#' @param NextToken The token for the next page of results.
#'
#' @keywords internal
#'
#' @rdname networkmanager_list_core_networks
networkmanager_list_core_networks <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListCoreNetworks",
    http_method = "GET",
    http_path = "/core-networks",
    paginator = list()
  )
  input <- .networkmanager$list_core_networks_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .networkmanager$list_core_networks_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$list_core_networks <- networkmanager_list_core_networks

#' Gets the status of the Service Linked Role (SLR) deployment for the
#' accounts in a given Amazon Web Services Organization
#'
#' @description
#' Gets the status of the Service Linked Role (SLR) deployment for the accounts in a given Amazon Web Services Organization.
#'
#' See [https://paws-r.github.io/docs/networkmanager/list_organization_service_access_status.html](https://paws-r.github.io/docs/networkmanager/list_organization_service_access_status.html) for full documentation.
#'
#' @param MaxResults The maximum number of results to return.
#' @param NextToken The token for the next page of results.
#'
#' @keywords internal
#'
#' @rdname networkmanager_list_organization_service_access_status
networkmanager_list_organization_service_access_status <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListOrganizationServiceAccessStatus",
    http_method = "GET",
    http_path = "/organizations/service-access",
    paginator = list()
  )
  input <- .networkmanager$list_organization_service_access_status_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .networkmanager$list_organization_service_access_status_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$list_organization_service_access_status <- networkmanager_list_organization_service_access_status

#' Lists the peerings for a core network
#'
#' @description
#' Lists the peerings for a core network.
#'
#' See [https://paws-r.github.io/docs/networkmanager/list_peerings.html](https://paws-r.github.io/docs/networkmanager/list_peerings.html) for full documentation.
#'
#' @param CoreNetworkId The ID of a core network.
#' @param PeeringType Returns a list of a peering requests.
#' @param EdgeLocation Returns a list edge locations for the
#' @param State Returns a list of the peering request states.
#' @param MaxResults The maximum number of results to return.
#' @param NextToken The token for the next page of results.
#'
#' @keywords internal
#'
#' @rdname networkmanager_list_peerings
networkmanager_list_peerings <- function(CoreNetworkId = NULL, PeeringType = NULL, EdgeLocation = NULL, State = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListPeerings",
    http_method = "GET",
    http_path = "/peerings",
    paginator = list()
  )
  input <- .networkmanager$list_peerings_input(CoreNetworkId = CoreNetworkId, PeeringType = PeeringType, EdgeLocation = EdgeLocation, State = State, MaxResults = MaxResults, NextToken = NextToken)
  output <- .networkmanager$list_peerings_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$list_peerings <- networkmanager_list_peerings

#' Lists the tags for a specified resource
#'
#' @description
#' Lists the tags for a specified resource.
#'
#' See [https://paws-r.github.io/docs/networkmanager/list_tags_for_resource.html](https://paws-r.github.io/docs/networkmanager/list_tags_for_resource.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#'
#' @keywords internal
#'
#' @rdname networkmanager_list_tags_for_resource
networkmanager_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .networkmanager$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .networkmanager$list_tags_for_resource_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$list_tags_for_resource <- networkmanager_list_tags_for_resource

#' Creates a new, immutable version of a core network policy
#'
#' @description
#' Creates a new, immutable version of a core network policy. A subsequent change set is created showing the differences between the LIVE policy and the submitted policy.
#'
#' See [https://paws-r.github.io/docs/networkmanager/put_core_network_policy.html](https://paws-r.github.io/docs/networkmanager/put_core_network_policy.html) for full documentation.
#'
#' @param CoreNetworkId &#91;required&#93; The ID of a core network.
#' @param PolicyDocument &#91;required&#93; The policy document.
#' @param Description a core network policy description.
#' @param LatestVersionId The ID of a core network policy.
#' @param ClientToken The client token associated with the request.
#'
#' @keywords internal
#'
#' @rdname networkmanager_put_core_network_policy
networkmanager_put_core_network_policy <- function(CoreNetworkId, PolicyDocument, Description = NULL, LatestVersionId = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "PutCoreNetworkPolicy",
    http_method = "POST",
    http_path = "/core-networks/{coreNetworkId}/core-network-policy",
    paginator = list()
  )
  input <- .networkmanager$put_core_network_policy_input(CoreNetworkId = CoreNetworkId, PolicyDocument = PolicyDocument, Description = Description, LatestVersionId = LatestVersionId, ClientToken = ClientToken)
  output <- .networkmanager$put_core_network_policy_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$put_core_network_policy <- networkmanager_put_core_network_policy

#' Creates or updates a resource policy
#'
#' @description
#' Creates or updates a resource policy.
#'
#' See [https://paws-r.github.io/docs/networkmanager/put_resource_policy.html](https://paws-r.github.io/docs/networkmanager/put_resource_policy.html) for full documentation.
#'
#' @param PolicyDocument &#91;required&#93; The JSON resource policy document.
#' @param ResourceArn &#91;required&#93; The ARN of the resource policy.
#'
#' @keywords internal
#'
#' @rdname networkmanager_put_resource_policy
networkmanager_put_resource_policy <- function(PolicyDocument, ResourceArn) {
  op <- new_operation(
    name = "PutResourcePolicy",
    http_method = "POST",
    http_path = "/resource-policy/{resourceArn}",
    paginator = list()
  )
  input <- .networkmanager$put_resource_policy_input(PolicyDocument = PolicyDocument, ResourceArn = ResourceArn)
  output <- .networkmanager$put_resource_policy_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$put_resource_policy <- networkmanager_put_resource_policy

#' Registers a transit gateway in your global network
#'
#' @description
#' Registers a transit gateway in your global network. The transit gateway can be in any Amazon Web Services Region, but it must be owned by the same Amazon Web Services account that owns the global network. You cannot register a transit gateway in more than one global network.
#'
#' See [https://paws-r.github.io/docs/networkmanager/register_transit_gateway.html](https://paws-r.github.io/docs/networkmanager/register_transit_gateway.html) for full documentation.
#'
#' @param GlobalNetworkId &#91;required&#93; The ID of the global network.
#' @param TransitGatewayArn &#91;required&#93; The Amazon Resource Name (ARN) of the transit gateway.
#'
#' @keywords internal
#'
#' @rdname networkmanager_register_transit_gateway
networkmanager_register_transit_gateway <- function(GlobalNetworkId, TransitGatewayArn) {
  op <- new_operation(
    name = "RegisterTransitGateway",
    http_method = "POST",
    http_path = "/global-networks/{globalNetworkId}/transit-gateway-registrations",
    paginator = list()
  )
  input <- .networkmanager$register_transit_gateway_input(GlobalNetworkId = GlobalNetworkId, TransitGatewayArn = TransitGatewayArn)
  output <- .networkmanager$register_transit_gateway_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$register_transit_gateway <- networkmanager_register_transit_gateway

#' Rejects a core network attachment request
#'
#' @description
#' Rejects a core network attachment request.
#'
#' See [https://paws-r.github.io/docs/networkmanager/reject_attachment.html](https://paws-r.github.io/docs/networkmanager/reject_attachment.html) for full documentation.
#'
#' @param AttachmentId &#91;required&#93; The ID of the attachment.
#'
#' @keywords internal
#'
#' @rdname networkmanager_reject_attachment
networkmanager_reject_attachment <- function(AttachmentId) {
  op <- new_operation(
    name = "RejectAttachment",
    http_method = "POST",
    http_path = "/attachments/{attachmentId}/reject",
    paginator = list()
  )
  input <- .networkmanager$reject_attachment_input(AttachmentId = AttachmentId)
  output <- .networkmanager$reject_attachment_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$reject_attachment <- networkmanager_reject_attachment

#' Restores a previous policy version as a new, immutable version of a core
#' network policy
#'
#' @description
#' Restores a previous policy version as a new, immutable version of a core network policy. A subsequent change set is created showing the differences between the LIVE policy and restored policy.
#'
#' See [https://paws-r.github.io/docs/networkmanager/restore_core_network_policy_version.html](https://paws-r.github.io/docs/networkmanager/restore_core_network_policy_version.html) for full documentation.
#'
#' @param CoreNetworkId &#91;required&#93; The ID of a core network.
#' @param PolicyVersionId &#91;required&#93; The ID of the policy version to restore.
#'
#' @keywords internal
#'
#' @rdname networkmanager_restore_core_network_policy_version
networkmanager_restore_core_network_policy_version <- function(CoreNetworkId, PolicyVersionId) {
  op <- new_operation(
    name = "RestoreCoreNetworkPolicyVersion",
    http_method = "POST",
    http_path = "/core-networks/{coreNetworkId}/core-network-policy-versions/{policyVersionId}/restore",
    paginator = list()
  )
  input <- .networkmanager$restore_core_network_policy_version_input(CoreNetworkId = CoreNetworkId, PolicyVersionId = PolicyVersionId)
  output <- .networkmanager$restore_core_network_policy_version_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$restore_core_network_policy_version <- networkmanager_restore_core_network_policy_version

#' Enables for the Network Manager service for an Amazon Web Services
#' Organization
#'
#' @description
#' Enables for the Network Manager service for an Amazon Web Services Organization. This can only be called by a management account within the organization.
#'
#' See [https://paws-r.github.io/docs/networkmanager/start_organization_service_access_update.html](https://paws-r.github.io/docs/networkmanager/start_organization_service_access_update.html) for full documentation.
#'
#' @param Action &#91;required&#93; The action to take for the update request. This can be either `ENABLE`
#' or `DISABLE`.
#'
#' @keywords internal
#'
#' @rdname networkmanager_start_organization_service_access_update
networkmanager_start_organization_service_access_update <- function(Action) {
  op <- new_operation(
    name = "StartOrganizationServiceAccessUpdate",
    http_method = "POST",
    http_path = "/organizations/service-access",
    paginator = list()
  )
  input <- .networkmanager$start_organization_service_access_update_input(Action = Action)
  output <- .networkmanager$start_organization_service_access_update_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$start_organization_service_access_update <- networkmanager_start_organization_service_access_update

#' Starts analyzing the routing path between the specified source and
#' destination
#'
#' @description
#' Starts analyzing the routing path between the specified source and destination. For more information, see [Route Analyzer](https://docs.aws.amazon.com/network-manager/latest/tgwnm/route-analyzer.html).
#'
#' See [https://paws-r.github.io/docs/networkmanager/start_route_analysis.html](https://paws-r.github.io/docs/networkmanager/start_route_analysis.html) for full documentation.
#'
#' @param GlobalNetworkId &#91;required&#93; The ID of the global network.
#' @param Source &#91;required&#93; The source from which traffic originates.
#' @param Destination &#91;required&#93; The destination.
#' @param IncludeReturnPath Indicates whether to analyze the return path. The default is `false`.
#' @param UseMiddleboxes Indicates whether to include the location of middlebox appliances in the
#' route analysis. The default is `false`.
#'
#' @keywords internal
#'
#' @rdname networkmanager_start_route_analysis
networkmanager_start_route_analysis <- function(GlobalNetworkId, Source, Destination, IncludeReturnPath = NULL, UseMiddleboxes = NULL) {
  op <- new_operation(
    name = "StartRouteAnalysis",
    http_method = "POST",
    http_path = "/global-networks/{globalNetworkId}/route-analyses",
    paginator = list()
  )
  input <- .networkmanager$start_route_analysis_input(GlobalNetworkId = GlobalNetworkId, Source = Source, Destination = Destination, IncludeReturnPath = IncludeReturnPath, UseMiddleboxes = UseMiddleboxes)
  output <- .networkmanager$start_route_analysis_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$start_route_analysis <- networkmanager_start_route_analysis

#' Tags a specified resource
#'
#' @description
#' Tags a specified resource.
#'
#' See [https://paws-r.github.io/docs/networkmanager/tag_resource.html](https://paws-r.github.io/docs/networkmanager/tag_resource.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#' @param Tags &#91;required&#93; The tags to apply to the specified resource.
#'
#' @keywords internal
#'
#' @rdname networkmanager_tag_resource
networkmanager_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .networkmanager$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .networkmanager$tag_resource_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$tag_resource <- networkmanager_tag_resource

#' Removes tags from a specified resource
#'
#' @description
#' Removes tags from a specified resource.
#'
#' See [https://paws-r.github.io/docs/networkmanager/untag_resource.html](https://paws-r.github.io/docs/networkmanager/untag_resource.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#' @param TagKeys &#91;required&#93; The tag keys to remove from the specified resource.
#'
#' @keywords internal
#'
#' @rdname networkmanager_untag_resource
networkmanager_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .networkmanager$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .networkmanager$untag_resource_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$untag_resource <- networkmanager_untag_resource

#' Updates the information for an existing connection
#'
#' @description
#' Updates the information for an existing connection. To remove information for any of the parameters, specify an empty string.
#'
#' See [https://paws-r.github.io/docs/networkmanager/update_connection.html](https://paws-r.github.io/docs/networkmanager/update_connection.html) for full documentation.
#'
#' @param GlobalNetworkId &#91;required&#93; The ID of the global network.
#' @param ConnectionId &#91;required&#93; The ID of the connection.
#' @param LinkId The ID of the link for the first device in the connection.
#' @param ConnectedLinkId The ID of the link for the second device in the connection.
#' @param Description A description of the connection.
#' 
#' Length Constraints: Maximum length of 256 characters.
#'
#' @keywords internal
#'
#' @rdname networkmanager_update_connection
networkmanager_update_connection <- function(GlobalNetworkId, ConnectionId, LinkId = NULL, ConnectedLinkId = NULL, Description = NULL) {
  op <- new_operation(
    name = "UpdateConnection",
    http_method = "PATCH",
    http_path = "/global-networks/{globalNetworkId}/connections/{connectionId}",
    paginator = list()
  )
  input <- .networkmanager$update_connection_input(GlobalNetworkId = GlobalNetworkId, ConnectionId = ConnectionId, LinkId = LinkId, ConnectedLinkId = ConnectedLinkId, Description = Description)
  output <- .networkmanager$update_connection_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$update_connection <- networkmanager_update_connection

#' Updates the description of a core network
#'
#' @description
#' Updates the description of a core network.
#'
#' See [https://paws-r.github.io/docs/networkmanager/update_core_network.html](https://paws-r.github.io/docs/networkmanager/update_core_network.html) for full documentation.
#'
#' @param CoreNetworkId &#91;required&#93; The ID of a core network.
#' @param Description The description of the update.
#'
#' @keywords internal
#'
#' @rdname networkmanager_update_core_network
networkmanager_update_core_network <- function(CoreNetworkId, Description = NULL) {
  op <- new_operation(
    name = "UpdateCoreNetwork",
    http_method = "PATCH",
    http_path = "/core-networks/{coreNetworkId}",
    paginator = list()
  )
  input <- .networkmanager$update_core_network_input(CoreNetworkId = CoreNetworkId, Description = Description)
  output <- .networkmanager$update_core_network_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$update_core_network <- networkmanager_update_core_network

#' Updates the details for an existing device
#'
#' @description
#' Updates the details for an existing device. To remove information for any of the parameters, specify an empty string.
#'
#' See [https://paws-r.github.io/docs/networkmanager/update_device.html](https://paws-r.github.io/docs/networkmanager/update_device.html) for full documentation.
#'
#' @param GlobalNetworkId &#91;required&#93; The ID of the global network.
#' @param DeviceId &#91;required&#93; The ID of the device.
#' @param AWSLocation The Amazon Web Services location of the device, if applicable. For an
#' on-premises device, you can omit this parameter.
#' @param Description A description of the device.
#' 
#' Constraints: Maximum length of 256 characters.
#' @param Type The type of the device.
#' @param Vendor The vendor of the device.
#' 
#' Constraints: Maximum length of 128 characters.
#' @param Model The model of the device.
#' 
#' Constraints: Maximum length of 128 characters.
#' @param SerialNumber The serial number of the device.
#' 
#' Constraints: Maximum length of 128 characters.
#' @param Location 
#' @param SiteId The ID of the site.
#'
#' @keywords internal
#'
#' @rdname networkmanager_update_device
networkmanager_update_device <- function(GlobalNetworkId, DeviceId, AWSLocation = NULL, Description = NULL, Type = NULL, Vendor = NULL, Model = NULL, SerialNumber = NULL, Location = NULL, SiteId = NULL) {
  op <- new_operation(
    name = "UpdateDevice",
    http_method = "PATCH",
    http_path = "/global-networks/{globalNetworkId}/devices/{deviceId}",
    paginator = list()
  )
  input <- .networkmanager$update_device_input(GlobalNetworkId = GlobalNetworkId, DeviceId = DeviceId, AWSLocation = AWSLocation, Description = Description, Type = Type, Vendor = Vendor, Model = Model, SerialNumber = SerialNumber, Location = Location, SiteId = SiteId)
  output <- .networkmanager$update_device_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$update_device <- networkmanager_update_device

#' Updates an existing global network
#'
#' @description
#' Updates an existing global network. To remove information for any of the parameters, specify an empty string.
#'
#' See [https://paws-r.github.io/docs/networkmanager/update_global_network.html](https://paws-r.github.io/docs/networkmanager/update_global_network.html) for full documentation.
#'
#' @param GlobalNetworkId &#91;required&#93; The ID of your global network.
#' @param Description A description of the global network.
#' 
#' Constraints: Maximum length of 256 characters.
#'
#' @keywords internal
#'
#' @rdname networkmanager_update_global_network
networkmanager_update_global_network <- function(GlobalNetworkId, Description = NULL) {
  op <- new_operation(
    name = "UpdateGlobalNetwork",
    http_method = "PATCH",
    http_path = "/global-networks/{globalNetworkId}",
    paginator = list()
  )
  input <- .networkmanager$update_global_network_input(GlobalNetworkId = GlobalNetworkId, Description = Description)
  output <- .networkmanager$update_global_network_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$update_global_network <- networkmanager_update_global_network

#' Updates the details for an existing link
#'
#' @description
#' Updates the details for an existing link. To remove information for any of the parameters, specify an empty string.
#'
#' See [https://paws-r.github.io/docs/networkmanager/update_link.html](https://paws-r.github.io/docs/networkmanager/update_link.html) for full documentation.
#'
#' @param GlobalNetworkId &#91;required&#93; The ID of the global network.
#' @param LinkId &#91;required&#93; The ID of the link.
#' @param Description A description of the link.
#' 
#' Constraints: Maximum length of 256 characters.
#' @param Type The type of the link.
#' 
#' Constraints: Maximum length of 128 characters.
#' @param Bandwidth The upload and download speed in Mbps.
#' @param Provider The provider of the link.
#' 
#' Constraints: Maximum length of 128 characters.
#'
#' @keywords internal
#'
#' @rdname networkmanager_update_link
networkmanager_update_link <- function(GlobalNetworkId, LinkId, Description = NULL, Type = NULL, Bandwidth = NULL, Provider = NULL) {
  op <- new_operation(
    name = "UpdateLink",
    http_method = "PATCH",
    http_path = "/global-networks/{globalNetworkId}/links/{linkId}",
    paginator = list()
  )
  input <- .networkmanager$update_link_input(GlobalNetworkId = GlobalNetworkId, LinkId = LinkId, Description = Description, Type = Type, Bandwidth = Bandwidth, Provider = Provider)
  output <- .networkmanager$update_link_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$update_link <- networkmanager_update_link

#' Updates the resource metadata for the specified global network
#'
#' @description
#' Updates the resource metadata for the specified global network.
#'
#' See [https://paws-r.github.io/docs/networkmanager/update_network_resource_metadata.html](https://paws-r.github.io/docs/networkmanager/update_network_resource_metadata.html) for full documentation.
#'
#' @param GlobalNetworkId &#91;required&#93; The ID of the global network.
#' @param ResourceArn &#91;required&#93; The ARN of the resource.
#' @param Metadata &#91;required&#93; The resource metadata.
#'
#' @keywords internal
#'
#' @rdname networkmanager_update_network_resource_metadata
networkmanager_update_network_resource_metadata <- function(GlobalNetworkId, ResourceArn, Metadata) {
  op <- new_operation(
    name = "UpdateNetworkResourceMetadata",
    http_method = "PATCH",
    http_path = "/global-networks/{globalNetworkId}/network-resources/{resourceArn}/metadata",
    paginator = list()
  )
  input <- .networkmanager$update_network_resource_metadata_input(GlobalNetworkId = GlobalNetworkId, ResourceArn = ResourceArn, Metadata = Metadata)
  output <- .networkmanager$update_network_resource_metadata_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$update_network_resource_metadata <- networkmanager_update_network_resource_metadata

#' Updates the information for an existing site
#'
#' @description
#' Updates the information for an existing site. To remove information for any of the parameters, specify an empty string.
#'
#' See [https://paws-r.github.io/docs/networkmanager/update_site.html](https://paws-r.github.io/docs/networkmanager/update_site.html) for full documentation.
#'
#' @param GlobalNetworkId &#91;required&#93; The ID of the global network.
#' @param SiteId &#91;required&#93; The ID of your site.
#' @param Description A description of your site.
#' 
#' Constraints: Maximum length of 256 characters.
#' @param Location The site location:
#' 
#' -   `Address`: The physical address of the site.
#' 
#' -   `Latitude`: The latitude of the site.
#' 
#' -   `Longitude`: The longitude of the site.
#'
#' @keywords internal
#'
#' @rdname networkmanager_update_site
networkmanager_update_site <- function(GlobalNetworkId, SiteId, Description = NULL, Location = NULL) {
  op <- new_operation(
    name = "UpdateSite",
    http_method = "PATCH",
    http_path = "/global-networks/{globalNetworkId}/sites/{siteId}",
    paginator = list()
  )
  input <- .networkmanager$update_site_input(GlobalNetworkId = GlobalNetworkId, SiteId = SiteId, Description = Description, Location = Location)
  output <- .networkmanager$update_site_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$update_site <- networkmanager_update_site

#' Updates a VPC attachment
#'
#' @description
#' Updates a VPC attachment.
#'
#' See [https://paws-r.github.io/docs/networkmanager/update_vpc_attachment.html](https://paws-r.github.io/docs/networkmanager/update_vpc_attachment.html) for full documentation.
#'
#' @param AttachmentId &#91;required&#93; The ID of the attachment.
#' @param AddSubnetArns Adds a subnet ARN to the VPC attachment.
#' @param RemoveSubnetArns Removes a subnet ARN from the attachment.
#' @param Options Additional options for updating the VPC attachment.
#'
#' @keywords internal
#'
#' @rdname networkmanager_update_vpc_attachment
networkmanager_update_vpc_attachment <- function(AttachmentId, AddSubnetArns = NULL, RemoveSubnetArns = NULL, Options = NULL) {
  op <- new_operation(
    name = "UpdateVpcAttachment",
    http_method = "PATCH",
    http_path = "/vpc-attachments/{attachmentId}",
    paginator = list()
  )
  input <- .networkmanager$update_vpc_attachment_input(AttachmentId = AttachmentId, AddSubnetArns = AddSubnetArns, RemoveSubnetArns = RemoveSubnetArns, Options = Options)
  output <- .networkmanager$update_vpc_attachment_output()
  config <- get_config()
  svc <- .networkmanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.networkmanager$operations$update_vpc_attachment <- networkmanager_update_vpc_attachment
