% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networkmanager_operations.R
\name{networkmanager_get_network_resource_counts}
\alias{networkmanager_get_network_resource_counts}
\title{Gets the count of network resources, by resource type, for the specified
global network}
\usage{
networkmanager_get_network_resource_counts(
  GlobalNetworkId,
  ResourceType = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{GlobalNetworkId}{[required] The ID of the global network.}

\item{ResourceType}{The resource type.

The following are the supported resource types for Direct Connect:
\itemize{
\item \code{dxcon}
\item \code{dx-gateway}
\item \code{dx-vif}
}

The following are the supported resource types for Network Manager:
\itemize{
\item \code{connection}
\item \code{device}
\item \code{link}
\item \code{site}
}

The following are the supported resource types for Amazon VPC:
\itemize{
\item \code{customer-gateway}
\item \code{transit-gateway}
\item \code{transit-gateway-attachment}
\item \code{transit-gateway-connect-peer}
\item \code{transit-gateway-route-table}
\item \code{vpn-connection}
}}

\item{MaxResults}{The maximum number of results to return.}

\item{NextToken}{The token for the next page of results.}
}
\description{
Gets the count of network resources, by resource type, for the specified global network.

See \url{https://paws-r.github.io/docs/networkmanager/get_network_resource_counts.html} for full documentation.
}
\keyword{internal}
