% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53resolver_operations.R
\name{route53resolver_create_firewall_rule}
\alias{route53resolver_create_firewall_rule}
\title{Creates a single DNS Firewall rule in the specified rule group, using
the specified domain list}
\usage{
route53resolver_create_firewall_rule(
  CreatorRequestId,
  FirewallRuleGroupId,
  FirewallDomainListId,
  Priority,
  Action,
  BlockResponse = NULL,
  BlockOverrideDomain = NULL,
  BlockOverrideDnsType = NULL,
  BlockOverrideTtl = NULL,
  Name
)
}
\arguments{
\item{CreatorRequestId}{[required] A unique string that identifies the request and that allows you to retry
failed requests without the risk of running the operation twice.
\code{CreatorRequestId} can be any unique string, for example, a date/time
stamp.}

\item{FirewallRuleGroupId}{[required] The unique identifier of the firewall rule group where you want to
create the rule.}

\item{FirewallDomainListId}{[required] The ID of the domain list that you want to use in the rule.}

\item{Priority}{[required] The setting that determines the processing order of the rule in the rule
group. DNS Firewall processes the rules in a rule group by order of
priority, starting from the lowest setting.

You must specify a unique priority for each rule in a rule group. To
make it easier to insert rules later, leave space between the numbers,
for example, use 100, 200, and so on. You can change the priority
setting for the rules in a rule group at any time.}

\item{Action}{[required] The action that DNS Firewall should take on a DNS query when it matches
one of the domains in the rule's domain list:
\itemize{
\item \code{ALLOW} - Permit the request to go through.
\item \code{ALERT} - Permit the request and send metrics and logs to Cloud
Watch.
\item \code{BLOCK} - Disallow the request. This option requires additional
details in the rule's \code{BlockResponse}.
}}

\item{BlockResponse}{The way that you want DNS Firewall to block the request, used with the
rule action setting \code{BLOCK}.
\itemize{
\item \code{NODATA} - Respond indicating that the query was successful, but no
response is available for it.
\item \code{NXDOMAIN} - Respond indicating that the domain name that's in the
query doesn't exist.
\item \code{OVERRIDE} - Provide a custom override in the response. This option
requires custom handling details in the rule's \verb{BlockOverride*}
settings.
}

This setting is required if the rule action setting is \code{BLOCK}.}

\item{BlockOverrideDomain}{The custom DNS record to send back in response to the query. Used for
the rule action \code{BLOCK} with a \code{BlockResponse} setting of \code{OVERRIDE}.

This setting is required if the \code{BlockResponse} setting is \code{OVERRIDE}.}

\item{BlockOverrideDnsType}{The DNS record's type. This determines the format of the record value
that you provided in \code{BlockOverrideDomain}. Used for the rule action
\code{BLOCK} with a \code{BlockResponse} setting of \code{OVERRIDE}.

This setting is required if the \code{BlockResponse} setting is \code{OVERRIDE}.}

\item{BlockOverrideTtl}{The recommended amount of time, in seconds, for the DNS resolver or web
browser to cache the provided override record. Used for the rule action
\code{BLOCK} with a \code{BlockResponse} setting of \code{OVERRIDE}.

This setting is required if the \code{BlockResponse} setting is \code{OVERRIDE}.}

\item{Name}{[required] A name that lets you identify the rule in the rule group.}
}
\description{
Creates a single DNS Firewall rule in the specified rule group, using the specified domain list.

See \url{https://paws-r.github.io/docs/route53resolver/create_firewall_rule.html} for full documentation.
}
\keyword{internal}
