# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' Elastic Load Balancing
#'
#' @description
#' A load balancer distributes incoming traffic across targets, such as
#' your EC2 instances. This enables you to increase the availability of
#' your application. The load balancer also monitors the health of its
#' registered targets and ensures that it routes traffic only to healthy
#' targets. You configure your load balancer to accept incoming traffic by
#' specifying one or more listeners, which are configured with a protocol
#' and port number for connections from clients to the load balancer. You
#' configure a target group with a protocol and port number for connections
#' from the load balancer to the targets, and with health check settings to
#' be used when checking the health status of the targets.
#' 
#' Elastic Load Balancing supports the following types of load balancers:
#' Application Load Balancers, Network Load Balancers, Gateway Load
#' Balancers, and Classic Load Balancers. This reference covers the
#' following load balancer types:
#' 
#' -   Application Load Balancer - Operates at the application layer
#'     (layer 7) and supports HTTP and HTTPS.
#' 
#' -   Network Load Balancer - Operates at the transport layer (layer 4)
#'     and supports TCP, TLS, and UDP.
#' 
#' -   Gateway Load Balancer - Operates at the network layer (layer 3).
#' 
#' For more information, see the [Elastic Load Balancing User
#' Guide](https://docs.aws.amazon.com/elasticloadbalancing/latest/userguide/).
#' 
#' All Elastic Load Balancing operations are idempotent, which means that
#' they complete at most one time. If you repeat an operation, it succeeds.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- elbv2(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- elbv2()
#' # This example adds the specified tags to the specified load balancer.
#' svc$add_tags(
#'   ResourceArns = list(
#'     "arn:aws:elasticloadbalancing:us-west-2:123456789012:loadbalancer/app/m..."
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "project",
#'       Value = "lima"
#'     ),
#'     list(
#'       Key = "department",
#'       Value = "digital-media"
#'     )
#'   )
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=elbv2_add_listener_certificates]{add_listener_certificates} \tab Adds the specified SSL server certificate to the certificate list for the specified HTTPS or TLS listener\cr
#'  \link[=elbv2_add_tags]{add_tags} \tab Adds the specified tags to the specified Elastic Load Balancing resource\cr
#'  \link[=elbv2_add_trust_store_revocations]{add_trust_store_revocations} \tab Adds the specified revocation file to the specified trust store\cr
#'  \link[=elbv2_create_listener]{create_listener} \tab Creates a listener for the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer\cr
#'  \link[=elbv2_create_load_balancer]{create_load_balancer} \tab Creates an Application Load Balancer, Network Load Balancer, or Gateway Load Balancer\cr
#'  \link[=elbv2_create_rule]{create_rule} \tab Creates a rule for the specified listener\cr
#'  \link[=elbv2_create_target_group]{create_target_group} \tab Creates a target group\cr
#'  \link[=elbv2_create_trust_store]{create_trust_store} \tab Creates a trust store\cr
#'  \link[=elbv2_delete_listener]{delete_listener} \tab Deletes the specified listener\cr
#'  \link[=elbv2_delete_load_balancer]{delete_load_balancer} \tab Deletes the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer\cr
#'  \link[=elbv2_delete_rule]{delete_rule} \tab Deletes the specified rule\cr
#'  \link[=elbv2_delete_target_group]{delete_target_group} \tab Deletes the specified target group\cr
#'  \link[=elbv2_delete_trust_store]{delete_trust_store} \tab Deletes a trust store\cr
#'  \link[=elbv2_deregister_targets]{deregister_targets} \tab Deregisters the specified targets from the specified target group\cr
#'  \link[=elbv2_describe_account_limits]{describe_account_limits} \tab Describes the current Elastic Load Balancing resource limits for your Amazon Web Services account\cr
#'  \link[=elbv2_describe_listener_certificates]{describe_listener_certificates} \tab Describes the default certificate and the certificate list for the specified HTTPS or TLS listener\cr
#'  \link[=elbv2_describe_listeners]{describe_listeners} \tab Describes the specified listeners or the listeners for the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer\cr
#'  \link[=elbv2_describe_load_balancer_attributes]{describe_load_balancer_attributes} \tab Describes the attributes for the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer\cr
#'  \link[=elbv2_describe_load_balancers]{describe_load_balancers} \tab Describes the specified load balancers or all of your load balancers\cr
#'  \link[=elbv2_describe_rules]{describe_rules} \tab Describes the specified rules or the rules for the specified listener\cr
#'  \link[=elbv2_describe_ssl_policies]{describe_ssl_policies} \tab Describes the specified policies or all policies used for SSL negotiation\cr
#'  \link[=elbv2_describe_tags]{describe_tags} \tab Describes the tags for the specified Elastic Load Balancing resources\cr
#'  \link[=elbv2_describe_target_group_attributes]{describe_target_group_attributes} \tab Describes the attributes for the specified target group\cr
#'  \link[=elbv2_describe_target_groups]{describe_target_groups} \tab Describes the specified target groups or all of your target groups\cr
#'  \link[=elbv2_describe_target_health]{describe_target_health} \tab Describes the health of the specified targets or all of your targets\cr
#'  \link[=elbv2_describe_trust_store_associations]{describe_trust_store_associations} \tab Describes all resources associated with the specified trust store\cr
#'  \link[=elbv2_describe_trust_store_revocations]{describe_trust_store_revocations} \tab Describes the revocation files in use by the specified trust store arn, or revocation ID\cr
#'  \link[=elbv2_describe_trust_stores]{describe_trust_stores} \tab Describes all trust stores for a given account by trust store arn’s or name\cr
#'  \link[=elbv2_get_trust_store_ca_certificates_bundle]{get_trust_store_ca_certificates_bundle} \tab Retrieves the ca certificate bundle\cr
#'  \link[=elbv2_get_trust_store_revocation_content]{get_trust_store_revocation_content} \tab Retrieves the specified revocation file\cr
#'  \link[=elbv2_modify_listener]{modify_listener} \tab Replaces the specified properties of the specified listener\cr
#'  \link[=elbv2_modify_load_balancer_attributes]{modify_load_balancer_attributes} \tab Modifies the specified attributes of the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer\cr
#'  \link[=elbv2_modify_rule]{modify_rule} \tab Replaces the specified properties of the specified rule\cr
#'  \link[=elbv2_modify_target_group]{modify_target_group} \tab Modifies the health checks used when evaluating the health state of the targets in the specified target group\cr
#'  \link[=elbv2_modify_target_group_attributes]{modify_target_group_attributes} \tab Modifies the specified attributes of the specified target group\cr
#'  \link[=elbv2_modify_trust_store]{modify_trust_store} \tab Update the ca certificate bundle for a given trust store\cr
#'  \link[=elbv2_register_targets]{register_targets} \tab Registers the specified targets with the specified target group\cr
#'  \link[=elbv2_remove_listener_certificates]{remove_listener_certificates} \tab Removes the specified certificate from the certificate list for the specified HTTPS or TLS listener\cr
#'  \link[=elbv2_remove_tags]{remove_tags} \tab Removes the specified tags from the specified Elastic Load Balancing resources\cr
#'  \link[=elbv2_remove_trust_store_revocations]{remove_trust_store_revocations} \tab Removes the specified revocation file from the specified trust store\cr
#'  \link[=elbv2_set_ip_address_type]{set_ip_address_type} \tab Sets the type of IP addresses used by the subnets of the specified load balancer\cr
#'  \link[=elbv2_set_rule_priorities]{set_rule_priorities} \tab Sets the priorities of the specified rules\cr
#'  \link[=elbv2_set_security_groups]{set_security_groups} \tab Associates the specified security groups with the specified Application Load Balancer or Network Load Balancer\cr
#'  \link[=elbv2_set_subnets]{set_subnets} \tab Enables the Availability Zones for the specified public subnets for the specified Application Load Balancer, Network Load Balancer or Gateway Load Balancer
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname elbv2
#' @export
elbv2 <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .elbv2$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.elbv2 <- list()

.elbv2$operations <- list()

.elbv2$metadata <- list(
  service_name = "elasticloadbalancing",
  endpoints = list("*" = list(endpoint = "elasticloadbalancing.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "elasticloadbalancing.{region}.amazonaws.com.cn", global = FALSE), "eu-isoe-*" = list(endpoint = "elasticloadbalancing.{region}.cloud.adc-e.uk", global = FALSE), "us-iso-*" = list(endpoint = "elasticloadbalancing.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "elasticloadbalancing.{region}.sc2s.sgov.gov", global = FALSE), "us-isof-*" = list(endpoint = "elasticloadbalancing.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "Elastic Load Balancing v2",
  api_version = "2015-12-01",
  signing_name = "elasticloadbalancing",
  json_version = "",
  target_prefix = ""
)

.elbv2$service <- function(config = list()) {
  handlers <- new_handlers("query", "v4")
  new_service(.elbv2$metadata, handlers, config)
}
