% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appfabric_operations.R
\name{appfabric_create_ingestion_destination}
\alias{appfabric_create_ingestion_destination}
\title{Creates an ingestion destination, which specifies how an application's
ingested data is processed by Amazon Web Services AppFabric and where
it's delivered}
\usage{
appfabric_create_ingestion_destination(
  appBundleIdentifier,
  ingestionIdentifier,
  processingConfiguration,
  destinationConfiguration,
  clientToken = NULL,
  tags = NULL
)
}
\arguments{
\item{appBundleIdentifier}{[required] The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of
the app bundle to use for the request.}

\item{ingestionIdentifier}{[required] The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of
the ingestion to use for the request.}

\item{processingConfiguration}{[required] Contains information about how ingested data is processed.}

\item{destinationConfiguration}{[required] Contains information about the destination of ingested data.}

\item{clientToken}{Specifies a unique, case-sensitive identifier that you provide to ensure
the idempotency of the request. This lets you safely retry the request
without accidentally performing the same operation a second time.
Passing the same value to a later call to an operation requires that you
also pass the same value for all other parameters. We recommend that you
use a \href{https://en.wikipedia.org/wiki/Universally_unique_identifier}{UUID type of value}.

If you don't provide this value, then Amazon Web Services generates a
random one for you.

If you retry the operation with the same \code{ClientToken}, but with
different parameters, the retry fails with an
\code{IdempotentParameterMismatch} error.}

\item{tags}{A map of the key-value pairs of the tag or tags to assign to the
resource.}
}
\description{
Creates an ingestion destination, which specifies how an application's ingested data is processed by Amazon Web Services AppFabric and where it's delivered.

See \url{https://www.paws-r-sdk.com/docs/appfabric_create_ingestion_destination/} for full documentation.
}
\keyword{internal}
