% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53resolver_operations.R
\name{route53resolver_update_firewall_rule}
\alias{route53resolver_update_firewall_rule}
\title{Updates the specified firewall rule}
\usage{
route53resolver_update_firewall_rule(
  FirewallRuleGroupId,
  FirewallDomainListId,
  Priority = NULL,
  Action = NULL,
  BlockResponse = NULL,
  BlockOverrideDomain = NULL,
  BlockOverrideDnsType = NULL,
  BlockOverrideTtl = NULL,
  Name = NULL,
  FirewallDomainRedirectionAction = NULL,
  Qtype = NULL
)
}
\arguments{
\item{FirewallRuleGroupId}{[required] The unique identifier of the firewall rule group for the rule.}

\item{FirewallDomainListId}{[required] The ID of the domain list to use in the rule.}

\item{Priority}{The setting that determines the processing order of the rule in the rule
group. DNS Firewall processes the rules in a rule group by order of
priority, starting from the lowest setting.

You must specify a unique priority for each rule in a rule group. To
make it easier to insert rules later, leave space between the numbers,
for example, use 100, 200, and so on. You can change the priority
setting for the rules in a rule group at any time.}

\item{Action}{The action that DNS Firewall should take on a DNS query when it matches
one of the domains in the rule's domain list:
\itemize{
\item \code{ALLOW} - Permit the request to go through.
\item \code{ALERT} - Permit the request to go through but send an alert to the
logs.
\item \code{BLOCK} - Disallow the request. This option requires additional
details in the rule's \code{BlockResponse}.
}}

\item{BlockResponse}{The way that you want DNS Firewall to block the request. Used for the
rule action setting \code{BLOCK}.
\itemize{
\item \code{NODATA} - Respond indicating that the query was successful, but no
response is available for it.
\item \code{NXDOMAIN} - Respond indicating that the domain name that's in the
query doesn't exist.
\item \code{OVERRIDE} - Provide a custom override in the response. This option
requires custom handling details in the rule's \verb{BlockOverride*}
settings.
}}

\item{BlockOverrideDomain}{The custom DNS record to send back in response to the query. Used for
the rule action \code{BLOCK} with a \code{BlockResponse} setting of \code{OVERRIDE}.}

\item{BlockOverrideDnsType}{The DNS record's type. This determines the format of the record value
that you provided in \code{BlockOverrideDomain}. Used for the rule action
\code{BLOCK} with a \code{BlockResponse} setting of \code{OVERRIDE}.}

\item{BlockOverrideTtl}{The recommended amount of time, in seconds, for the DNS resolver or web
browser to cache the provided override record. Used for the rule action
\code{BLOCK} with a \code{BlockResponse} setting of \code{OVERRIDE}.}

\item{Name}{The name of the rule.}

\item{FirewallDomainRedirectionAction}{How you want the the rule to evaluate DNS redirection in the DNS
redirection chain, such as CNAME, DNAME, ot ALIAS.

\code{Inspect_Redirection_Domain }(Default) inspects all domains in the
redirection chain. The individual domains in the redirection chain must
be added to the allow domain list.

\code{Trust_Redirection_Domain } inspects only the first domain in the
redirection chain. You don't need to add the subsequent domains in the
domain in the redirection list to the domain alloww list.}

\item{Qtype}{The DNS query type you want the rule to evaluate. Allowed values are;
\itemize{
\item A: Returns an IPv4 address.
\item AAAA: Returns an Ipv6 address.
\item CAA: Restricts CAs that can create SSL/TLS certifications for the
domain.
\item CNAME: Returns another domain name.
\item DS: Record that identifies the DNSSEC signing key of a delegated
zone.
\item MX: Specifies mail servers.
\item NAPTR: Regular-expression-based rewriting of domain names.
\item NS: Authoritative name servers.
\item PTR: Maps an IP address to a domain name.
\item SOA: Start of authority record for the zone.
\item SPF: Lists the servers authorized to send emails from a domain.
\item SRV: Application specific values that identify servers.
\item TXT: Verifies email senders and application-specific values.
\item A query type you define by using the DNS type ID, for example 28 for
AAAA. The values must be defined as TYPENUMBER, where the NUMBER can
be 1-65334, for example, TYPE28. For more information, see \href{https://en.wikipedia.org/wiki/List_of_DNS_record_types}{List of DNS record types}.
}}
}
\description{
Updates the specified firewall rule.

See \url{https://www.paws-r-sdk.com/docs/route53resolver_update_firewall_rule/} for full documentation.
}
\keyword{internal}
