% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vpclattice_operations.R
\name{vpclattice_create_access_log_subscription}
\alias{vpclattice_create_access_log_subscription}
\title{Enables access logs to be sent to Amazon CloudWatch, Amazon S3, and
Amazon Kinesis Data Firehose}
\usage{
vpclattice_create_access_log_subscription(
  clientToken = NULL,
  destinationArn,
  resourceIdentifier,
  tags = NULL
)
}
\arguments{
\item{clientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. If you retry a request that completed
successfully using the same client token and parameters, the retry
succeeds without performing any actions. If the parameters aren't
identical, the retry fails.}

\item{destinationArn}{[required] The Amazon Resource Name (ARN) of the destination. The supported
destination types are CloudWatch Log groups, Kinesis Data Firehose
delivery streams, and Amazon S3 buckets.}

\item{resourceIdentifier}{[required] The ID or Amazon Resource Name (ARN) of the service network or service.}

\item{tags}{The tags for the access log subscription.}
}
\description{
Enables access logs to be sent to Amazon CloudWatch, Amazon S3, and Amazon Kinesis Data Firehose. The service network owner can use the access logs to audit the services in the network. The service network owner can only see access logs from clients and services that are associated with their service network. Access log entries represent traffic originated from VPCs associated with that network. For more information, see \href{https://docs.aws.amazon.com/vpc-lattice/latest/ug/monitoring-access-logs.html}{Access logs} in the \emph{Amazon VPC Lattice User Guide}.

See \url{https://www.paws-r-sdk.com/docs/vpclattice_create_access_log_subscription/} for full documentation.
}
\keyword{internal}
