% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acmpca_operations.R
\name{acmpca_import_certificate_authority_certificate}
\alias{acmpca_import_certificate_authority_certificate}
\title{Imports your signed private CA certificate into ACM PCA}
\usage{
acmpca_import_certificate_authority_certificate(CertificateAuthorityArn,
  Certificate, CertificateChain)
}
\arguments{
\item{CertificateAuthorityArn}{[required] The Amazon Resource Name (ARN) that was returned when you called
CreateCertificateAuthority. This must be of the form:

\code{arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> }}

\item{Certificate}{[required] The PEM-encoded certificate for your private CA. This must be signed by
using your on-premises CA.}

\item{CertificateChain}{[required] A PEM-encoded file that contains all of your certificates, other than
the certificate you're importing, chaining up to your root CA. Your
on-premises root certificate is the last in the chain, and each
certificate in the chain signs the one preceding.}
}
\description{
Imports your signed private CA certificate into ACM PCA. Before you can
call this operation, you must create the private certificate authority
by calling the CreateCertificateAuthority operation. You must then
generate a certificate signing request (CSR) by calling the
GetCertificateAuthorityCsr operation. Take the CSR to your on-premises
CA and use the root certificate or a subordinate certificate to sign it.
Create a certificate chain and copy the signed certificate and the
certificate chain to your working directory.
}
\details{
Your certificate chain must not include the private CA certificate that
you are importing.

Your on-premises CA certificate must be the last certificate in your
chain. The subordinate certificate, if any, that your root CA signed
must be next to last. The subordinate certificate signed by the
preceding subordinate CA must come next, and so on until your chain is
built.

The chain must be PEM-encoded.
}
\section{Request syntax}{
\preformatted{svc$import_certificate_authority_certificate(
  CertificateAuthorityArn = "string",
  Certificate = raw,
  CertificateChain = raw
)
}
}

\keyword{internal}
