% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sts_operations.R
\name{sts_assume_role_with_saml}
\alias{sts_assume_role_with_saml}
\title{Returns a set of temporary security credentials for users who have been
authenticated via a SAML authentication response}
\usage{
sts_assume_role_with_saml(RoleArn, PrincipalArn, SAMLAssertion, Policy,
  DurationSeconds)
}
\arguments{
\item{RoleArn}{[required] The Amazon Resource Name (ARN) of the role that the caller is assuming.}

\item{PrincipalArn}{[required] The Amazon Resource Name (ARN) of the SAML provider in IAM that
describes the IdP.}

\item{SAMLAssertion}{[required] The base-64 encoded SAML authentication response provided by the IdP.

For more information, see \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/create-role-saml-IdP-tasks.html}{Configuring a Relying Party and Adding Claims}
in the \emph{Using IAM} guide.}

\item{Policy}{An IAM policy in JSON format.

The policy parameter is optional. If you pass a policy, the temporary
security credentials that are returned by the operation have the
permissions that are allowed by both the access policy of the role that
is being assumed, \emph{\strong{and}} the policy that you pass. This gives you a
way to further restrict the permissions for the resulting temporary
security credentials. You cannot use the passed policy to grant
permissions that are in excess of those allowed by the access policy of
the role that is being assumed. For more information, \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_assumerole.html}{Permissions for AssumeRole, AssumeRoleWithSAML, and AssumeRoleWithWebIdentity}
in the \emph{IAM User Guide}.

The format for this parameter, as described by its regex pattern, is a
string of characters up to 2048 characters in length. The characters can
be any ASCII character from the space character to the end of the valid
character list (\code{U+0020}-\code{U+00FF}). It can also include the tab (\code{U+0009}),
linefeed (\code{U+000A}), and carriage return (\code{U+000D}) characters.

The policy plain text must be 2048 bytes or shorter. However, an
internal conversion compresses it into a packed binary format with a
separate limit. The PackedPolicySize response element indicates by
percentage how close to the upper size limit the policy is, with 100\%
equaling the maximum allowed size.}

\item{DurationSeconds}{The duration, in seconds, of the role session. Your role session lasts
for the duration that you specify for the \code{DurationSeconds} parameter,
or until the time specified in the SAML authentication response's
\code{SessionNotOnOrAfter} value, whichever is shorter. You can provide a
\code{DurationSeconds} value from 900 seconds (15 minutes) up to the maximum
session duration setting for the role. This setting can have a value
from 1 hour to 12 hours. If you specify a value higher than this
setting, the operation fails. For example, if you specify a session
duration of 12 hours, but your administrator set the maximum session
duration to 6 hours, your operation fails. To learn how to view the
maximum value for your role, see \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html#id_roles_use_view-role-max-session}{View the Maximum Session Duration Setting for a Role}
in the \emph{IAM User Guide}.

By default, the value is set to 3600 seconds.

The \code{DurationSeconds} parameter is separate from the duration of a
console session that you might request using the returned credentials.
The request to the federation endpoint for a console sign-in token takes
a \code{SessionDuration} parameter that specifies the maximum length of the
console session. For more information, see \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_enable-console-custom-url.html}{Creating a URL that Enables Federated Users to Access the AWS Management Console}
in the \emph{IAM User Guide}.}
}
\description{
Returns a set of temporary security credentials for users who have been
authenticated via a SAML authentication response. This operation
provides a mechanism for tying an enterprise identity store or directory
to role-based AWS access without user-specific credentials or
configuration. For a comparison of \code{AssumeRoleWithSAML} with the other
APIs that produce temporary credentials, see \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html}{Requesting Temporary Security Credentials}
and \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html#stsapi_comparison}{Comparing the AWS STS APIs}
in the \emph{IAM User Guide}.
}
\details{
The temporary security credentials returned by this operation consist of
an access key ID, a secret access key, and a security token.
Applications can use these temporary security credentials to sign calls
to AWS services.

By default, the temporary security credentials created by
\code{AssumeRoleWithSAML} last for one hour. However, you can use the
optional \code{DurationSeconds} parameter to specify the duration of your
session. Your role session lasts for the duration that you specify, or
until the time specified in the SAML authentication response's
\code{SessionNotOnOrAfter} value, whichever is shorter. You can provide a
\code{DurationSeconds} value from 900 seconds (15 minutes) up to the maximum
session duration setting for the role. This setting can have a value
from 1 hour to 12 hours. To learn how to view the maximum value for your
role, see \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html#id_roles_use_view-role-max-session}{View the Maximum Session Duration Setting for a Role}
in the \emph{IAM User Guide}. The maximum session duration limit applies when
you use the \code{AssumeRole*} API operations or the \code{assume-role*} CLI
operations but does not apply when you use those operations to create a
console URL. For more information, see \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html}{Using IAM Roles}
in the \emph{IAM User Guide}.

The temporary security credentials created by \code{AssumeRoleWithSAML} can
be used to make API calls to any AWS service with the following
exception: you cannot call the STS service's \code{GetFederationToken} or
\code{GetSessionToken} APIs.

Optionally, you can pass an IAM access policy to this operation. If you
choose not to pass a policy, the temporary security credentials that are
returned by the operation have the permissions that are defined in the
access policy of the role that is being assumed. If you pass a policy to
this operation, the temporary security credentials that are returned by
the operation have the permissions that are allowed by the intersection
of both the access policy of the role that is being assumed, \emph{\strong{and}}
the policy that you pass. This means that both policies must grant the
permission for the action to be allowed. This gives you a way to further
restrict the permissions for the resulting temporary security
credentials. You cannot use the passed policy to grant permissions that
are in excess of those allowed by the access policy of the role that is
being assumed. For more information, see \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_assumerole.html}{Permissions for AssumeRole, AssumeRoleWithSAML, and AssumeRoleWithWebIdentity}
in the \emph{IAM User Guide}.

Before your application can call \code{AssumeRoleWithSAML}, you must
configure your SAML identity provider (IdP) to issue the claims required
by AWS. Additionally, you must use AWS Identity and Access Management
(IAM) to create a SAML provider entity in your AWS account that
represents your identity provider, and create an IAM role that specifies
this SAML provider in its trust policy.

Calling \code{AssumeRoleWithSAML} does not require the use of AWS security
credentials. The identity of the caller is validated by using keys in
the metadata document that is uploaded for the SAML provider entity for
your identity provider.

Calling \code{AssumeRoleWithSAML} can result in an entry in your AWS
CloudTrail logs. The entry includes the value in the \code{NameID} element of
the SAML assertion. We recommend that you use a NameIDType that is not
associated with any personally identifiable information (PII). For
example, you could instead use the Persistent Identifier
(\code{urn:oasis:names:tc:SAML:2.0:nameid-format:persistent}).

For more information, see the following resources:
\itemize{
\item \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html}{About SAML 2.0-based Federation}
in the \emph{IAM User Guide}.
\item \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_create_saml.html}{Creating SAML Identity Providers}
in the \emph{IAM User Guide}.
\item \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_create_saml_relying-party.html}{Configuring a Relying Party and Claims}
in the \emph{IAM User Guide}.
\item \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-idp_saml.html}{Creating a Role for SAML 2.0 Federation}
in the \emph{IAM User Guide}.
}
}
\section{Request syntax}{
\preformatted{svc$assume_role_with_saml(
  RoleArn = "string",
  PrincipalArn = "string",
  SAMLAssertion = "string",
  Policy = "string",
  DurationSeconds = 123
)
}
}

\keyword{internal}
