% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_admin_initiate_auth}
\alias{cognitoidentityprovider_admin_initiate_auth}
\title{Initiates the authentication flow, as an administrator}
\usage{
cognitoidentityprovider_admin_initiate_auth(UserPoolId, ClientId,
  AuthFlow, AuthParameters, ClientMetadata, AnalyticsMetadata,
  ContextData)
}
\arguments{
\item{UserPoolId}{[required] The ID of the Amazon Cognito user pool.}

\item{ClientId}{[required] The app client ID.}

\item{AuthFlow}{[required] The authentication flow for this call to execute. The API action will
depend on this value. For example:
\itemize{
\item \code{REFRESH_TOKEN_AUTH} will take in a valid refresh token and return
new tokens.
\item \code{USER_SRP_AUTH} will take in \code{USERNAME} and \code{SRP_A} and return the
SRP variables to be used for next challenge execution.
\item \code{USER_PASSWORD_AUTH} will take in \code{USERNAME} and \code{PASSWORD} and
return the next challenge or tokens.
}

Valid values include:
\itemize{
\item \code{USER_SRP_AUTH}: Authentication flow for the Secure Remote Password
(SRP) protocol.
\item \code{REFRESH_TOKEN_AUTH}/\code{REFRESH_TOKEN}: Authentication flow for
refreshing the access token and ID token by supplying a valid
refresh token.
\item \code{CUSTOM_AUTH}: Custom authentication flow.
\item \code{ADMIN_NO_SRP_AUTH}: Non-SRP authentication flow; you can pass in
the USERNAME and PASSWORD directly if the flow is enabled for
calling the app client.
\item \code{USER_PASSWORD_AUTH}: Non-SRP authentication flow; USERNAME and
PASSWORD are passed directly. If a user migration Lambda trigger is
set, this flow will invoke the user migration Lambda if the USERNAME
is not found in the user pool.
\item \code{ADMIN_USER_PASSWORD_AUTH}: Admin-based user password
authentication. This replaces the \code{ADMIN_NO_SRP_AUTH} authentication
flow. In this flow, Cognito receives the password in the request
instead of using the SRP process to verify passwords.
}}

\item{AuthParameters}{The authentication parameters. These are inputs corresponding to the
\code{AuthFlow} that you are invoking. The required values depend on the
value of \code{AuthFlow}:
\itemize{
\item For \code{USER_SRP_AUTH}: \code{USERNAME} (required), \code{SRP_A} (required),
\code{SECRET_HASH} (required if the app client is configured with a
client secret), \code{DEVICE_KEY}.
\item For \code{REFRESH_TOKEN_AUTH/REFRESH_TOKEN}: \code{REFRESH_TOKEN} (required),
\code{SECRET_HASH} (required if the app client is configured with a
client secret), \code{DEVICE_KEY}.
\item For \code{ADMIN_NO_SRP_AUTH}: \code{USERNAME} (required), \code{SECRET_HASH} (if
app client is configured with client secret), \code{PASSWORD} (required),
\code{DEVICE_KEY}.
\item For \code{CUSTOM_AUTH}: \code{USERNAME} (required), \code{SECRET_HASH} (if app
client is configured with client secret), \code{DEVICE_KEY}. To start the
authentication flow with password verification, include
\code{ChallengeName: SRP_A} and \verb{SRP_A: (The SRP_A Value)}.
}}

\item{ClientMetadata}{A map of custom key-value pairs that you can provide as input for
certain custom workflows that this action triggers.

You create custom workflows by assigning AWS Lambda functions to user
pool triggers. When you use the AdminInitiateAuth API action, Amazon
Cognito invokes the AWS Lambda functions that are specified for various
triggers. The ClientMetadata value is passed as input to the functions
for only the following triggers:
\itemize{
\item Pre signup
\item Pre authentication
\item User migration
}

When Amazon Cognito invokes the functions for these triggers, it passes
a JSON payload, which the function receives as input. This payload
contains a \code{validationData} attribute, which provides the data that you
assigned to the ClientMetadata parameter in your AdminInitiateAuth
request. In your function code in AWS Lambda, you can process the
\code{validationData} value to enhance your workflow for your specific needs.

When you use the AdminInitiateAuth API action, Amazon Cognito also
invokes the functions for the following triggers, but it does not
provide the ClientMetadata value as input:
\itemize{
\item Post authentication
\item Custom message
\item Pre token generation
\item Create auth challenge
\item Define auth challenge
\item Verify auth challenge
}

For more information, see \href{https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html}{Customizing User Pool Workflows with Lambda Triggers}
in the \emph{Amazon Cognito Developer Guide}.

Take the following limitations into consideration when you use the
ClientMetadata parameter:
\itemize{
\item Amazon Cognito does not store the ClientMetadata value. This data is
available only to AWS Lambda triggers that are assigned to a user
pool to support custom workflows. If your user pool configuration
does not include triggers, the ClientMetadata parameter serves no
purpose.
\item Amazon Cognito does not validate the ClientMetadata value.
\item Amazon Cognito does not encrypt the the ClientMetadata value, so
don't use it to provide sensitive information.
}}

\item{AnalyticsMetadata}{The analytics metadata for collecting Amazon Pinpoint metrics for
\code{AdminInitiateAuth} calls.}

\item{ContextData}{Contextual data such as the user's device fingerprint, IP address, or
location used for evaluating the risk of an unexpected event by Amazon
Cognito advanced security.}
}
\description{
Initiates the authentication flow, as an administrator.

Calling this action requires developer credentials.
}
\section{Request syntax}{
\preformatted{svc$admin_initiate_auth(
  UserPoolId = "string",
  ClientId = "string",
  AuthFlow = "USER_SRP_AUTH"|"REFRESH_TOKEN_AUTH"|"REFRESH_TOKEN"|"CUSTOM_AUTH"|"ADMIN_NO_SRP_AUTH"|"USER_PASSWORD_AUTH"|"ADMIN_USER_PASSWORD_AUTH",
  AuthParameters = list(
    "string"
  ),
  ClientMetadata = list(
    "string"
  ),
  AnalyticsMetadata = list(
    AnalyticsEndpointId = "string"
  ),
  ContextData = list(
    IpAddress = "string",
    ServerName = "string",
    ServerPath = "string",
    HttpHeaders = list(
      list(
        headerName = "string",
        headerValue = "string"
      )
    ),
    EncodedData = "string"
  )
)
}
}

\keyword{internal}
