% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_list_resource_tags}
\alias{kms_list_resource_tags}
\title{Returns all tags on the specified customer master key (CMK)}
\usage{
kms_list_resource_tags(KeyId, Limit, Marker)
}
\arguments{
\item{KeyId}{[required] A unique identifier for the customer master key (CMK).

Specify the key ID or the Amazon Resource Name (ARN) of the CMK.

For example:
\itemize{
\item Key ID: \verb{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\verb{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
}

To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.}

\item{Limit}{Use this parameter to specify the maximum number of items to return.
When this value is present, AWS KMS does not return more than the
specified number of items, but it might return fewer.

This value is optional. If you include a value, it must be between 1 and
50, inclusive. If you do not include a value, it defaults to 50.}

\item{Marker}{Use this parameter in a subsequent request after you receive a response
with truncated results. Set it to the value of \code{NextMarker} from the
truncated response you just received.

Do not attempt to construct this value. Use only the value of
\code{NextMarker} from the truncated response you just received.}
}
\description{
Returns all tags on the specified customer master key (CMK).

For general information about tags, including the format and syntax, see
\href{https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html}{Tagging AWS resources}
in the \emph{Amazon Web Services General Reference}. For information about
using tags in AWS KMS, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/tagging-keys.html}{Tagging keys}.

\strong{Cross-account use}: No. You cannot perform this operation on a CMK in
a different AWS account.

\strong{Required permissions}:
\href{https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html}{kms:ListResourceTags}
(key policy)

\strong{Related operations:}
\itemize{
\item TagResource
\item UntagResource
}
}
\section{Request syntax}{
\preformatted{svc$list_resource_tags(
  KeyId = "string",
  Limit = 123,
  Marker = "string"
)
}
}

\examples{
\dontrun{
# The following example lists tags for a CMK.
svc$list_resource_tags(
  KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
)
}

}
\keyword{internal}
