% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafregional_operations.R
\name{wafregional_delete_rule_group}
\alias{wafregional_delete_rule_group}
\title{This is AWS WAF Classic documentation}
\usage{
wafregional_delete_rule_group(RuleGroupId, ChangeToken)
}
\arguments{
\item{RuleGroupId}{[required] The \code{RuleGroupId} of the RuleGroup that you want to delete.
\code{RuleGroupId} is returned by CreateRuleGroup and by ListRuleGroups.}

\item{ChangeToken}{[required] The value returned by the most recent call to GetChangeToken.}
}
\description{
This is \strong{AWS WAF Classic} documentation. For more information, see
\href{https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html}{AWS WAF Classic}
in the developer guide.

\strong{For the latest version of AWS WAF}, use the AWS WAFV2 API and see the
\href{https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html}{AWS WAF Developer Guide}.
With the latest version, AWS WAF has a single set of endpoints for
regional and global use.

Permanently deletes a RuleGroup. You can't delete a \code{RuleGroup} if it's
still used in any \code{WebACL} objects or if it still includes any rules.

If you just want to remove a \code{RuleGroup} from a \code{WebACL}, use
UpdateWebACL.

To permanently delete a \code{RuleGroup} from AWS WAF, perform the following
steps:
\enumerate{
\item Update the \code{RuleGroup} to remove rules, if any. For more
information, see UpdateRuleGroup.
\item Use GetChangeToken to get the change token that you provide in the
\code{ChangeToken} parameter of a \code{DeleteRuleGroup} request.
\item Submit a \code{DeleteRuleGroup} request.
}
}
\section{Request syntax}{
\preformatted{svc$delete_rule_group(
  RuleGroupId = "string",
  ChangeToken = "string"
)
}
}

\keyword{internal}
