% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clouddirectory_operations.R
\name{clouddirectory_list_object_policies}
\alias{clouddirectory_list_object_policies}
\title{Returns policies attached to an object in pagination fashion}
\usage{
clouddirectory_list_object_policies(DirectoryArn, ObjectReference,
  NextToken, MaxResults, ConsistencyLevel)
}
\arguments{
\item{DirectoryArn}{[required] The Amazon Resource Name (ARN) that is associated with the Directory
where objects reside. For more information, see arns.}

\item{ObjectReference}{[required] Reference that identifies the object for which policies will be listed.}

\item{NextToken}{The pagination token.}

\item{MaxResults}{The maximum number of items to be retrieved in a single call. This is an
approximate number.}

\item{ConsistencyLevel}{Represents the manner and timing in which the successful write or update
of an object is reflected in a subsequent read operation of that same
object.}
}
\value{
A list with the following syntax:\preformatted{list(
  AttachedPolicyIds = list(
    "string"
  ),
  NextToken = "string"
)
}
}
\description{
Returns policies attached to an object in pagination fashion.
}
\section{Request syntax}{
\preformatted{svc$list_object_policies(
  DirectoryArn = "string",
  ObjectReference = list(
    Selector = "string"
  ),
  NextToken = "string",
  MaxResults = 123,
  ConsistencyLevel = "SERIALIZABLE"|"EVENTUAL"
)
}
}

\keyword{internal}
