% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directoryservice_operations.R
\name{directoryservice_start_schema_extension}
\alias{directoryservice_start_schema_extension}
\title{Applies a schema extension to a Microsoft AD directory}
\usage{
directoryservice_start_schema_extension(DirectoryId,
  CreateSnapshotBeforeSchemaExtension, LdifContent, Description)
}
\arguments{
\item{DirectoryId}{[required] The identifier of the directory for which the schema extension will be
applied to.}

\item{CreateSnapshotBeforeSchemaExtension}{[required] If true, creates a snapshot of the directory before applying the schema
extension.}

\item{LdifContent}{[required] The LDIF file represented as a string. To construct the LdifContent
string, precede each line as it would be formatted in an ldif file with
\\n. See the example request below for more details. The file size can
be no larger than 1MB.}

\item{Description}{[required] A description of the schema extension.}
}
\value{
A list with the following syntax:\preformatted{list(
  SchemaExtensionId = "string"
)
}
}
\description{
Applies a schema extension to a Microsoft AD directory.
}
\section{Request syntax}{
\preformatted{svc$start_schema_extension(
  DirectoryId = "string",
  CreateSnapshotBeforeSchemaExtension = TRUE|FALSE,
  LdifContent = "string",
  Description = "string"
)
}
}

\keyword{internal}
