% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_update_role_description}
\alias{iam_update_role_description}
\title{Use UpdateRole instead}
\usage{
iam_update_role_description(RoleName, Description)
}
\arguments{
\item{RoleName}{[required] The name of the role that you want to modify.}

\item{Description}{[required] The new description that you want to apply to the specified role.}
}
\value{
A list with the following syntax:\preformatted{list(
  Role = list(
    Path = "string",
    RoleName = "string",
    RoleId = "string",
    Arn = "string",
    CreateDate = as.POSIXct(
      "2015-01-01"
    ),
    AssumeRolePolicyDocument = "string",
    Description = "string",
    MaxSessionDuration = 123,
    PermissionsBoundary = list(
      PermissionsBoundaryType = "PermissionsBoundaryPolicy",
      PermissionsBoundaryArn = "string"
    ),
    Tags = list(
      list(
        Key = "string",
        Value = "string"
      )
    ),
    RoleLastUsed = list(
      LastUsedDate = as.POSIXct(
        "2015-01-01"
      ),
      Region = "string"
    )
  )
)
}
}
\description{
Use \code{\link[=iam_update_role]{update_role}} instead.

Modifies only the description of a role. This operation performs the
same function as the \code{Description} parameter in the
\code{\link[=iam_update_role]{update_role}} operation.
}
\section{Request syntax}{
\preformatted{svc$update_role_description(
  RoleName = "string",
  Description = "string"
)
}
}

\keyword{internal}
