% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_create_custom_key_store}
\alias{kms_create_custom_key_store}
\title{Creates a custom key store that is associated with an AWS CloudHSM
cluster that you own and manage}
\usage{
kms_create_custom_key_store(CustomKeyStoreName, CloudHsmClusterId,
  TrustAnchorCertificate, KeyStorePassword)
}
\arguments{
\item{CustomKeyStoreName}{[required] Specifies a friendly name for the custom key store. The name must be
unique in your AWS account.}

\item{CloudHsmClusterId}{[required] Identifies the AWS CloudHSM cluster for the custom key store. Enter the
cluster ID of any active AWS CloudHSM cluster that is not already
associated with a custom key store. To find the cluster ID, use the
\href{https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html}{DescribeClusters}
operation.}

\item{TrustAnchorCertificate}{[required] Enter the content of the trust anchor certificate for the cluster. This
is the content of the \code{customerCA.crt} file that you created when you
\href{https://docs.aws.amazon.com/cloudhsm/latest/userguide/initialize-cluster.html}{initialized the cluster}.}

\item{KeyStorePassword}{[required] Enter the password of the \href{https://docs.aws.amazon.com/kms/latest/developerguide/key-store-concepts.html#concept-kmsuser}{\code{kmsuser} crypto user (CU) account}
in the specified AWS CloudHSM cluster. AWS KMS logs into the cluster as
this user to manage key material on your behalf.

The password must be a string of 7 to 32 characters. Its value is case
sensitive.

This parameter tells AWS KMS the \code{kmsuser} account password; it does not
change the password in the AWS CloudHSM cluster.}
}
\value{
A list with the following syntax:\preformatted{list(
  CustomKeyStoreId = "string"
)
}
}
\description{
Creates a \href{https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html}{custom key store}
that is associated with an \href{https://docs.aws.amazon.com/cloudhsm/latest/userguide/clusters.html}{AWS CloudHSM cluster}
that you own and manage.

This operation is part of the \href{https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html}{Custom Key Store feature}
feature in AWS KMS, which combines the convenience and extensive
integration of AWS KMS with the isolation and control of a single-tenant
key store.

Before you create the custom key store, you must assemble the required
elements, including an AWS CloudHSM cluster that fulfills the
requirements for a custom key store. For details about the required
elements, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/create-keystore.html#before-keystore}{Assemble the Prerequisites}
in the \emph{AWS Key Management Service Developer Guide}.

When the operation completes successfully, it returns the ID of the new
custom key store. Before you can use your new custom key store, you need
to use the \code{\link[=kms_connect_custom_key_store]{connect_custom_key_store}}
operation to connect the new key store to its AWS CloudHSM cluster. Even
if you are not going to use your custom key store immediately, you might
want to connect it to verify that all settings are correct and then
disconnect it until you are ready to use it.

For help with failures, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html}{Troubleshooting a Custom Key Store}
in the \emph{AWS Key Management Service Developer Guide}.

\strong{Cross-account use}: No. You cannot perform this operation on a custom
key store in a different AWS account.

\strong{Required permissions}:
\href{https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html}{kms:CreateCustomKeyStore}
(IAM policy).

\strong{Related operations:}
\itemize{
\item \code{\link[=kms_connect_custom_key_store]{connect_custom_key_store}}
\item \code{\link[=kms_delete_custom_key_store]{delete_custom_key_store}}
\item \code{\link[=kms_describe_custom_key_stores]{describe_custom_key_stores}}
\item \code{\link[=kms_disconnect_custom_key_store]{disconnect_custom_key_store}}
\item \code{\link[=kms_update_custom_key_store]{update_custom_key_store}}
}
}
\section{Request syntax}{
\preformatted{svc$create_custom_key_store(
  CustomKeyStoreName = "string",
  CloudHsmClusterId = "string",
  TrustAnchorCertificate = "string",
  KeyStorePassword = "string"
)
}
}

\keyword{internal}
