% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guardduty_operations.R
\name{guardduty_get_member_detectors}
\alias{guardduty_get_member_detectors}
\title{Describes which data sources are enabled for the member account's
detector}
\usage{
guardduty_get_member_detectors(DetectorId, AccountIds)
}
\arguments{
\item{DetectorId}{[required] The detector ID for the administrator account.}

\item{AccountIds}{[required] The account ID of the member account.}
}
\value{
A list with the following syntax:\preformatted{list(
  MemberDataSourceConfigurations = list(
    list(
      AccountId = "string",
      DataSources = list(
        CloudTrail = list(
          Status = "ENABLED"|"DISABLED"
        ),
        DNSLogs = list(
          Status = "ENABLED"|"DISABLED"
        ),
        FlowLogs = list(
          Status = "ENABLED"|"DISABLED"
        ),
        S3Logs = list(
          Status = "ENABLED"|"DISABLED"
        )
      )
    )
  ),
  UnprocessedAccounts = list(
    list(
      AccountId = "string",
      Result = "string"
    )
  )
)
}
}
\description{
Describes which data sources are enabled for the member account's
detector.
}
\section{Request syntax}{
\preformatted{svc$get_member_detectors(
  DetectorId = "string",
  AccountIds = list(
    "string"
  )
)
}
}

\keyword{internal}
