% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_update_open_id_connect_provider_thumbprint}
\alias{iam_update_open_id_connect_provider_thumbprint}
\title{Replaces the existing list of server certificate thumbprints associated
with an OpenID Connect (OIDC) provider resource object with a new list
of thumbprints}
\usage{
iam_update_open_id_connect_provider_thumbprint(OpenIDConnectProviderArn,
  ThumbprintList)
}
\arguments{
\item{OpenIDConnectProviderArn}{[required] The Amazon Resource Name (ARN) of the IAM OIDC provider resource object
for which you want to update the thumbprint. You can get a list of OIDC
provider ARNs by using the
\code{\link[=iam_list_open_id_connect_providers]{list_open_id_connect_providers}}
operation.

For more information about ARNs, see \href{https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html}{Amazon Resource Names (ARNs) and AWS Service Namespaces}
in the \emph{AWS General Reference}.}

\item{ThumbprintList}{[required] A list of certificate thumbprints that are associated with the specified
IAM OpenID Connect provider. For more information, see
\code{\link[=iam_create_open_id_connect_provider]{create_open_id_connect_provider}}.}
}
\value{
An empty list.
}
\description{
Replaces the existing list of server certificate thumbprints associated
with an OpenID Connect (OIDC) provider resource object with a new list
of thumbprints.

The list that you pass with this operation completely replaces the
existing list of thumbprints. (The lists are not merged.)

Typically, you need to update a thumbprint only when the identity
provider's certificate changes, which occurs rarely. However, if the
provider's certificate \emph{does} change, any attempt to assume an IAM role
that specifies the OIDC provider as a principal fails until the
certificate thumbprint is updated.

Trust for the OIDC provider is derived from the provider's certificate
and is validated by the thumbprint. Therefore, it is best to limit
access to the
\code{\link[=iam_update_open_id_connect_provider_thumbprint]{update_open_id_connect_provider_thumbprint}}
operation to highly privileged users.
}
\section{Request syntax}{
\preformatted{svc$update_open_id_connect_provider_thumbprint(
  OpenIDConnectProviderArn = "string",
  ThumbprintList = list(
    "string"
  )
)
}
}

\keyword{internal}
