% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentity_operations.R
\name{cognitoidentity_tag_resource}
\alias{cognitoidentity_tag_resource}
\title{Assigns a set of tags to an Amazon Cognito identity pool}
\usage{
cognitoidentity_tag_resource(ResourceArn, Tags)
}
\arguments{
\item{ResourceArn}{[required] The Amazon Resource Name (ARN) of the identity pool to assign the tags
to.}

\item{Tags}{The tags to assign to the identity pool.}
}
\description{
Assigns a set of tags to an Amazon Cognito identity pool. A tag is a
label that you can use to categorize and manage identity pools in
different ways, such as by purpose, owner, environment, or other
criteria.
}
\details{
Each tag consists of a key and value, both of which you define. A key is
a general category for more specific values. For example, if you have
two versions of an identity pool, one for testing and another for
production, you might assign an \code{Environment} tag key to both identity
pools. The value of this key might be \code{Test} for one identity pool and
\code{Production} for the other.

Tags are useful for cost tracking and access control. You can activate
your tags so that they appear on the Billing and Cost Management
console, where you can track the costs associated with your identity
pools. In an IAM policy, you can constrain permissions for identity
pools based on specific tags or tag values.

You can use this action up to 5 times per second, per account. An
identity pool can have as many as 50 tags.
}
\section{Request syntax}{
\preformatted{svc$tag_resource(
  ResourceArn = "string",
  Tags = list(
    "string"
  )
)
}
}

\keyword{internal}
