% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_get_organizations_access_report}
\alias{iam_get_organizations_access_report}
\title{Retrieves the service last accessed data report for AWS Organizations
that was previously generated using the
GenerateOrganizationsAccessReport operation}
\usage{
iam_get_organizations_access_report(JobId, MaxItems, Marker, SortKey)
}
\arguments{
\item{JobId}{[required] The identifier of the request generated by the
GenerateOrganizationsAccessReport operation.}

\item{MaxItems}{Use this only when paginating results to indicate the maximum number of
items you want in the response. If additional items exist beyond the
maximum you specify, the \code{IsTruncated} response element is \code{true}.

If you do not include this parameter, the number of items defaults to
100. Note that IAM might return fewer results, even when there are more
results available. In that case, the \code{IsTruncated} response element
returns \code{true}, and \code{Marker} contains a value to include in the
subsequent call that tells the service where to continue from.}

\item{Marker}{Use this parameter only when paginating results and only after you
receive a response indicating that the results are truncated. Set it to
the value of the \code{Marker} element in the response that you received to
indicate where the next call should start.}

\item{SortKey}{The key that is used to sort the results. If you choose the namespace
key, the results are returned in alphabetical order. If you choose the
time key, the results are sorted numerically by the date and time.}
}
\description{
Retrieves the service last accessed data report for AWS Organizations
that was previously generated using the
\code{<a>GenerateOrganizationsAccessReport</a>} operation. This operation
retrieves the status of your report job and the report contents.
}
\details{
Depending on the parameters that you passed when you generated the
report, the data returned could include different information. For
details, see GenerateOrganizationsAccessReport.

To call this operation, you must be signed in to the master account in
your organization. SCPs must be enabled for your organization root. You
must have permissions to perform this operation. For more information,
see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html}{Refining Permissions Using Service Last Accessed Data}
in the \emph{IAM User Guide}.

For each service that principals in an account (root users, IAM users,
or IAM roles) could access using SCPs, the operation returns details
about the most recent access attempt. If there was no attempt, the
service is listed without details about the most recent attempt to
access the service. If the operation fails, it returns the reason that
it failed.

By default, the list is sorted by service namespace.
}
\section{Request syntax}{
\preformatted{svc$get_organizations_access_report(
  JobId = "string",
  MaxItems = 123,
  Marker = "string",
  SortKey = "SERVICE_NAMESPACE_ASCENDING"|"SERVICE_NAMESPACE_DESCENDING"|"LAST_AUTHENTICATED_TIME_ASCENDING"|"LAST_AUTHENTICATED_TIME_DESCENDING"
)
}
}

\examples{
# The following operation gets details about the report with the job ID:
# examplea-1234-b567-cde8-90fg123abcd4
\donttest{svc$get_organizations_access_report(
  JobId = "examplea-1234-b567-cde8-90fg123abcd4"
)}

}
\keyword{internal}
