% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafregional_operations.R
\name{wafregional_get_change_token}
\alias{wafregional_get_change_token}
\title{When you want to create, update, or delete AWS WAF objects, get a change
token and include the change token in the create, update, or delete
request}
\usage{
wafregional_get_change_token()
}
\description{
When you want to create, update, or delete AWS WAF objects, get a change
token and include the change token in the create, update, or delete
request. Change tokens ensure that your application doesn't submit
conflicting requests to AWS WAF.
}
\details{
Each create, update, or delete request must use a unique change token.
If your application submits a \code{GetChangeToken} request and then submits
a second \code{GetChangeToken} request before submitting a create, update, or
delete request, the second \code{GetChangeToken} request returns the same
value as the first \code{GetChangeToken} request.

When you use a change token in a create, update, or delete request, the
status of the change token changes to \code{PENDING}, which indicates that
AWS WAF is propagating the change to all AWS WAF servers. Use
\code{GetChangeTokenStatus} to determine the status of your change token.
}
\section{Request syntax}{
\preformatted{svc$get_change_token()
}
}

\examples{
# The following example returns a change token to use for a create, update
# or delete operation.
\donttest{svc$get_change_token()}

}
\keyword{internal}
