% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_list_signing_certificates}
\alias{iam_list_signing_certificates}
\title{Returns information about the signing certificates associated with the
specified IAM user}
\usage{
iam_list_signing_certificates(UserName, Marker, MaxItems)
}
\arguments{
\item{UserName}{The name of the IAM user whose signing certificates you want to examine.

This parameter allows (through its \href{http://wikipedia.org/wiki/regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: \\_+=,.@-}

\item{Marker}{Use this parameter only when paginating results and only after you
receive a response indicating that the results are truncated. Set it to
the value of the \code{Marker} element in the response that you received to
indicate where the next call should start.}

\item{MaxItems}{Use this only when paginating results to indicate the maximum number of
items you want in the response. If additional items exist beyond the
maximum you specify, the \code{IsTruncated} response element is \code{true}.

If you do not include this parameter, the number of items defaults to
100. Note that IAM might return fewer results, even when there are more
results available. In that case, the \code{IsTruncated} response element
returns \code{true}, and \code{Marker} contains a value to include in the
subsequent call that tells the service where to continue from.}
}
\description{
Returns information about the signing certificates associated with the
specified IAM user. If none exists, the operation returns an empty list.
}
\details{
Although each user is limited to a small number of signing certificates,
you can still paginate the results using the \code{MaxItems} and \code{Marker}
parameters.

If the \code{UserName} field is not specified, the user name is determined
implicitly based on the AWS access key ID used to sign the request for
this API. This operation works for access keys under the AWS account.
Consequently, you can use this operation to manage AWS account root user
credentials even if the AWS account has no associated users.
}
\section{Request syntax}{
\preformatted{svc$list_signing_certificates(
  UserName = "string",
  Marker = "string",
  MaxItems = 123
)
}
}

\examples{
# The following command lists the signing certificates for the IAM user
# named Bob.
\donttest{svc$list_signing_certificates(
  UserName = "Bob"
)}

}
\keyword{internal}
