% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_delete_alias}
\alias{kms_delete_alias}
\title{Deletes the specified alias}
\usage{
kms_delete_alias(AliasName)
}
\arguments{
\item{AliasName}{[required] The alias to be deleted. The alias name must begin with \verb{alias/}
followed by the alias name, such as \code{alias/ExampleAlias}.}
}
\description{
Deletes the specified alias. You cannot perform this operation on an
alias in a different AWS account.
}
\details{
Because an alias is not a property of a CMK, you can delete and change
the aliases of a CMK without affecting the CMK. Also, aliases do not
appear in the response from the DescribeKey operation. To get the
aliases of all CMKs, use the ListAliases operation.

Each CMK can have multiple aliases. To change the alias of a CMK, use
DeleteAlias to delete the current alias and CreateAlias to create a new
alias. To associate an existing alias with a different customer master
key (CMK), call UpdateAlias.
}
\section{Request syntax}{
\preformatted{svc$delete_alias(
  AliasName = "string"
)
}
}

\examples{
# The following example deletes the specified alias.
\donttest{svc$delete_alias(
  AliasName = "alias/ExampleAlias"
)}

}
\keyword{internal}
