% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guardduty_operations.R
\name{guardduty_create_publishing_destination}
\alias{guardduty_create_publishing_destination}
\title{Creates a publishing destination to send findings to}
\usage{
guardduty_create_publishing_destination(DetectorId, DestinationType,
  DestinationProperties, ClientToken)
}
\arguments{
\item{DetectorId}{[required] The ID of the GuardDuty detector associated with the publishing
destination.}

\item{DestinationType}{[required] The type of resource for the publishing destination. Currently only S3
is supported.}

\item{DestinationProperties}{[required] Properties of the publishing destination, including the ARNs for the
destination and the KMS key used for encryption.}

\item{ClientToken}{The idempotency token for the request.}
}
\description{
Creates a publishing destination to send findings to. The resource to
send findings to must exist before you use this operation.
}
\section{Request syntax}{
\preformatted{svc$create_publishing_destination(
  DetectorId = "string",
  DestinationType = "S3",
  DestinationProperties = list(
    DestinationArn = "string",
    KmsKeyArn = "string"
  ),
  ClientToken = "string"
)
}
}

\keyword{internal}
