% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafregional_operations.R
\name{wafregional_delete_size_constraint_set}
\alias{wafregional_delete_size_constraint_set}
\title{Permanently deletes a SizeConstraintSet}
\usage{
wafregional_delete_size_constraint_set(SizeConstraintSetId, ChangeToken)
}
\arguments{
\item{SizeConstraintSetId}{[required] The \code{SizeConstraintSetId} of the SizeConstraintSet that you want to
delete. \code{SizeConstraintSetId} is returned by CreateSizeConstraintSet and
by ListSizeConstraintSets.}

\item{ChangeToken}{[required] The value returned by the most recent call to GetChangeToken.}
}
\description{
Permanently deletes a SizeConstraintSet. You can\'t delete a
\code{SizeConstraintSet} if it\'s still used in any \code{Rules} or if it still
includes any SizeConstraint objects (any filters).
}
\details{
If you just want to remove a \code{SizeConstraintSet} from a \code{Rule}, use
UpdateRule.

To permanently delete a \code{SizeConstraintSet}, perform the following
steps:
\enumerate{
\item Update the \code{SizeConstraintSet} to remove filters, if any. For more
information, see UpdateSizeConstraintSet.
\item Use GetChangeToken to get the change token that you provide in the
\code{ChangeToken} parameter of a \code{DeleteSizeConstraintSet} request.
\item Submit a \code{DeleteSizeConstraintSet} request.
}
}
\section{Request syntax}{
\preformatted{svc$delete_size_constraint_set(
  SizeConstraintSetId = "string",
  ChangeToken = "string"
)
}
}

\examples{
# The following example deletes a size constraint set  with the ID
# example1ds3t-46da-4fdb-b8d5-abc321j569j5.
\dontrun{svc$delete_size_constraint_set(
  ChangeToken = "abcd12f2-46da-4fdb-b8d5-fbd4c466928f",
  SizeConstraintSetId = "example1ds3t-46da-4fdb-b8d5-abc321j569j5"
)}

}
\keyword{internal}
