% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waf_operations.R
\name{waf_create_byte_match_set}
\alias{waf_create_byte_match_set}
\title{Creates a ByteMatchSet}
\usage{
waf_create_byte_match_set(Name, ChangeToken)
}
\arguments{
\item{Name}{[required] A friendly name or description of the ByteMatchSet. You can\'t change
\code{Name} after you create a \code{ByteMatchSet}.}

\item{ChangeToken}{[required] The value returned by the most recent call to GetChangeToken.}
}
\description{
Creates a \code{ByteMatchSet}. You then use UpdateByteMatchSet to identify
the part of a web request that you want AWS WAF to inspect, such as the
values of the \code{User-Agent} header or the query string. For example, you
can create a \code{ByteMatchSet} that matches any requests with \code{User-Agent}
headers that contain the string \code{BadBot}. You can then configure AWS WAF
to reject those requests.
}
\details{
To create and configure a \code{ByteMatchSet}, perform the following steps:
\enumerate{
\item Use GetChangeToken to get the change token that you provide in the
\code{ChangeToken} parameter of a \code{CreateByteMatchSet} request.
\item Submit a \code{CreateByteMatchSet} request.
\item Use \code{GetChangeToken} to get the change token that you provide in the
\code{ChangeToken} parameter of an \code{UpdateByteMatchSet} request.
\item Submit an UpdateByteMatchSet request to specify the part of the
request that you want AWS WAF to inspect (for example, the header or
the URI) and the value that you want AWS WAF to watch for.
}

For more information about how to use the AWS WAF API to allow or block
HTTP requests, see the \href{https://docs.aws.amazon.com/waf/latest/developerguide/}{AWS WAF Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_byte_match_set(
  Name = "string",
  ChangeToken = "string"
)
}
}

\keyword{internal}
