% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_generate_data_key_pair_without_plaintext}
\alias{kms_generate_data_key_pair_without_plaintext}
\title{Generates a unique asymmetric data key pair}
\usage{
kms_generate_data_key_pair_without_plaintext(EncryptionContext, KeyId,
  KeyPairSpec, GrantTokens)
}
\arguments{
\item{EncryptionContext}{Specifies the encryption context that will be used when encrypting the
private key in the data key pair.

An \emph{encryption context} is a collection of non-secret key-value pairs
that represents additional authenticated data. When you use an
encryption context to encrypt data, you must specify the same (an exact
case-sensitive match) encryption context to decrypt the data. An
encryption context is optional when encrypting with a symmetric CMK, but
it is highly recommended.

For more information, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context}{Encryption Context}
in the \emph{AWS Key Management Service Developer Guide}.}

\item{KeyId}{[required] Specifies the CMK that encrypts the private key in the data key pair.
You must specify a symmetric CMK. You cannot use an asymmetric CMK or a
CMK in a custom key store. To get the type and origin of your CMK, use
the DescribeKey operation.

To specify a CMK, use its key ID, Amazon Resource Name (ARN), alias
name, or alias ARN. When using an alias name, prefix it with \code{"alias/"}.

For example:
\itemize{
\item Key ID: \verb{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\verb{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
\item Alias name: \code{alias/ExampleAlias}
\item Alias ARN: \code{arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias}
}

To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey. To
get the alias name and alias ARN, use ListAliases.}

\item{KeyPairSpec}{[required] Determines the type of data key pair that is generated.

The AWS KMS rule that restricts the use of asymmetric RSA CMKs to
encrypt and decrypt or to sign and verify (but not both), and the rule
that permits you to use ECC CMKs only to sign and verify, are not
effective outside of AWS KMS.}

\item{GrantTokens}{A list of grant tokens.

For more information, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token}{Grant Tokens}
in the \emph{AWS Key Management Service Developer Guide}.}
}
\description{
Generates a unique asymmetric data key pair. The
\code{GenerateDataKeyPairWithoutPlaintext} operation returns a plaintext
public key and a copy of the private key that is encrypted under the
symmetric CMK you specify. Unlike GenerateDataKeyPair, this operation
does not return a plaintext private key.
}
\details{
To generate a data key pair, you must specify a symmetric customer
master key (CMK) to encrypt the private key in the data key pair. You
cannot use an asymmetric CMK or a CMK in a custom key store. To get the
type and origin of your CMK, use the \code{KeySpec} field in the DescribeKey
response.

You can use the public key that \code{GenerateDataKeyPairWithoutPlaintext}
returns to encrypt data or verify a signature outside of AWS KMS. Then,
store the encrypted private key with the data. When you are ready to
decrypt data or sign a message, you can use the Decrypt operation to
decrypt the encrypted private key.

\code{GenerateDataKeyPairWithoutPlaintext} returns a unique data key pair for
each request. The bytes in the key are not related to the caller or CMK
that is used to encrypt the private key.

You can use the optional encryption context to add additional security
to the encryption operation. If you specify an \code{EncryptionContext}, you
must specify the same encryption context (a case-sensitive exact match)
when decrypting the encrypted data key. Otherwise, the request to
decrypt fails with an \code{InvalidCiphertextException}. For more
information, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context}{Encryption Context}
in the \emph{AWS Key Management Service Developer Guide}.

The CMK that you use for this operation must be in a compatible key
state. For details, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html}{How Key State Affects Use of a Customer Master Key}
in the \emph{AWS Key Management Service Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$generate_data_key_pair_without_plaintext(
  EncryptionContext = list(
    "string"
  ),
  KeyId = "string",
  KeyPairSpec = "RSA_2048"|"RSA_3072"|"RSA_4096"|"ECC_NIST_P256"|"ECC_NIST_P384"|"ECC_NIST_P521"|"ECC_SECG_P256K1",
  GrantTokens = list(
    "string"
  )
)
}
}

\keyword{internal}
